# A.1.5 - Author - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.1.5 - Author**

## Logical Model: A.1.5 - Author 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/AuthorCz | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnAuthorLabEhnCz |

 
Author (by whom the Laboratory result report or a subset of its results was authored). Section A1.5 of the eHN guideline. 

**Usages:**

* Use this Logical Model: [A - Laboratory Report](StructureDefinition-LabReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/AuthorCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-AuthorCz.csv), [Excel](StructureDefinition-AuthorCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AuthorCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/AuthorCz",
  "version" : "0.5.0",
  "name" : "LogEnAuthorLabEhnCz",
  "title" : "A.1.5 - Author",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Author (by whom the Laboratory result report or a subset of its results was authored). Section A1.5 of the eHN guideline.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/AuthorCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "AuthorCz",
        "path" : "AuthorCz",
        "short" : "A.1.5 - Author",
        "definition" : "Author (by whom the Laboratory result report or a subset of its results was authored). Section A1.5 of the eHN guideline."
      },
      {
        "id" : "AuthorCz.identifier",
        "path" : "AuthorCz.identifier",
        "short" : "A.1.5.1 Author identifier",
        "definition" : "The health professional or authoring device identification number. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the license or registration number.  ",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "AuthorCz.name",
        "path" : "AuthorCz.name",
        "short" : "A.1.5.2 Author name",
        "definition" : "Person or device name. ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "AuthorCz.organizationIdentifier",
        "path" : "AuthorCz.organizationIdentifier",
        "short" : "A.1.5.3 Author organization identifier",
        "definition" : "Identifier of the organization the author represents.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "AuthorCz.organization",
        "path" : "AuthorCz.organization",
        "short" : "A.1.5.4 Author organization",
        "definition" : "The healthcare provider organization the author represents. ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "AuthorCz.dateOfSaving",
        "path" : "AuthorCz.dateOfSaving",
        "short" : "A.1.5.5 Date and time of saving.",
        "definition" : "The date and time the document was last modified.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
