# Zyrgana - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Zyrgana**

## Example Patient: Zyrgana

Profile: [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

Zyrgana Prouzdalová Female, DoB: 1982-03-17 ( Passport number (use: official, ))

-------

| | |
| :--- | :--- |
| Other Ids: | * `https://ncez.mzcr.cz/fhir/sid/rcis`/8203171234 (use: official, )
* `https://ncez.mzcr.cz/fhir/sid/rid`/1122334455
* Passport number/CZE9876543 (use: official, )
 |
| Contact Detail | * [+420777123987](tel:+420777123987)
* U Roury 42, 999 99, Počernice n. Mokrou(home)
 |
| Languages: | * Czech (preferred)
* French
 |
| Links: | * General Practitioner: MUDr. Kvido Polštář (Identifier: `https://ncez.mzcr.cz/fhir/sid/nrzp`/876543210)
 |
| Patient Nationality: | * code: Czechia
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "c60b7c0e-0d8c-4e43-9f52-86d1dcf1a43c",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "code",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "urn:iso:std:iso:3166",
                "code" : "CZ"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/StructureDefinition/patient-nationality"
    }
  ],
  "identifier" : [
    {
      "use" : "official",
      "system" : "https://ncez.mzcr.cz/fhir/sid/rcis",
      "value" : "8203171234"
    },
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/rid",
      "value" : "1122334455"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PPN"
          }
        ]
      },
      "system" : "http://hl7.org/fhir/sid/passport-CZE",
      "value" : "CZE9876543"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PPN"
          }
        ]
      },
      "system" : "http://hl7.org/fhir/sid/passport-FRA",
      "value" : "FRA1234567"
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "family" : "Prouzdalová",
      "given" : ["Zyrgana"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+420777123987",
      "use" : "mobile"
    }
  ],
  "gender" : "female",
  "birthDate" : "1982-03-17",
  "address" : [
    {
      "use" : "home",
      "type" : "physical",
      "text" : "U Roury 42, 999 99, Počernice n. Mokrou",
      "line" : ["U Roury 42"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "U Roury"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "42"
            }
          ]
        }
      ],
      "city" : "Počernice nad Mokrou",
      "postalCode" : "99999",
      "country" : "Česko",
      "_country" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
            "valueCoding" : {
              "system" : "urn:iso:std:iso:3166",
              "code" : "CZ",
              "display" : "Czechia"
            }
          }
        ]
      }
    }
  ],
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "cs"
          }
        ]
      },
      "preferred" : true
    },
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "fr"
          }
        ]
      }
    }
  ],
  "generalPractitioner" : [
    {
      "identifier" : {
        "system" : "https://ncez.mzcr.cz/fhir/sid/nrzp",
        "value" : "876543210"
      },
      "display" : "MUDr. Kvido Polštář"
    }
  ]
}

```
