# Serum urea - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Serum urea**

## Example Observation: Serum urea



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "d1a7f3c8-0e5b-4b2a-8c91-6f4e2d7a9b35",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Device",
      "id" : "device-kit-urea",
      "manufacturer" : "Best manufacturer",
      "deviceName" : [
        {
          "name" : "Urea Enzymatic Assay Kit",
          "type" : "manufacturer-name"
        }
      ],
      "type" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "706167001"
          }
        ]
      }
    },
    {
      "resourceType" : "Device",
      "id" : "device-analyzer-urea",
      "manufacturer" : "Best manufacturer",
      "deviceName" : [
        {
          "name" : "BioAnalyt 6000",
          "type" : "manufacturer-name"
        }
      ],
      "type" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "706168006"
          }
        ]
      }
    }
  ],
  "extension" : [
    {
      "url" : "http://hl7.eu/fhir/laboratory/StructureDefinition/observation-certifiedRefMaterialCodeable",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://nibsc.org",
            "code" : "11/222",
            "display" : "Urea, certified reference material, 10 mmol/L"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.eu/fhir/laboratory/StructureDefinition/observation-deviceLabTestKit",
      "valueReference" : {
        "reference" : "#device-kit-urea"
      }
    }
  ],
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory",
          "display" : "Laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "18719-5"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
        "code" : "03086",
        "display" : "Urea (S; látková konc. [mmol/l] Absorpční spektrofotometrie)"
      }
    ],
    "text" : "S_Urea"
  },
  "subject" : {
    "reference" : "urn:uuid:c60b7c0e-0d8c-4e43-9f52-86d1dcf1a43c"
  },
  "effectiveDateTime" : "2025-04-24T08:45:00+02:00",
  "issued" : "2025-04-24T09:30:00+02:00",
  "performer" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/event-performerFunction",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                "code" : "PPRF",
                "display" : "primary performer"
              }
            ]
          }
        }
      ],
      "reference" : "urn:uuid:fab321ab-7777-4444-cccc-abcdefabcdef"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/event-performerFunction",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                "code" : "VRF",
                "display" : "verifier"
              }
            ]
          }
        }
      ],
      "reference" : "urn:uuid:aabbccdd-1111-4222-9333-ffeeddccbbcc"
    }
  ],
  "valueQuantity" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-uncertainty",
        "valueDecimal" : 0.2
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-uncertaintyType",
        "valueCode" : "N"
      }
    ],
    "value" : 8.3,
    "unit" : "mmol/L",
    "system" : "http://unitsofmeasure.org",
    "code" : "mmol/L"
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
          "code" : "H",
          "display" : "High"
        }
      ]
    }
  ],
  "method" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "70621000052105"
      }
    ]
  },
  "specimen" : {
    "reference" : "urn:uuid:fa3d8c2e-71b4-4e9c-9d2f-85b0a1f7c934"
  },
  "device" : {
    "reference" : "#device-analyzer-urea"
  },
  "referenceRange" : [
    {
      "low" : {
        "value" : 2,
        "unit" : "mmol/L",
        "system" : "http://unitsofmeasure.org",
        "code" : "mmol/L"
      },
      "high" : {
        "value" : 6.7,
        "unit" : "mmol/L",
        "system" : "http://unitsofmeasure.org",
        "code" : "mmol/L"
      },
      "appliesTo" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "248152002",
              "display" : "Female"
            }
          ]
        }
      ],
      "age" : {
        "low" : {
          "value" : 15,
          "unit" : "a"
        },
        "high" : {
          "value" : 150,
          "unit" : "a"
        }
      }
    }
  ]
}

```
