# eHN Subject to this guide Map - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **eHN Subject to this guide Map**

## ConceptMap: eHN Subject to this guide Map (Experimental) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/ConceptMap/subject2FHIR-cz-lab | *Version*:0.5.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:LabRptSubject2Fhir |

 
eHN Subject Model to this guide Map 

 
It shows how the Laboratory Report Subject data set defined by the CZ eHN guidelines is mapped into this guide 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "subject2FHIR-cz-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/ConceptMap/subject2FHIR-cz-lab",
  "version" : "0.5.0",
  "name" : "LabRptSubject2Fhir",
  "title" : "eHN Subject to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "eHN Subject Model to this guide Map",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "It shows how the Laboratory Report Subject data set defined by the CZ eHN guidelines is mapped into this guide",
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/SubjectCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
      "element" : [
        {
          "code" : "Subject.identification",
          "display" : "A.1.1 Identification of the patient/subject",
          "target" : [
            {
              "code" : "Patient",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Subject.identification.givenName",
          "display" : "A.1.1.1 Given name",
          "target" : [
            {
              "code" : "Patient.name.given",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.identification.familyName",
          "display" : "A.1.1.2 Familyname/surname",
          "target" : [
            {
              "code" : "Patient.name.family",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.identification.dateOfBirth",
          "display" : "A.1.1.3 Date of birth",
          "target" : [
            {
              "code" : "Patient.birthDate",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.identification.identifier",
          "display" : "A.1.1.4 Patient identifier",
          "target" : [
            {
              "code" : "Patient.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.identification.citizenship",
          "display" : "A.1.1.5 Citizenship",
          "target" : [
            {
              "code" : "Patient.patient-citizenship",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.identification.gender",
          "display" : "A.1.1.6 Gender",
          "target" : [
            {
              "code" : "Patient.gender",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.identification.languageOfCommunication",
          "display" : "A.1.1.7 Language of communication",
          "target" : [
            {
              "code" : "Patient.communication.language",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo",
          "display" : "A.1.2 Patient/subject related contact information",
          "target" : [
            {
              "code" : "Patient",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.address",
          "display" : "A.1.2.1 Address",
          "target" : [
            {
              "code" : "Patient.address",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.telecom",
          "display" : "A.1.2.2 Telecom",
          "target" : [
            {
              "code" : "Patient.telecom",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician",
          "display" : "A.1.2.3 Prefered physician",
          "target" : [
            {
              "code" : "Patient.generalPractitioner",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.legalRepresent",
          "display" : "A.1.2.4 Legal representatives and other contact persons",
          "target" : [
            {
              "code" : "Patient.contact",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.legalRepresent.type",
          "display" : "A.1.2.4.1 Contact type",
          "target" : [
            {
              "code" : "Patient.contact.relationship",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.legalRepresent.relationToSubject",
          "display" : "A.1.2.4.2 Relationship to the patient",
          "target" : [
            {
              "code" : "Patient.contact.relationship",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.legalRepresent.identifier",
          "display" : "A.1.2.4.3 Person identifier",
          "target" : [
            {
              "code" : "Patient.contact",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.legalRepresent.givenName",
          "display" : "A.1.2.4.4 Given name",
          "target" : [
            {
              "code" : "Patient.contact.name.given",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.legalRepresent.familyName",
          "display" : "A.1.2.4.5 Family name/surname",
          "target" : [
            {
              "code" : "Patient.contact.name.family",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.legalRepresent.address",
          "display" : "A.1.2.4.6 Contact person address",
          "target" : [
            {
              "code" : "Patient.contact.address",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.legalRepresent.telecom",
          "display" : "A.1.2.4.7 Telecom",
          "target" : [
            {
              "code" : "Patient.contact.telecom",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/SubjectCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
      "element" : [
        {
          "code" : "Subject.contactInfo.preferedPhysician",
          "display" : "A.1.2.3 Prefered physician",
          "target" : [
            {
              "code" : "Practitioner",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician.Identifier",
          "display" : "A.1.2.3.1 Identification of the prefered physician",
          "target" : [
            {
              "code" : "Practitioner.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician.Name",
          "display" : "A.1.2.3.2 Name of the prefered physician",
          "target" : [
            {
              "code" : "Practitioner.name",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician.telecom",
          "display" : "A.1.2.3.6 Telecom",
          "target" : [
            {
              "code" : "Practitioner.telecom",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/SubjectCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
      "element" : [
        {
          "code" : "Subject.contactInfo.preferedPhysician",
          "display" : "A.1.2.3 Prefered physician",
          "target" : [
            {
              "code" : "PractitionerRole",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician.Identifier",
          "display" : "A.1.2.3.1 Identification of the prefered physician",
          "target" : [
            {
              "code" : "PractitionerRole.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician.Name",
          "display" : "A.1.2.3.2 Name of the prefered physician",
          "target" : [
            {
              "code" : "PractitionerRole.practiotioner.name",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician.Specialization",
          "display" : "A.1.2.3.3 Specialization of the prefered physician",
          "target" : [
            {
              "code" : "PractitionerRole.speciality",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician.providerIdentifierName",
          "display" : "A.1.2.3.4 Identification and name of the provider the doctor represents",
          "target" : [
            {
              "code" : "PractitionerRole.organization.name",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician.providerAddress",
          "display" : "A.1.2.3.5 Provider address",
          "target" : [
            {
              "code" : "PractitionerRole.organization.address",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician.telecom",
          "display" : "A.1.2.3.6 Telecom",
          "target" : [
            {
              "code" : "PractitionerRole.telecom",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
