# eHN Specimen to this guide Map - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **eHN Specimen to this guide Map**

## ConceptMap: eHN Specimen to this guide Map (Experimental) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/ConceptMap/specimen2FHIR-cz-lab | *Version*:0.5.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:Specimen2Fhir |

 
eHN Specimen Model to this guide Map 

 
It shows how the Specimen data set defined by the EU eHN guidelines is mapped into this guide 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "specimen2FHIR-cz-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/ConceptMap/specimen2FHIR-cz-lab",
  "version" : "0.5.0",
  "name" : "Specimen2Fhir",
  "title" : "eHN Specimen to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "eHN Specimen Model to this guide Map",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "It shows how the Specimen data set defined by the EU eHN guidelines is mapped into this guide",
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/SpecimenLabCz",
      "target" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-service-request-lab",
      "element" : [
        {
          "code" : "SpecimenLab.identifier",
          "display" : "A.2.3.1 Specimen identifier",
          "target" : [
            {
              "code" : "Specimen.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenLab.speciesType",
          "display" : "A.2.3.2 Type of species",
          "target" : [
            {
              "code" : "Specimen.subject.extension:patient-animal.extension:species",
              "equivalence" : "relatedto",
              "comment" : "subject.ofType(Patient)"
            }
          ]
        },
        {
          "code" : "SpecimenLab.material",
          "display" : "A.2.3.3 Material",
          "target" : [
            {
              "code" : "Specimen.type",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenLab.collected",
          "display" : "A.2.3.4 Collection period",
          "target" : [
            {
              "code" : "Specimen.collection.collected[x]",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenLab.anatomicLocation",
          "display" : "A.2.3.5 Anatomic location",
          "target" : [
            {
              "code" : "Specimen.collection.bodySite",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "SpecimenLab.anatomicLocation",
          "display" : "A.2.3.5 Anatomic location",
          "target" : [
            {
              "code" : "Specimen.collection.extension:bodySite",
              "equivalence" : "relatedto",
              "comment" : "see Group 2 for details"
            }
          ]
        },
        {
          "code" : "SpecimenLab.morphology",
          "display" : "A.2.3.6 Morphology",
          "target" : [
            {
              "code" : "Specimen.collection.extension:bodySite",
              "equivalence" : "relatedto",
              "comment" : "see Group 2 for details"
            }
          ]
        },
        {
          "code" : "SpecimenLab.sourceDevice",
          "display" : "A.2.3.7 Source Device",
          "target" : [
            {
              "code" : "Specimen.subject",
              "equivalence" : "relatedto",
              "comment" : "When the device (e.g. the catheter) is what has been examinated.\nIf the device is meant instead as the mean used to collect the specimen (e.g blood collected from the catheter), then, this is represented by the collectionMethod attribute and mapped into the Specimen.collection.method"
            }
          ]
        },
        {
          "code" : "SpecimenLab.collectionMethod",
          "display" : "A.2.3.8 Collection procedure/method",
          "target" : [
            {
              "code" : "Specimen.collection.method",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenLab.receivedDateTime",
          "display" : "A.2.3.9 Received date",
          "target" : [
            {
              "code" : "Specimen.receivedTime",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/SpecimenLabCz",
      "target" : "http://hl7.eu/fhir/laboratory/StructureDefinition/BodyStructure-eu-lab",
      "element" : [
        {
          "code" : "SpecimenLab.anatomicLocation",
          "display" : "A.2.3.5 Anatomic location",
          "target" : [
            {
              "code" : "BodyStructure.location",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenLab.anatomicLocation",
          "display" : "A.2.3.5 Anatomic location",
          "target" : [
            {
              "code" : "BodyStructure.extension:laterality",
              "equivalence" : "equivalent",
              "comment" : "For details about laterality"
            }
          ]
        },
        {
          "code" : "SpecimenLab.morphology",
          "display" : "A.2.3.6 Morphology",
          "target" : [
            {
              "code" : "BodyStructure.morphology",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
