# eHN Result to this guide Map - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **eHN Result to this guide Map**

## ConceptMap: eHN Result to this guide Map (Experimental) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/ConceptMap/result2FHIR-cz-lab | *Version*:0.5.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:LabRptResult2FHIR |

 
eHN Result Model to this guide Map 

 
It shows how the Result data set defined by the EU eHN guidelines is mapped into this guide 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "result2FHIR-cz-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/ConceptMap/result2FHIR-cz-lab",
  "version" : "0.5.0",
  "name" : "LabRptResult2FHIR",
  "title" : "eHN Result to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "eHN Result Model to this guide Map",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "It shows how the Result data set defined by the EU eHN guidelines is mapped into this guide",
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/Result",
      "target" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory",
      "element" : [
        {
          "code" : "Result.narrative",
          "display" : "A.2.4.1 Laboratory report narrative",
          "target" : [
            {
              "equivalence" : "unmatched"
            }
          ]
        },
        {
          "code" : "Result.narrative.report",
          "display" : "A.2.4.1.1 Narrative report",
          "target" : [
            {
              "equivalence" : "unmatched"
            }
          ]
        },
        {
          "code" : "Result.narrative.notes",
          "display" : "A.2.4.1.2 Comments, interpretation and recommendations",
          "target" : [
            {
              "equivalence" : "unmatched"
            }
          ]
        },
        {
          "code" : "Result.observation",
          "display" : "A.2.4.2 Observation details",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Result.observation.dateTime",
          "display" : "A.2.4.2.1 Observation date",
          "target" : [
            {
              "code" : "Observation.effective[x]",
              "equivalence" : "equivalent",
              "comment" : "intended as the clinical relevant time (i.e. when the specimen was collected)"
            }
          ]
        },
        {
          "code" : "Result.observation.dateTime",
          "display" : "A.2.4.2.1 Observation date",
          "target" : [
            {
              "code" : "Observation.issued",
              "equivalence" : "equivalent",
              "comment" : "as the date the result is made available."
            }
          ]
        },
        {
          "code" : "Result.observation.code",
          "display" : "A.2.4.2.3 Observation code",
          "target" : [
            {
              "code" : "Observation.code",
              "equivalence" : "relatedto",
              "comment" : "depends on the type of test"
            }
          ]
        },
        {
          "code" : "Result.observation.code",
          "display" : "A.2.4.2.3 Observation code",
          "target" : [
            {
              "code" : "Observation.hasMember.code",
              "equivalence" : "relatedto",
              "comment" : "depends on the type of test"
            }
          ]
        },
        {
          "code" : "Result.observation.code",
          "display" : "A.2.4.2.3 Observation code",
          "target" : [
            {
              "code" : "Observation.component.code",
              "equivalence" : "relatedto",
              "comment" : "depends on the type of test"
            }
          ]
        },
        {
          "code" : "Result.observation.code.name",
          "display" : "A.2.4.2.3.1 Observation name",
          "target" : [
            {
              "code" : "Observation.code.coding.display",
              "equivalence" : "equivalent",
              "comment" : "The mapping refers to the case 'code' mapped to Observation.code. A similar mapping applies to the other cases.\nThis element typically  represents the 'full specified  name' designation, compared to the 'short name' of the 'A.2.4.2.3.3 Observation display name' element.\nIt is not expected that both designations are recorded in the report; consumers can use in fact terminology services and/or lookup tables to allow users to have different displays for the same coded concept."
            }
          ]
        },
        {
          "code" : "Result.observation.method",
          "display" : "A.2.4.2.4 Observation method",
          "target" : [
            {
              "code" : "Observation.method",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Result.observation.device",
          "display" : "A.2.4.2.5 Observation device",
          "target" : [
            {
              "code" : "Observation.device",
              "equivalence" : "relatedto",
              "comment" : "When it refers to the measuring device, including kits, and device of type Device"
            }
          ]
        },
        {
          "code" : "Result.observation.device",
          "display" : "A.2.4.2.7 Observation device",
          "target" : [
            {
              "code" : "Observation.device.device",
              "equivalence" : "relatedto",
              "comment" : "When it refers to the measuring device and device of type DeviceMeasure"
            }
          ]
        },
        {
          "code" : "Result.observation.device",
          "display" : "A.2.4.2.7 Observation device",
          "target" : [
            {
              "code" : "Observation.device",
              "equivalence" : "relatedto",
              "comment" : "With device of type DeviceMeasure.\nThis resource can be used to capture some information about the setting (including calibration)"
            }
          ]
        },
        {
          "code" : "Result.observation.order",
          "display" : "A.2.4.2.8 Order",
          "target" : [
            {
              "code" : "Observation.basedOn",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Result.observation.performer",
          "display" : "A.2.4.2.9 Performer",
          "target" : [
            {
              "code" : "Observation.performer",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Result.observation.reporter",
          "display" : "A.2.4.2.10 Reporter",
          "target" : [
            {
              "code" : "Observation.performer",
              "equivalence" : "relatedto",
              "comment" : "For interpreter: performer.extension:performerFunction = AUT (author)\nIf the person responsible for validation:  performer.extension:performerFunction = AUTHEN or LA"
            }
          ]
        },
        {
          "code" : "Result.observation.result",
          "display" : "A.2.4.2.11 Observation result",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "equivalent",
              "comment" : "depends on the type of test"
            }
          ]
        },
        {
          "code" : "Result.observation.result",
          "display" : "A.2.4.2.11 Observation result",
          "target" : [
            {
              "code" : "Observation.component.value[x]",
              "equivalence" : "equivalent",
              "comment" : "depends on the type of test"
            }
          ]
        },
        {
          "code" : "Result.observation.interpretation",
          "display" : "A.2.4.2.12 Observation interpretation",
          "target" : [
            {
              "code" : "Observation.interpretation",
              "equivalence" : "equivalent",
              "comment" : "depends on the type of test"
            }
          ]
        },
        {
          "code" : "Result.observation.interpretation",
          "display" : "A.2.4.2.12 Observation interpretation",
          "target" : [
            {
              "code" : "Observation.component.interpretation",
              "equivalence" : "equivalent",
              "comment" : "depends on the type of test"
            }
          ]
        },
        {
          "code" : "Result.observation.description",
          "display" : "A.2.4.2.13 Result description",
          "target" : [
            {
              "code" : "Observation.text",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Result.observation.accreditationStatus",
          "display" : "A.2.4.2.14 Accreditation status",
          "target" : [
            {
              "code" : "Observation.extension[accreditation]",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/Result",
      "target" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-diagnostic-report-lab",
      "element" : [
        {
          "code" : "Result.narrative",
          "display" : "A.2.4.1 Laboratory report narrative",
          "target" : [
            {
              "code" : "DiagnosticReport",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Result.narrative.report",
          "display" : "A.2.4.1.1 Narrative report",
          "target" : [
            {
              "code" : "DiagnosticReport.text",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Result.narrative.notes",
          "display" : "A.2.4.1.2 Comments, interpretation and recommendations",
          "target" : [
            {
              "code" : "DiagnosticReport.conclusion",
              "equivalence" : "relatedto",
              "comment" : "if related to the overall report conclusions"
            }
          ]
        },
        {
          "code" : "Result.observation",
          "display" : "A.2.4.2 Observation details",
          "target" : [
            {
              "code" : "DiagnosticReport.result",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.dateTime",
          "display" : "A.2.4.2.1 Observation date",
          "target" : [
            {
              "code" : "DiagnosticReport.result",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.code",
          "display" : "A.2.4.2.3 Observation code",
          "target" : [
            {
              "code" : "DiagnosticReport.result",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.code.name",
          "display" : "A.2.4.2.3.1 Observation name",
          "target" : [
            {
              "code" : "DiagnosticReport.result",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.code.originalName",
          "display" : "A.2.4.2.4 Observation method",
          "target" : [
            {
              "code" : "DiagnosticReport.result",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.device",
          "display" : "A.2.4.2.5 Observation device",
          "target" : [
            {
              "code" : "DiagnosticReport.result",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.order",
          "display" : "A.2.4.2.8 Order",
          "target" : [
            {
              "code" : "DiagnosticReport.result",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.performer",
          "display" : "A.2.4.2.9 Performer",
          "target" : [
            {
              "code" : "DiagnosticReport.result",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.reporter",
          "display" : "A.2.4.2.10 Reporter",
          "target" : [
            {
              "code" : "DiagnosticReport.result",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.result",
          "display" : "A.2.4.2.11 Observation result",
          "target" : [
            {
              "code" : "DiagnosticReport.result",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.interpretation",
          "display" : "A.2.4.2.12 Observation interpretation",
          "target" : [
            {
              "code" : "DiagnosticReport.result",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.description",
          "display" : "A.2.4.2.13 Result description",
          "target" : [
            {
              "code" : "DiagnosticReport.result",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.accreditationStatus",
          "display" : "A.2.4.2.14 Accreditation status",
          "target" : [
            {
              "code" : "DiagnosticReport.result",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/Result",
      "target" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-composition-lab-report",
      "element" : [
        {
          "code" : "Result.narrative",
          "display" : "A.2.4.1 Laboratory report narrative",
          "target" : [
            {
              "code" : "Composition",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Result.narrative.report",
          "display" : "A.2.4.1.1 Narrative report",
          "target" : [
            {
              "code" : "Composition.text",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Result.narrative.report",
          "display" : "A.2.4.1.1 Narrative report",
          "target" : [
            {
              "code" : "Composition.section:lab-no-subsections.text",
              "equivalence" : "relatedto",
              "comment" : "if single section"
            }
          ]
        },
        {
          "code" : "Result.narrative.report",
          "display" : "A.2.4.1.1 Narrative report",
          "target" : [
            {
              "code" : "Composition.section:lab-subsections.section.text",
              "equivalence" : "relatedto",
              "comment" : "if multiple sections"
            }
          ]
        },
        {
          "code" : "Result.narrative.notes",
          "display" : "A.2.4.1.2 Comments, interpretation and recommendations",
          "target" : [
            {
              "code" : "Composition.section:lab-no-subsections.text",
              "equivalence" : "relatedto",
              "comment" : "if single section"
            }
          ]
        },
        {
          "code" : "Result.narrative.notes",
          "display" : "A.2.4.1.2 Comments, interpretation and recommendations",
          "target" : [
            {
              "code" : "Composition.section:lab-subsections.section.text",
              "equivalence" : "relatedto",
              "comment" : "if multiple sections"
            }
          ]
        },
        {
          "code" : "Result.observation",
          "display" : "A.2.4.2 Observation details",
          "target" : [
            {
              "code" : "Composition.section:lab-no-subsections.entry",
              "equivalence" : "relatedto",
              "comment" : "if single section"
            }
          ]
        },
        {
          "code" : "Result.observation",
          "display" : "A.2.4.2 Observation details",
          "target" : [
            {
              "code" : "Composition.section:lab-subsections.section.entry",
              "equivalence" : "relatedto",
              "comment" : "if multiple sections"
            }
          ]
        },
        {
          "code" : "Result.observation.dateTime",
          "display" : "A.2.4.2.1 Observation date",
          "target" : [
            {
              "code" : "Composition.section:lab-no-subsections.entry",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.code",
          "display" : "A.2.4.2.3 Observation code",
          "target" : [
            {
              "code" : "Composition.section:lab-no-subsections.entry",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.code.name",
          "display" : "A.2.4.2.3.1 Observation name",
          "target" : [
            {
              "code" : "Composition.section:lab-no-subsections.entry",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.code.originalName"
        },
        {
          "code" : "Result.observation.method",
          "display" : "A.2.4.2.4 Observation method",
          "target" : [
            {
              "code" : "Composition.section:lab-no-subsections.entry",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.device",
          "display" : "A.2.4.2.5 Observation device",
          "target" : [
            {
              "code" : "Composition.section:lab-no-subsections.entry",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.order",
          "display" : "A.2.4.2.8 Order",
          "target" : [
            {
              "code" : "Composition.section:lab-no-subsections.entry",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.performer",
          "display" : "A.2.4.2.9 Performer",
          "target" : [
            {
              "code" : "Composition.section:lab-no-subsections.entry",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.reporter",
          "display" : "A.2.4.2.10 Reporter",
          "target" : [
            {
              "code" : "Composition.section:lab-no-subsections.entry",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.result",
          "display" : "A.2.4.2.11 Observation result",
          "target" : [
            {
              "code" : "Composition.section:lab-no-subsections.entry",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.interpretation",
          "display" : "A.2.4.2.12 Observation interpretation",
          "target" : [
            {
              "code" : "Composition.section:lab-no-subsections.entry",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.description",
          "display" : "A.2.4.2.13 Result description",
          "target" : [
            {
              "code" : "Composition.section:lab-no-subsections.entry",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        },
        {
          "code" : "Result.observation.accreditationStatus",
          "display" : "A.2.4.2.14 Accreditation status",
          "target" : [
            {
              "code" : "Composition.section:lab-no-subsections.entry",
              "equivalence" : "relatedto",
              "comment" : "see details in the Observation group"
            }
          ]
        }
      ]
    }
  ]
}

```
