# eHN Lab Report to this guide Map - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **eHN Lab Report to this guide Map**

## ConceptMap: eHN Lab Report to this guide Map (Experimental) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/ConceptMap/labRpt2FHIR-cz-lab | *Version*:0.5.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:LabRpt2FHIR |

 
eHN Lab Report to this guide Map 

 
It shows how the Laboratory Report data set defined by the EU eHN guidelines is mapped into this guide 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "labRpt2FHIR-cz-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/ConceptMap/labRpt2FHIR-cz-lab",
  "version" : "0.5.0",
  "name" : "LabRpt2FHIR",
  "title" : "eHN Lab Report to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "eHN Lab Report to this guide Map",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "It shows how the Laboratory Report data set defined by the EU eHN guidelines is mapped into this guide",
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/LabReportCz",
      "target" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-diagnostic-report-lab",
      "element" : [
        {
          "code" : "LabReport.header",
          "display" : "A.1 Report header data elements",
          "target" : [
            {
              "code" : "DiagnosticReport",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "LabReport.header.subject",
          "display" : "A.1.1 - A1.2 Patient/subject",
          "target" : [
            {
              "code" : "DiagnosticReport.subject",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "LabReport.header.payer",
          "display" : "A.1.3 Health insurance and payment information",
          "target" : [
            {
              "code" : "DiagnosticReport.basedOn.insurance",
              "equivalence" : "relatedto",
              "comment" : "basedOn.resolve().ofType(ServiceRequest).insurance.resolve().ofType(Coverage)"
            }
          ]
        },
        {
          "code" : "LabReport.header.informationRecipient",
          "display" : "A.1.4 Information recipient",
          "target" : [
            {
              "code" : "DiagnosticReport.extension:information-recipient",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "LabReport.header.author",
          "display" : "A.1.5 Author",
          "target" : [
            {
              "code" : "DiagnosticReport.resultsInterpreter",
              "equivalence" : "relatedto",
              "comment" : "If the author is the interpreter"
            }
          ]
        },
        {
          "code" : "LabReport.header.author",
          "display" : "A.1.5 Author",
          "target" : [
            {
              "code" : "DiagnosticReport.performer",
              "equivalence" : "relatedto",
              "comment" : "If the author is the perfomer"
            }
          ]
        },
        {
          "code" : "LabReport.header.legalAuthenticator",
          "display" : "A.1.6 Legal authenticator",
          "target" : [
            {
              "equivalence" : "unmatched",
              "comment" : "Mapped in the Composition resource"
            }
          ]
        },
        {
          "code" : "LabReport.header.validator",
          "display" : "A.1.7 Result validator",
          "target" : [
            {
              "equivalence" : "unmatched",
              "comment" : "Mapped in the Composition resource"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata",
          "display" : "A.1.8 Laboratory report metadata",
          "target" : [
            {
              "code" : "DiagnosticReport",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata.documentId",
          "display" : "A.1.8.1 Document Id",
          "target" : [
            {
              "code" : "DiagnosticReport.identifier",
              "equivalence" : "relatedto",
              "comment" : "If it is the identifier of the report indipendently by its version. Otherwise you should refer to the Bundle.indentifier"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata.type",
          "display" : "A.1.8.2 Document type",
          "target" : [
            {
              "code" : "DiagnosticReport.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata.status",
          "display" : "A.1.8.3 Document status",
          "target" : [
            {
              "code" : "DiagnosticReport.status",
              "equivalence" : "relatedto",
              "comment" : "For FHIR R4 the more granular status is recorded in the DiagnosticReport.status"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata.dateTime",
          "display" : "A.1.8.4 Report date and time",
          "target" : [
            {
              "code" : "DiagnosticReport.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata.title",
          "display" : "A.1.8.5 Document title",
          "target" : [
            {
              "equivalence" : "unmatched",
              "comment" : "Mapped in the Composition resource"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata.custodian",
          "display" : "A.1.8.6 Report custodian",
          "target" : [
            {
              "equivalence" : "unmatched",
              "comment" : "Mapped in the Composition resource"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata.confidentiality",
          "display" : "A.1.8.7 Confidentiality",
          "target" : [
            {
              "equivalence" : "unmatched",
              "comment" : "Mapped in the Composition resource"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata.language",
          "display" : "A.1.8.8 Language",
          "target" : [
            {
              "code" : "DiagnosticReport.language",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata.version",
          "display" : "A.1.8.9 Version",
          "target" : [
            {
              "equivalence" : "unmatched",
              "comment" : "Mapped in the Composition resource if it refers to the business report version"
            }
          ]
        },
        {
          "code" : "LabReport.order",
          "display" : "A.2.1-A.2.2 Order",
          "target" : [
            {
              "code" : "DiagnosticReport.basedOn",
              "equivalence" : "relatedto",
              "comment" : "basedOn.resolve().ofType(CZ_ServiceRequest)"
            }
          ]
        },
        {
          "code" : "LabReport.specimen",
          "display" : "A.2.3 Specimen information",
          "target" : [
            {
              "code" : "DiagnosticReport.specimen",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "LabReport.specimen",
          "display" : "A.2.3 Specimen information",
          "target" : [
            {
              "code" : "DiagnosticReport.result.specimen",
              "equivalence" : "relatedto",
              "comment" : "result.resolve().ofType(CZ_ObservationResultLaboratory)"
            }
          ]
        },
        {
          "code" : "LabReport.result",
          "display" : "A.2.4 Results data elements",
          "target" : [
            {
              "code" : "DiagnosticReport.result",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "LabReport.presentedForm",
          "display" : "A.3 Laboratory report presented form",
          "target" : [
            {
              "code" : "DiagnosticReport.presentedForm",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "LabReport.attachment",
          "display" : "A.4 Laboratory report attachment",
          "target" : [
            {
              "code" : "DiagnosticReport.media.link.content.attachment",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/LabReportCz",
      "target" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-composition-lab-report",
      "element" : [
        {
          "code" : "LabReport.header",
          "display" : "A.1 Report header data elements",
          "target" : [
            {
              "code" : "Composition",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "LabReport.header.subject",
          "display" : "A.1.1 - A1.2 Patient/subject",
          "target" : [
            {
              "code" : "Composition.subject",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "LabReport.header.payer",
          "display" : "A.1.3 Health insurance and payment information",
          "target" : [
            {
              "code" : "Composition.extension:basedOn-order-or-requisition.insurance",
              "equivalence" : "relatedto",
              "comment" : "extension(http://hl7.eu/fhir/laboratory/StructureDefinition/composition-basedOn-order-or-requisition).resolve().ofType(ServiceRequest).insurance.resolve().ofType(Coverage)"
            }
          ]
        },
        {
          "code" : "LabReport.header.informationRecipient",
          "display" : "A.1.4 Information recipient",
          "target" : [
            {
              "code" : "Composition.extension:information-recipient",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "LabReport.header.author",
          "display" : "A.1.5 Author",
          "target" : [
            {
              "code" : "Composition.author",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "LabReport.header.validator",
          "display" : "A.1.6 Result validator",
          "target" : [
            {
              "code" : "Composition.attester.party",
              "equivalence" : "equivalent",
              "comment" : "The person authenticated the content in their professional capacity.\nattester.where(mode='professional')"
            }
          ]
        },
        {
          "code" : "LabReport.header.legalAuthenticator",
          "display" : "A.1.7 Legal authenticator",
          "target" : [
            {
              "code" : "Composition.attester.party",
              "equivalence" : "equivalent",
              "comment" : "The person authenticated the content and accepted legal responsibility for its content.\nattester.where(mode='legal')"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata",
          "display" : "A.1.8 Laboratory report metadata",
          "target" : [
            {
              "code" : "Composition",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata.documentId",
          "display" : "A.1.8.1 Document Id",
          "target" : [
            {
              "code" : "Composition.identifier",
              "equivalence" : "equivalent",
              "comment" : "If it is the identifier of the report indipendently by its version. Otherwise you should refer to the Bundle.indentifier"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata.type",
          "display" : "A.1.8.2 Document type",
          "target" : [
            {
              "code" : "Composition.type",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata.status",
          "display" : "A.1.8.3 Document status",
          "target" : [
            {
              "code" : "Composition.status",
              "equivalence" : "relatedto",
              "comment" : "For FHIR R4 the more granular status is recorded in the DiagnosticReport.status. Mapping rules for valuing the Compisition.status are specified in http://hl7.eu/fhir/laboratory/ConceptMap/ConceptMap-eu-diagRptStatus2CompStatus"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata.dateTime",
          "display" : "A.1.8.4 Report date and time",
          "target" : [
            {
              "code" : "Composition.date",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata.title",
          "display" : "A.1.8.5 Document title",
          "target" : [
            {
              "code" : "Composition.title",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata.custodian",
          "display" : "A.1.8.6 Report custodian",
          "target" : [
            {
              "code" : "Composition.custodian",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata.confidentiality",
          "display" : "A.1.8.7 Confidentiality",
          "target" : [
            {
              "code" : "Composition.confidentiality",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata.language",
          "display" : "A.1.8.8 Language",
          "target" : [
            {
              "code" : "Composition.language",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "LabReport.header.metadata.version",
          "display" : "A.1.8.9 Version",
          "target" : [
            {
              "code" : "Composition.extension:versionNumber",
              "equivalence" : "equivalent",
              "comment" : "if it refers to the business report version"
            }
          ]
        },
        {
          "code" : "LabReport.order",
          "display" : "A.2.1-A.2.2 Order",
          "target" : [
            {
              "code" : "Composition.extension:basedOn-order-or-requisition.insurance",
              "equivalence" : "relatedto",
              "comment" : "extension(http://hl7.eu/fhir/laboratory/StructureDefinition/composition-basedOn-order-or-requisition).resolve().ofType(ServiceRequest)"
            }
          ]
        },
        {
          "code" : "LabReport.specimen",
          "display" : "A.2.3 Specimen information",
          "target" : [
            {
              "code" : "Composition.section:lab-no-subsections.entry.specimen",
              "equivalence" : "relatedto",
              "comment" : "If no sub sections"
            }
          ]
        },
        {
          "code" : "LabReport.result",
          "display" : "A.2.4 Results data elements",
          "target" : [
            {
              "code" : "Composition.section:lab-no-subsections.entry",
              "equivalence" : "relatedto",
              "comment" : "If no sub sections"
            }
          ]
        },
        {
          "code" : "LabReport.specimen",
          "display" : "A.2.3 Specimen information",
          "target" : [
            {
              "code" : "Composition.section:lab-subsections.section.entry.specimen",
              "equivalence" : "relatedto",
              "comment" : "If sub sections"
            }
          ]
        },
        {
          "code" : "LabReport.result",
          "display" : "A.2.4 Results data elements",
          "target" : [
            {
              "code" : "Composition.section:lab-subsections.section.entry",
              "equivalence" : "relatedto",
              "comment" : "If sub sections"
            }
          ]
        }
      ]
    }
  ]
}

```
