# hl7.fhir.cz.ems#0.0.2: HL7 Czech EMS Implementation Guide

## Pages

* [Home](index.md)
* [Dependencies](dependencies.md)
* [Background](background.md)
* [Authors](authors.md)
* [Download](downloads.md)
* [Examples](examples.md)
* [Background](background-cs.md)
* [Artifacts](artifacts.md)
* [Scope and content](scope-and-content.md)
* [Logical models](logical-models.md)
* [Datová sada - logické modely](logical-models-cs.md)
* [Copyright](copyright.md)
* [Rozsah použití a obsah](scope-and-content-cs.md)
* [Příklady](examples-cs.md)
* [Závislosti](dependencies-cs.md)
* [Download](downloads-cs.md)
* [Autoři](authors-cs.md)
* [Autorská práva](copyright-cs.md)

## Resources

### ValueSets

* [Condition Value Set](ValueSet-condition-cz-ems.md)
* [ObservationsEmsHeightType](ValueSet-cz-observationHeightType-ems-vs.md)
* [ObservationsEmsOFType](ValueSet-cz-observationOFType-ems-vs.md)
* [ObservationsUnitHeight](ValueSet-cz-observationUnitsHeight-ems-vs.md)
* [ObservationsUnitWeight](ValueSet-cz-observationUnitsWeight-ems-vs.md)
* [ObservationsEmsVSType](ValueSet-cz-observationVSType-ems-vs.md)
* [ObservationsEmsWeightType](ValueSet-cz-observationWeightType-ems-vs.md)

### Logicals

* [A.2.4 - Alerts (en)](StructureDefinition-AlertsCz.md)
* [A.4 - Additional attachments](StructureDefinition-AttachmentsCz.md)
* [A.2.11 - Attachments EMS](StructureDefinition-AttachmentsEMSCz.md)
* [A.2.1 - Dispatch Data (en)](StructureDefinition-DispatchDataCz.md)
* [A.2.2 - Dispatch Timeline (en)](StructureDefinition-DispatchTimelineCz.md)
* [A - EMS Report (en)](StructureDefinition-EmsReportCz.md)
* [A.1 - EMS report header data element (en)](StructureDefinition-HeaderEmsCz.md)
* [A.2.4 - Urgentní informace (cz)](StructureDefinition-LogAlertsCz.md)
* [A.4 - Přílohy](StructureDefinition-LogAttachmentsCz.md)
* [A.2.11 - Přílohy](StructureDefinition-LogAttachmentsEmsCz.md)
* [A.2.8 - Diagnostic Summary (en)](StructureDefinition-LogDiagnosticSummary.md)
* [A.2.8 - Diagnostický souhrn (cz)](StructureDefinition-LogDiagnostickySouhrnCz.md)
* [A.2.1 - Údaje o výjezdu (cz)](StructureDefinition-LogDispatchDataCz.md)
* [A.2.2 - Časová osa výjezdu (cz)](StructureDefinition-LogDispatchTimelineCz.md)
* [A - Zpráva o výjezdu (cz)](StructureDefinition-LogEmsReportCz.md)
* [A.2.10 - End of Care (en)](StructureDefinition-LogEndOfCare.md)
* [A.2.10 - Ukončení (cz)](StructureDefinition-LogEndOfCareCz.md)
* [A.1 – Hlavička dokumentu (cz)](StructureDefinition-LogHeaderEmsCz.md)
* [A.2.6 - Objektivní nález](StructureDefinition-LogObjectiveFindingsEmsCz.md)
* [A.2.3 - Anamnéza (cz)](StructureDefinition-LogPatientHistoryCz.md)
* [A.3 - Vizuální podoba dokumentu](StructureDefinition-LogPresentedFormCz.md)
* [A.2.5 - Nynější onemocnění](StructureDefinition-LogPresentingIllnessEmsCz.md)
* [A.2.9 - Course of Treatment and Recommendations (en)](StructureDefinition-LogRecommendations.md)
* [A.2.9 - Průběh ošetření a doporučení (cz)](StructureDefinition-LogRecommendationsCz.md)
* [A.2.7 - Terapie](StructureDefinition-LogTherapyEmsCz.md)
* [A.2.6 - Objective findings](StructureDefinition-ObjectiveFindingsEmsCz.md)
* [A.2.3 - Patient history (en)](StructureDefinition-PatientHistoryCz.md)
* [A.3 - Presented form](StructureDefinition-PresentedFormCz.md)
* [A.2.5 - Presenting Illness](StructureDefinition-PresentingIllnessEmsCz.md)
* [A.2.7 - Therapy](StructureDefinition-TherapyEmsCz.md)

### Resource Profiles

* [Medication Administration: EMS Report (CZ)](StructureDefinition-cz-MedicationAdministration.md)
* [Allergy Intolerance: (EMS CZ)](StructureDefinition-cz-allergyIntolerance-ems.md)
* [Bundle: EMS Report (CZ)](StructureDefinition-cz-bundle-ems.md)
* [CareTeam: (EMS CZ)](StructureDefinition-cz-careteam-ems.md)
* [Communication: (EMS CZ)](StructureDefinition-cz-communication-ems.md)
* [Composition (EMS CZ)](StructureDefinition-cz-composition-ems.md)
* [Condition (EMS CZ)](StructureDefinition-cz-condition-ems.md)
* [Encounter EMS (CZ)](StructureDefinition-cz-encounter-ems.md)
* [Flag: (EMS CZ)](StructureDefinition-cz-flag-ems.md)
* [CZ Immunization EMS](StructureDefinition-cz-immunization-ems.md)
* [Immunization Recommendation: (EMS CZ)](StructureDefinition-cz-immunizationRecommendation-ems.md)
* [Location: (EMS CZ)](StructureDefinition-cz-location-ems.md)
* [Observation: Anthropometric Data - BMI (EMS CZ)](StructureDefinition-cz-observation-BMI-ems.md)
* [Observation: Other Objective Findings (EMS CZ)](StructureDefinition-cz-observation-OtherOF-ems.md)
* [Observation: Anthropometric Data - Height (EMS CZ)](StructureDefinition-cz-observation-height-ems.md)
* [Infectious Contact: (EMS CZ)](StructureDefinition-cz-observation-infectious-contact-ems.md)
* [Observation: Oxygen Therapy Observation (EMS CZ)](StructureDefinition-cz-observation-oxygen-ems.md)
* [CZ Observation SDOH: (EMS)](StructureDefinition-cz-observation-sdoh-ems.md)
* [Observation: Vital Signs (EMS CZ)](StructureDefinition-cz-observation-vitalSigns-ems.md)
* [Observation: Anthropometric Data - Weight (EMS CZ)](StructureDefinition-cz-observation-weight-ems.md)
* [Procedure: EMS Report (CZ)](StructureDefinition-cz-procedure-ems.md)
* [Task: (EMS CZ)](StructureDefinition-cz-task-ems.md)
* [Location - Vehicle: (EMS CZ)](StructureDefinition-cz-vehicle-location-ems.md)

### Extensions

* [Urgency level (1–4)](StructureDefinition-ext-cz-ems-urgency-level.md)

### ConceptMaps

* [CZ Alerts Model to this guide Map](ConceptMap-Alerts2FHIR-cz.md)
* [CZ Attachment Model to this guide Map](ConceptMap-AttachmentEMS2FHIR-cz.md)
* [CZ ClinicalCourseAndRecommendations Model to this guide Map](ConceptMap-ClinicalCourseAndRecommendationsEMS2FHIR-cz.md)
* [CZ DispatchData Model to this guide Map](ConceptMap-DispatchDataEMS2FHIR-cz.md)
* [CZ DispatchTimeline Model to this guide Map](ConceptMap-DispatchTimeline2FHIR-cz.md)
* [CZ Objective Findings Model to this guide Map](ConceptMap-ObjectiveFindingsEMS2FHIR-cz.md)
* [CZ Presenting Illness to this guide Map](ConceptMap-PresentingIllness2FHIR-cz.md)
* [CZ Therapy Model to this guide Map](ConceptMap-Therapy2FHIR-cz.md)
* [EMS diagnostic summary Model to this guide Map](ConceptMap-diagnosticSummary2FHIR-cz-ems.md)
* [CZ Patient History to this guide Map](ConceptMap-patientHistory2FHIR-cz.md)

### ImplementationGuides

* [HL7 Czech EMS Implementation Guide](index.md)

### Examples

* [cz-example-bundle (Bundle)](Bundle-cz-example-bundle.md)
* [EMS Pacientky Mračeny Mrakomorové (Composition)](Composition-da3f987f-2a08-431a-92e3-129d7689e465.md)
* [040eb849-a513-4d74-b3f3-d2f246a26877 (DocumentReference)](DocumentReference-040eb849-a513-4d74-b3f3-d2f246a26877.md)
* [cd343afa-039d-4576-b5e4-e89598aeb628 (Encounter)](Encounter-cd343afa-039d-4576-b5e4-e89598aeb628.md)
* [ExampleBMIEms (Observation)](Observation-ExampleBMIEms.md)
* [ExampleBodyHeightEms (Observation)](Observation-ExampleBodyHeightEms.md)
* [ExampleBodyWeightEms (Observation)](Observation-ExampleBodyWeightEms.md)
* [Fakultní nemocnice Motol (Organization)](Organization-821077d6-ce17-4602-b3ad-d4bef845a950.md)
* [3b46c18c-7e07-4232-af3e-f710dec8e766 (Patient)](Patient-3b46c18c-7e07-4232-af3e-f710dec8e766.md)
* [2e877c76-633d-479b-a6d4-c6d95942de3f (Practitioner)](Practitioner-2e877c76-633d-479b-a6d4-c6d95942de3f.md)
* [practitionerEms (Practitioner)](Practitioner-practitionerEms.md)
* [3af2e7a6-c16e-4b80-a173-ca2c8aa081b6 (Procedure)](Procedure-3af2e7a6-c16e-4b80-a173-ca2c8aa081b6.md)
