# ObservationsEmsVSType - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **ObservationsEmsVSType**

## ValueSet: ObservationsEmsVSType 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/ValueSet/cz-observationVSType-ems-vs | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_ObservationVSTypeEmsVs |
| **Copyright/Legal**: This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement | |

 
This value set includes other Vital Signs observations of EMS report. 

 **References** 

* [Observation: Vital Signs (EMS CZ)](StructureDefinition-cz-observation-vitalSigns-ems.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on SNOMED CT International edition 01-Feb 2025

This value set contains 6 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-observationVSType-ems-vs",
  "url" : "https://hl7.cz/fhir/cz-ems/ValueSet/cz-observationVSType-ems-vs",
  "version" : "0.0.2",
  "name" : "CZ_ObservationVSTypeEmsVs",
  "title" : "ObservationsEmsVSType",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This value set includes other Vital Signs observations of EMS report.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "364075005"
          },
          {
            "code" : "86290005"
          },
          {
            "code" : "271649006"
          },
          {
            "code" : "271650006"
          },
          {
            "code" : "386725007"
          },
          {
            "code" : "103228002"
          }
        ]
      }
    ]
  }
}

```
