# Observation: Anthropometric Data - Weight (EMS CZ) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Anthropometric Data - Weight (EMS CZ)**

## Resource Profile: Observation: Anthropometric Data - Weight (EMS CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-weight-ems | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_ObservationWeightEms |

 
This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric data - weight. 

**Usages:**

* Refer to this Profile: [Composition (EMS CZ)](StructureDefinition-cz-composition-ems.md)
* Examples for this Profile: [Observation/ExampleBodyWeightEms](Observation-ExampleBodyWeightEms.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/cz-observation-weight-ems)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-observation-weight-ems.csv), [Excel](StructureDefinition-cz-observation-weight-ems.xlsx), [Schematron](StructureDefinition-cz-observation-weight-ems.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-observation-weight-ems",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-weight-ems",
  "version" : "0.0.2",
  "name" : "CZ_ObservationWeightEms",
  "title" : "Observation: Anthropometric Data - Weight (EMS CZ)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric data - weight.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/fhir/cz-ems/ValueSet/cz-observationWeightType-ems-vs"
        }
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "short" : "Weight in kg",
        "definition" : "The weight of the patient in kilograms.",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "Observation.value[x].code",
        "path" : "Observation.value[x].code",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/fhir/cz-ems/ValueSet/cz-observationUnitsWeight-ems-vs"
        }
      }
    ]
  }
}

```
