# Encounter EMS (CZ) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Encounter EMS (CZ)**

## Resource Profile: Encounter EMS (CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-encounter-ems | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:CZEncounterEMS |

 
This profile defines how to represent Encounter resource in HL7 FHIR for the scope of this guide. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/cz-encounter-ems)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-encounter-ems.csv), [Excel](StructureDefinition-cz-encounter-ems.xlsx), [Schematron](StructureDefinition-cz-encounter-ems.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-encounter-ems",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-encounter-ems",
  "version" : "0.0.2",
  "name" : "CZEncounterEMS",
  "title" : "Encounter EMS (CZ)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Encounter resource in HL7 FHIR for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Encounter",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Encounter",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter",
        "path" : "Encounter"
      },
      {
        "id" : "Encounter.period.start",
        "path" : "Encounter.period.start",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Encounter.location",
        "path" : "Encounter.location",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "physicalType"
            }
          ],
          "description" : "Slicing of Encounter.location for scene and destination.",
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Encounter.location:scene",
        "path" : "Encounter.location",
        "sliceName" : "scene",
        "short" : "Incident scene",
        "definition" : "The incident scene location for the EMS run.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Encounter.location:scene.period",
        "path" : "Encounter.location.period",
        "min" : 1
      },
      {
        "id" : "Encounter.location:scene.period.start",
        "path" : "Encounter.location.period.start",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Encounter.location:scene.period.end",
        "path" : "Encounter.location.period.end",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Encounter.location:destination",
        "path" : "Encounter.location",
        "sliceName" : "destination",
        "short" : "Destination facility",
        "definition" : "The receiving/destination location for the EMS run.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Encounter.location:destination.period.end",
        "path" : "Encounter.location.period.end",
        "min" : 1,
        "mustSupport" : true
      }
    ]
  }
}

```
