# CareTeam: (EMS CZ) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CareTeam: (EMS CZ)**

## Resource Profile: CareTeam: (EMS CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-careteam-ems | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_CareTeamEms |

 
Profile of the emergency medical service team within Czech EMS. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/cz-careteam-ems)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-careteam-ems.csv), [Excel](StructureDefinition-cz-careteam-ems.xlsx), [Schematron](StructureDefinition-cz-careteam-ems.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-careteam-ems",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-careteam-ems",
  "version" : "0.0.2",
  "name" : "CZ_CareTeamEms",
  "title" : "CareTeam: (EMS CZ)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Profile of the emergency medical service team within Czech EMS.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "CareTeam",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/CareTeam",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CareTeam",
        "path" : "CareTeam"
      },
      {
        "id" : "CareTeam.status",
        "path" : "CareTeam.status",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CareTeam.encounter",
        "path" : "CareTeam.encounter",
        "mustSupport" : true
      },
      {
        "id" : "CareTeam.participant",
        "path" : "CareTeam.participant",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CareTeam.participant.role",
        "path" : "CareTeam.participant.role",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "https://ncez.mzcr.cz/fhir/ValueSet/nrzp-povolani-vs"
        }
      },
      {
        "id" : "CareTeam.participant.member",
        "path" : "CareTeam.participant.member",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitioner-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitionerrole-core"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "CareTeam.participant.member.identifier",
        "path" : "CareTeam.participant.member.identifier",
        "min" : 1,
        "mustSupport" : true
      }
    ]
  }
}

```
