# Medication Administration: EMS Report (CZ) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Medication Administration: EMS Report (CZ)**

## Resource Profile: Medication Administration: EMS Report (CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-MedicationAdministration | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_MedicationAdministration |

 
Czech national profile for a medication administration. 

 
MedicationAdministration is intended for tracking the administration of medications. 

**Usages:**

* Refer to this Profile: [Medication Administration: EMS Report (CZ)](StructureDefinition-cz-MedicationAdministration.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/cz-MedicationAdministration)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-MedicationAdministration.csv), [Excel](StructureDefinition-cz-MedicationAdministration.xlsx), [Schematron](StructureDefinition-cz-MedicationAdministration.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-MedicationAdministration",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-MedicationAdministration",
  "version" : "0.0.2",
  "name" : "CZ_MedicationAdministration",
  "title" : "Medication Administration: EMS Report (CZ)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Czech national profile for a medication administration.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "MedicationAdministration is intended for tracking the administration of medications.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "w3c.prov",
      "uri" : "http://www.w3.org/ns/prov",
      "name" : "W3C PROV"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationAdministration",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationAdministration",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationAdministration",
        "path" : "MedicationAdministration",
        "short" : "Czech Medication Administration",
        "definition" : "This profile is derived from the Medication Administration in FHIR, which is a record for tracking the administration of medications."
      },
      {
        "id" : "MedicationAdministration.identifier",
        "path" : "MedicationAdministration.identifier",
        "min" : 1
      },
      {
        "id" : "MedicationAdministration.partOf",
        "path" : "MedicationAdministration.partOf",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-MedicationAdministration",
              "http://hl7.org/fhir/StructureDefinition/MedicationAdministration",
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-procedure-ems",
              "http://hl7.org/fhir/StructureDefinition/Procedure"
            ]
          }
        ]
      },
      {
        "id" : "MedicationAdministration.status",
        "path" : "MedicationAdministration.status",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medication-admin-status"
        }
      },
      {
        "id" : "MedicationAdministration.medication[x]",
        "path" : "MedicationAdministration.medication[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "MedicationAdministration.medication[x]:medicationReference",
        "path" : "MedicationAdministration.medication[x]",
        "sliceName" : "medicationReference",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-Medication"
            ]
          }
        ]
      },
      {
        "id" : "MedicationAdministration.medication[x]:medicationCodeableConcept",
        "path" : "MedicationAdministration.medication[x]",
        "sliceName" : "medicationCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://hl7.cz/fhir/core/ValueSet/cz-dlplecivepripravky-vs"
        }
      },
      {
        "id" : "MedicationAdministration.subject",
        "path" : "MedicationAdministration.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-patient-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-patient-animal",
              "http://hl7.org/fhir/StructureDefinition/Group"
            ]
          }
        ]
      },
      {
        "id" : "MedicationAdministration.performer.actor",
        "path" : "MedicationAdministration.performer.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitioner-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitionerrole-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-patient-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-relatedPerson-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-device-observer"
            ]
          }
        ]
      },
      {
        "id" : "MedicationAdministration.device",
        "path" : "MedicationAdministration.device",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-device-observer",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-medical-device"
            ]
          }
        ]
      }
    ]
  }
}

```
