# A.2.6 - Objective findings - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.6 - Objective findings**

## Logical Model: A.2.6 - Objective findings 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/ObjectiveFindingsEmsCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogEnObjectiveFindingsEmsCz |

 
Emergency medical service report - Objective Findings 

**Usages:**

* Use this Logical Model: [A - EMS Report (en)](StructureDefinition-EmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/ObjectiveFindingsEmsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ObjectiveFindingsEmsCz.csv), [Excel](StructureDefinition-ObjectiveFindingsEmsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ObjectiveFindingsEmsCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/ObjectiveFindingsEmsCz",
  "version" : "0.0.2",
  "name" : "LogEnObjectiveFindingsEmsCz",
  "title" : "A.2.6 - Objective findings",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Emergency medical service report - Objective Findings",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/ObjectiveFindingsEmsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "ObjectiveFindingsEmsCz",
        "path" : "ObjectiveFindingsEmsCz",
        "short" : "A.2.6 - Objective findings",
        "definition" : "Emergency medical service report - Objective Findings"
      },
      {
        "id" : "ObjectiveFindingsEmsCz.antropometricData",
        "path" : "ObjectiveFindingsEmsCz.antropometricData",
        "short" : "A.2.6.1 - Anthropometric Data",
        "definition" : "Results of patient's anthropometric measurements: height, weight, BMI (automatic calculation from the given values). Optional: head, chest, abdomen circumference.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.antropometricData.textResult",
        "path" : "ObjectiveFindingsEmsCz.antropometricData.textResult",
        "short" : "A.2.6.1.1 - Examination result text",
        "definition" : "Textual description of the examination result.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.antropometricData.parametricRecord",
        "path" : "ObjectiveFindingsEmsCz.antropometricData.parametricRecord",
        "short" : "A.2.6.1.2 - Parametric record of the examination",
        "definition" : "Parametric entry of the examination result.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.antropometricData.parametricRecord.description",
        "path" : "ObjectiveFindingsEmsCz.antropometricData.parametricRecord.description",
        "short" : "A.2.6.1.2.1 - Examination description",
        "definition" : "Description of the examination, including the examination code, area examined, or sample, date and time of sample collection.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.antropometricData.parametricRecord.result",
        "path" : "ObjectiveFindingsEmsCz.antropometricData.parametricRecord.result",
        "short" : "A.2.6.1.2.2 - Formalized examination result",
        "definition" : "The examination result as text and/or in the form of numerical and coded measurement results. The content of the examination result will differ according to the type of examination..",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.vitalSigns",
        "path" : "ObjectiveFindingsEmsCz.vitalSigns",
        "short" : "A.2.6.2 - Basic Vital Signs",
        "definition" : "Results of basic vital signs measurements for the patient including the measurement timestamp. (Vital signs measurements may be repeated at different times during an emergency call).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.vitalSigns.type",
        "path" : "ObjectiveFindingsEmsCz.vitalSigns.type",
        "short" : "A.2.6.2.1 - Examination type",
        "definition" : "Classification of the examination type. Here fixed value ''vital-signs''",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.vitalSigns.textResult",
        "path" : "ObjectiveFindingsEmsCz.vitalSigns.textResult",
        "short" : "A.2.6.2.2 - Examination result text",
        "definition" : "Textual description of the result or a comment to the structured examination result.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.vitalSigns.textResult.description",
        "path" : "ObjectiveFindingsEmsCz.vitalSigns.textResult.description",
        "short" : "A.2.6.2.2.1 - Examination description",
        "definition" : "Description of the examination including the examination code, date and time of examination.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.vitalSigns.textResult.date",
        "path" : "ObjectiveFindingsEmsCz.vitalSigns.textResult.date",
        "short" : "A.2.6.2.2.2 - Date and time of measurement",
        "definition" : "Date and time related to a specific measurement.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.vitalSigns.parametricRecord",
        "path" : "ObjectiveFindingsEmsCz.vitalSigns.parametricRecord",
        "short" : "A.2.6.2.3 - Parametric record of the examination result",
        "definition" : "Parametric entry of the examination result.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.vitalSigns.parametricRecord.description",
        "path" : "ObjectiveFindingsEmsCz.vitalSigns.parametricRecord.description",
        "short" : "A.2.6.2.3.1 - Examination description",
        "definition" : "Description of the examination including the examination code, date and time of examination.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.vitalSigns.parametricRecord.oxigenAdministration",
        "path" : "ObjectiveFindingsEmsCz.vitalSigns.parametricRecord.oxigenAdministration",
        "short" : "A.2.6.2.3.2 - Oxygen administration",
        "definition" : "Information about oxygen administration during SpO2 value measurement.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.vitalSigns.parametricRecord.oxgenFlow",
        "path" : "ObjectiveFindingsEmsCz.vitalSigns.parametricRecord.oxgenFlow",
        "short" : "A.2.6.2.3.3 - Oxygen flow rate",
        "definition" : "Information about oxygen flow rate during SpO2 value measurement.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.vitalSigns.parametricRecord.result",
        "path" : "ObjectiveFindingsEmsCz.vitalSigns.parametricRecord.result",
        "short" : "A.2.6.2.3.4 - Formalized examination result",
        "definition" : "Examination result as text and/or in the form of numerical and coded measurement results. Furthermore, details on how the tests were performed to obtain the final values, information on reference ranges and interpretation of the result. The content of the examination result will differ according to the type of examination.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.vitalSigns.parametricRecord.date",
        "path" : "ObjectiveFindingsEmsCz.vitalSigns.parametricRecord.date",
        "short" : "A.2.6.2.3.5 - Date and time of measurement",
        "definition" : "Date and time related to a specific measurement.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.otherParameters",
        "path" : "ObjectiveFindingsEmsCz.otherParameters",
        "short" : "A.2.6.3 - Other measured parameters",
        "definition" : "- Glycemia (mmol/l)\n- Consciousness - Glasgow Coma Scale (GCS, 3-15)\n- Consciousness - AVPU (A/V/P/U) - EtCO2",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.otherParameters.textResult",
        "path" : "ObjectiveFindingsEmsCz.otherParameters.textResult",
        "short" : "A.2.6.3.1 - Examination result text",
        "definition" : "Textual description of the examination result.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.otherParameters.parametricRecord",
        "path" : "ObjectiveFindingsEmsCz.otherParameters.parametricRecord",
        "short" : "A.2.6.3.2 - Parametric record of the examination result",
        "definition" : "Parametric entry of the examination result.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.otherParameters.parametricRecord.description",
        "path" : "ObjectiveFindingsEmsCz.otherParameters.parametricRecord.description",
        "short" : "A.2.6.3.2.1 - Examination description",
        "definition" : "Description of the examination, including the examination code, date and time of examination.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.otherParameters.parametricRecord.result",
        "path" : "ObjectiveFindingsEmsCz.otherParameters.parametricRecord.result",
        "short" : "A.2.6.3.2.2 - Formalized examination result",
        "definition" : "Examination result as text and/or in the form of numerical and coded measurement results. Furthermore, details on how the tests were performed to obtain the final values, information on reference ranges and interpretation of the result. The content of the examination result will differ according to the type of examination.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.otherParameters.parametricRecord.date",
        "path" : "ObjectiveFindingsEmsCz.otherParameters.parametricRecord.date",
        "short" : "A.2.6.3.2.3 - Date and time of measurement",
        "definition" : "Date and time related to a specific measurement.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.somaticExamination",
        "path" : "ObjectiveFindingsEmsCz.somaticExamination",
        "short" : "A.2.6.4 - Somatic examination",
        "definition" : "An examination using the senses of the examiner (by sight, listening, palpation, and percussion) and assessing whether the findings thus ascertained deviate from the norm. If so, we denote these deviations as objective signs.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.somaticExamination.description",
        "path" : "ObjectiveFindingsEmsCz.somaticExamination.description",
        "short" : "A.2.6.4.1 - Examination description",
        "definition" : "Description of the examination including the examination code, date and time of examination.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.somaticExamination.date",
        "path" : "ObjectiveFindingsEmsCz.somaticExamination.date",
        "short" : "A.2.6.4.2 - Date and time of examination",
        "definition" : "Date and time when the examination was performed.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.otherExamination",
        "path" : "ObjectiveFindingsEmsCz.otherExamination",
        "short" : "A.2.6.5 - Other examinations",
        "definition" : "Other examinations (For example, ECG, ultrasound, etc.).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.otherExamination.procedureName",
        "path" : "ObjectiveFindingsEmsCz.otherExamination.procedureName",
        "short" : "A.2.6.5.1 - Name of procedure",
        "definition" : "According to the ZZS (Emergency Medical Service) codebook.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.otherExamination.date",
        "path" : "ObjectiveFindingsEmsCz.otherExamination.date",
        "short" : "A.2.6.5.2 - Date and time of performance",
        "definition" : "Date and time of procedure performance.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsEmsCz.otherExamination.description",
        "path" : "ObjectiveFindingsEmsCz.otherExamination.description",
        "short" : "A.2.6.5.3 - Description of the examination",
        "definition" : "Textual description of the examination.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
