# A.2.9 - Průběh ošetření a doporučení (cz) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.9 - Průběh ošetření a doporučení (cz)**

## Logical Model: A.2.9 - Průběh ošetření a doporučení (cz) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/LogRecommendationsCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogCzRecommendationsCz |

 
Zpráva o výjezdu ZZS – Průběh ošetření a doporučení – A.2.9 CZ 

**Usages:**

* Use this Logical Model: [A - Zpráva o výjezdu (cz)](StructureDefinition-LogEmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/LogRecommendationsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogRecommendationsCz.csv), [Excel](StructureDefinition-LogRecommendationsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogRecommendationsCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogRecommendationsCz",
  "version" : "0.0.2",
  "name" : "LogCzRecommendationsCz",
  "title" : "A.2.9 - Průběh ošetření a doporučení (cz)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Zpráva o výjezdu ZZS – Průběh ošetření a doporučení – A.2.9 CZ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogRecommendationsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogRecommendationsCz",
        "path" : "LogRecommendationsCz",
        "short" : "A.2.9 - Průběh ošetření a doporučení (cz)",
        "definition" : "Zpráva o výjezdu ZZS – Průběh ošetření a doporučení – A.2.9 CZ"
      },
      {
        "id" : "LogRecommendationsCz.prubehOsetreni",
        "path" : "LogRecommendationsCz.prubehOsetreni",
        "short" : "A.2.9.1 - Průběh ošetření",
        "definition" : "Shrnutí průběhu ošetření, vývoje stavu",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogRecommendationsCz.prubehOsetreni.popis",
        "path" : "LogRecommendationsCz.prubehOsetreni.popis",
        "short" : "A.2.9.1.1 - Popis průběhu ošetření",
        "definition" : "Textový popis průběhu ošetření. Zadává lékař volným textem.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogRecommendationsCz.prubehOsetreni.casoveRazitko",
        "path" : "LogRecommendationsCz.prubehOsetreni.casoveRazitko",
        "short" : "A.2.9.1.2 - Časové razítko",
        "definition" : "Datum a čas zápisu. Doplní systém.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogRecommendationsCz.doporuceni",
        "path" : "LogRecommendationsCz.doporuceni",
        "short" : "A.2.9.2 - Doporučení",
        "definition" : "Doporučení pro pacienta po ukončení ošetření",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogRecommendationsCz.doporuceni.popis",
        "path" : "LogRecommendationsCz.doporuceni.popis",
        "short" : "A.2.9.2.1 - Popis doporučení",
        "definition" : "Doporučení pro další postup – např. doporučená medikace, dietní a režimová opatření, kontrola lékařem, pokyny pro postup při zhoršení stavu, kontakt na tísňovou linku apod. Zadává lékař volným textem.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
