# A.2.9 - Course of Treatment and Recommendations (en) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.9 - Course of Treatment and Recommendations (en)**

## Logical Model: A.2.9 - Course of Treatment and Recommendations (en) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/LogRecommendations | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogEnRecommendations |

 
Emergency Medical Service Report – Course of Treatment and Recommendations – A.2.9 EN 

**Usages:**

* Use this Logical Model: [A - EMS Report (en)](StructureDefinition-EmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/LogRecommendations)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogRecommendations.csv), [Excel](StructureDefinition-LogRecommendations.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogRecommendations",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogRecommendations",
  "version" : "0.0.2",
  "name" : "LogEnRecommendations",
  "title" : "A.2.9 - Course of Treatment and Recommendations (en)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Emergency Medical Service Report – Course of Treatment and Recommendations – A.2.9 EN",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogRecommendations",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogRecommendations",
        "path" : "LogRecommendations",
        "short" : "A.2.9 - Course of Treatment and Recommendations (en)",
        "definition" : "Emergency Medical Service Report – Course of Treatment and Recommendations – A.2.9 EN"
      },
      {
        "id" : "LogRecommendations.courseOfTreatment",
        "path" : "LogRecommendations.courseOfTreatment",
        "short" : "A.2.9.1 - Course of Treatment",
        "definition" : "Summary of the course of treatment and progression of the patient’s condition.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogRecommendations.courseOfTreatment.description",
        "path" : "LogRecommendations.courseOfTreatment.description",
        "short" : "A.2.9.1.1 - Course Description",
        "definition" : "Text description of the course of treatment. Entered by the physician as free text.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogRecommendations.courseOfTreatment.timestamp",
        "path" : "LogRecommendations.courseOfTreatment.timestamp",
        "short" : "A.2.9.1.2 - Timestamp",
        "definition" : "Date and time of the entry. Provided by the system.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogRecommendations.recommendations",
        "path" : "LogRecommendations.recommendations",
        "short" : "A.2.9.2 - Recommendations",
        "definition" : "Recommendations for the patient after completion of treatment.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogRecommendations.recommendations.description",
        "path" : "LogRecommendations.recommendations.description",
        "short" : "A.2.9.2.1 - Recommendation Description",
        "definition" : "Recommendations for further care – e.g., prescribed medication, dietary and lifestyle measures, follow-up with a physician, instructions in case of deterioration, emergency contact, etc. Entered by the physician as free text.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
