# A.2.6 - Objektivní nález - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.6 - Objektivní nález**

## Logical Model: A.2.6 - Objektivní nález 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/LogObjectiveFindingsEmsCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogCzObjectiveFindingsEmsCz |

 
Zpráva o výjezdu ZZS - Objektivní nález. 

**Usages:**

* Use this Logical Model: [A - Zpráva o výjezdu (cz)](StructureDefinition-LogEmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/LogObjectiveFindingsEmsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogObjectiveFindingsEmsCz.csv), [Excel](StructureDefinition-LogObjectiveFindingsEmsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogObjectiveFindingsEmsCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogObjectiveFindingsEmsCz",
  "version" : "0.0.2",
  "name" : "LogCzObjectiveFindingsEmsCz",
  "title" : "A.2.6 - Objektivní nález",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Zpráva o výjezdu ZZS - Objektivní nález.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogObjectiveFindingsEmsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogObjectiveFindingsEmsCz",
        "path" : "LogObjectiveFindingsEmsCz",
        "short" : "A.2.6 - Objektivní nález",
        "definition" : "Zpráva o výjezdu ZZS - Objektivní nález."
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.antropometrickeUdaje",
        "path" : "LogObjectiveFindingsEmsCz.antropometrickeUdaje",
        "short" : "A.2.6.1 - Antropometrické údaje",
        "definition" : "Výsledky antropometrických měření pacienta: výška, hmotnost, BMI (automatický výpočet z uvedených hodnot). Volitelné: obvod hlavy, hrudníku, břicha.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.antropometrickeUdaje.textovyVysledek",
        "path" : "LogObjectiveFindingsEmsCz.antropometrickeUdaje.textovyVysledek",
        "short" : "A.2.6.1.1 - Výsledek vyšetření textem",
        "definition" : "Textový popis výsledku vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.antropometrickeUdaje.parametrickyZaznam",
        "path" : "LogObjectiveFindingsEmsCz.antropometrickeUdaje.parametrickyZaznam",
        "short" : "A.2.6.1.2 - Parametrický záznam vyšetření",
        "definition" : "Parametrický zápis výsledku vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.antropometrickeUdaje.parametrickyZaznam.popis",
        "path" : "LogObjectiveFindingsEmsCz.antropometrickeUdaje.parametrickyZaznam.popis",
        "short" : "A.2.6.1.2.1 - Popis vyšetření",
        "definition" : "Popis vyšetření včetně kódu vyšetření, vyšetřované oblasti či vzorku, datum a čas odběru vzorku.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.antropometrickeUdaje.parametrickyZaznam.vysledek",
        "path" : "LogObjectiveFindingsEmsCz.antropometrickeUdaje.parametrickyZaznam.vysledek",
        "short" : "A.2.6.1.2.2 - Výsledek vyšetření formalizovaný",
        "definition" : "Výsledek vyšetření textem a/nebo ve formě číselných a kódovaných výsledků měření. Obsah výsledku vyšetření se bude lišit podle typu vyšetření..",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.zivotniFunkce",
        "path" : "LogObjectiveFindingsEmsCz.zivotniFunkce",
        "short" : "A.2.6.2 - Základní životní funkce",
        "definition" : "Výsledky měření základních životních funkcí pacienta včetně časového razítka měření. (Měření životních funkcí se může opakovat v různých časech výjezdu).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.zivotniFunkce.typVysetreni",
        "path" : "LogObjectiveFindingsEmsCz.zivotniFunkce.typVysetreni",
        "short" : "A.2.6.2.1 - Typ vyšetření",
        "definition" : "Klasifikace typu vyšetření. Zde fixní hodnota ''vital-signs''",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.zivotniFunkce.textovyVysledek",
        "path" : "LogObjectiveFindingsEmsCz.zivotniFunkce.textovyVysledek",
        "short" : "A.2.6.2.2 - Výsledek vyšetření textem",
        "definition" : "Textový popis výsledku nebo komentář ke strukturovanému výsledku vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.zivotniFunkce.textovyVysledek.popis",
        "path" : "LogObjectiveFindingsEmsCz.zivotniFunkce.textovyVysledek.popis",
        "short" : "A.2.6.2.2.1 - Výsledek vyšetření textem",
        "definition" : "Textový popis výsledku nebo komentář ke strukturovanému výsledku vyšetření.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.zivotniFunkce.textovyVysledek.datum",
        "path" : "LogObjectiveFindingsEmsCz.zivotniFunkce.textovyVysledek.datum",
        "short" : "A.2.6.2.2.2 - Datum a čas měření",
        "definition" : "Datum a čas vztažený ke konkrétnímu měření.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.zivotniFunkce.parametrickyZaznam",
        "path" : "LogObjectiveFindingsEmsCz.zivotniFunkce.parametrickyZaznam",
        "short" : "A.2.6.2.3 - Parametrický záznam výsledku vyšetření",
        "definition" : "Parametrický zápis výsledku vyšetření.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.zivotniFunkce.parametrickyZaznam.popis",
        "path" : "LogObjectiveFindingsEmsCz.zivotniFunkce.parametrickyZaznam.popis",
        "short" : "A.2.6.2.3.1 - Popis vyšetření",
        "definition" : "Popis vyšetření včetně kódu vyšetření,  datum a čas vyšetření.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.zivotniFunkce.parametrickyZaznam.podaniKysliku",
        "path" : "LogObjectiveFindingsEmsCz.zivotniFunkce.parametrickyZaznam.podaniKysliku",
        "short" : "A.2.6.2.3.2 - Podání kyslíku",
        "definition" : "Informace o podávání kyslíku při měření hodnoty SpO2.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.zivotniFunkce.parametrickyZaznam.prutokKysliku",
        "path" : "LogObjectiveFindingsEmsCz.zivotniFunkce.parametrickyZaznam.prutokKysliku",
        "short" : "A.2.6.2.3.3 - Průtok kyslíku",
        "definition" : "Informace o průtoku kyslíku při měření hodnoty SpO2.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.zivotniFunkce.parametrickyZaznam.vysledek",
        "path" : "LogObjectiveFindingsEmsCz.zivotniFunkce.parametrickyZaznam.vysledek",
        "short" : "A.2.6.2.3.4 - Výsledek vyšetření formalizovaný",
        "definition" : "Výsledek vyšetření textem a/nebo ve formě číselných a kódovaných výsledků měření. Dále podrobnosti o tom, jak byly testy provedeny k získání výsledných hodnot, informace o referenčních rozmezích a interpretaci výsledku. Obsah výsledku vyšetření se bude lišit podle typu vyšetření.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.zivotniFunkce.parametrickyZaznam.datum",
        "path" : "LogObjectiveFindingsEmsCz.zivotniFunkce.parametrickyZaznam.datum",
        "short" : "A.2.6.2.3.5 - Datum a čas měření",
        "definition" : "Datum a čas vztažený ke konkrétnímu měření.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.dalsiParametry",
        "path" : "LogObjectiveFindingsEmsCz.dalsiParametry",
        "short" : "A.2.6.3 - Další měřené parametry",
        "definition" : "- glykemie (mmol/l)\n- vědomí - Glasgow Coma Scale (GCS, 3-15)\n- vědomí - AVPU (A/V/P/U)\n- EtCO2",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.dalsiParametry.textovyVysledek",
        "path" : "LogObjectiveFindingsEmsCz.dalsiParametry.textovyVysledek",
        "short" : "A.2.6.3.1 - Výsledek vyšetření textem",
        "definition" : "Textový popis výsledku vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.dalsiParametry.parametrickyZaznam",
        "path" : "LogObjectiveFindingsEmsCz.dalsiParametry.parametrickyZaznam",
        "short" : "A.2.6.3.2 - Parametrický záznam výsledku vyšetření",
        "definition" : "Parametrický zápis výsledku vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.dalsiParametry.parametrickyZaznam.popis",
        "path" : "LogObjectiveFindingsEmsCz.dalsiParametry.parametrickyZaznam.popis",
        "short" : "A.2.6.3.2.1 - Popis vyšetření",
        "definition" : "Popis vyšetření včetně kódu vyšetření, datum a čas vyšetření.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.dalsiParametry.parametrickyZaznam.vysledek",
        "path" : "LogObjectiveFindingsEmsCz.dalsiParametry.parametrickyZaznam.vysledek",
        "short" : "A.2.6.3.2.2 - Výsledek vyšetření formalizovaný",
        "definition" : "Výsledek vyšetření textem a/nebo ve formě číselných a kódovaných výsledků měření. Dále podrobnosti o tom, jak byly testy provedeny k získání výsledných hodnot, informace o referenčních rozmezích a interpretaci výsledku. Obsah výsledku vyšetření se bude lišit podle typu vyšetření.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.dalsiParametry.parametrickyZaznam.datum",
        "path" : "LogObjectiveFindingsEmsCz.dalsiParametry.parametrickyZaznam.datum",
        "short" : "A.2.6.3.2.3 - Datum a čas měření",
        "definition" : "Datum a čas vztažený ke konkrétnímu měření.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.somatickeVysetreni",
        "path" : "LogObjectiveFindingsEmsCz.somatickeVysetreni",
        "short" : "A.2.6.4 - Somatické vyšetření",
        "definition" : "Vyšetření pomocí smyslů vyšetřujícího (pohledem, poslechem, pohmatem a poklepem) a posuzování, zda se takto zjištěné nálezy odchylují od normy. Pokud ano, označujeme tyto odchylky jako objektivní příznaky (angl. signs).",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.somatickeVysetreni.popis",
        "path" : "LogObjectiveFindingsEmsCz.somatickeVysetreni.popis",
        "short" : "A.2.6.4.1 - Výsledek vyšetření textem",
        "definition" : "Textový popis výsledku nebo komentář ke strukturovanému výsledku vyšetření.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.somatickeVysetreni.datum",
        "path" : "LogObjectiveFindingsEmsCz.somatickeVysetreni.datum",
        "short" : "A.2.6.4.2 - Datum a čas vyšetření",
        "definition" : "Datum a čas kdy bylo vyšetření provedeno.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.jineVysetreni",
        "path" : "LogObjectiveFindingsEmsCz.jineVysetreni",
        "short" : "A.2.6.5 - Jiná vyšetření",
        "definition" : "Další vyšetření (Například EKG, ultrazvuk, apod).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.jineVysetreni.nazevVykonu",
        "path" : "LogObjectiveFindingsEmsCz.jineVysetreni.nazevVykonu",
        "short" : "A.2.6.5.1 - Název výkonu",
        "definition" : "Dle číselníku ZZS.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.jineVysetreni.datum",
        "path" : "LogObjectiveFindingsEmsCz.jineVysetreni.datum",
        "short" : "A.2.6.5.2 - Datum a čas provedení",
        "definition" : "Datum a čas provedení výkonu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogObjectiveFindingsEmsCz.jineVysetreni.popis",
        "path" : "LogObjectiveFindingsEmsCz.jineVysetreni.popis",
        "short" : "A.2.6.5.3 - Popis vyšetření",
        "definition" : "Textový popis vyšetření",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
