# A.2.10 - Ukončení (cz) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.10 - Ukončení (cz)**

## Logical Model: A.2.10 - Ukončení (cz) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/LogEndOfCareCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogCzEndOfCareCz |

 
Zpráva o výjezdu ZZS – Ukončení – A.2.10 CZ 

**Usages:**

* Use this Logical Model: [A - Zpráva o výjezdu (cz)](StructureDefinition-LogEmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/LogEndOfCareCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogEndOfCareCz.csv), [Excel](StructureDefinition-LogEndOfCareCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogEndOfCareCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogEndOfCareCz",
  "version" : "0.0.2",
  "name" : "LogCzEndOfCareCz",
  "title" : "A.2.10 - Ukončení (cz)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Zpráva o výjezdu ZZS – Ukončení – A.2.10 CZ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogEndOfCareCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogEndOfCareCz",
        "path" : "LogEndOfCareCz",
        "short" : "A.2.10 - Ukončení (cz)",
        "definition" : "Zpráva o výjezdu ZZS – Ukončení – A.2.10 CZ"
      },
      {
        "id" : "LogEndOfCareCz.specifikaceUkonceni",
        "path" : "LogEndOfCareCz.specifikaceUkonceni",
        "short" : "A.2.10.1 - Specifikace ukončení",
        "definition" : "Specifikace ukončení péče",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogEndOfCareCz.specifikaceUkonceni.zpusobUkonceni",
        "path" : "LogEndOfCareCz.specifikaceUkonceni.zpusobUkonceni",
        "short" : "A.2.10.1.1 - Způsob ukončení",
        "definition" : "Popis způsobu ukončení péče o pacienta. Hodnota z číselníku Způsob ukončení.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogEndOfCareCz.specifikaceUkonceni.datumCasUmrti",
        "path" : "LogEndOfCareCz.specifikaceUkonceni.datumCasUmrti",
        "short" : "A.2.10.1.2 - Datum a čas úmrtí",
        "definition" : "Datum a čas úmrtí (odhadem).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogEndOfCareCz.specifikaceUkonceni.identifikaceCpalp",
        "path" : "LogEndOfCareCz.specifikaceUkonceni.identifikaceCpalp",
        "short" : "A.2.10.1.3 - Identifikace CPALP",
        "definition" : "Identifikátor cílového poskytovatele lůžkové akutní péče. Hodnota z Kmenového registru PZS.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogEndOfCareCz.specifikaceUkonceni.identifikaceOddeleni",
        "path" : "LogEndOfCareCz.specifikaceUkonceni.identifikaceOddeleni",
        "short" : "A.2.10.1.4 - Identifikace oddělení",
        "definition" : "Identifikátor cílového oddělení CPALP. Hodnota z Kmenového registru PZS.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogEndOfCareCz.specifikaceUkonceni.identifikacePredavajiciPracovnikZzs",
        "path" : "LogEndOfCareCz.specifikaceUkonceni.identifikacePredavajiciPracovnikZzs",
        "short" : "A.2.10.1.5 - Identifikace předávajícího pracovníka ZZS",
        "definition" : "Identifikátor předávajícího pracovníka záchranné služby. Hodnota z Kmenového registru ZP.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogEndOfCareCz.specifikaceUkonceni.identifikacePrebirajiciZdravotnikCpalp",
        "path" : "LogEndOfCareCz.specifikaceUkonceni.identifikacePrebirajiciZdravotnikCpalp",
        "short" : "A.2.10.1.6 - Identifikace přebírajícího zdravotníka CPALP",
        "definition" : "Identifikátor přebírajícího zdravotníka. Hodnota z Kmenového registru ZP.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogEndOfCareCz.specifikaceUkonceni.identifikacePrebirajiciZdravotnikText",
        "path" : "LogEndOfCareCz.specifikaceUkonceni.identifikacePrebirajiciZdravotnikText",
        "short" : "A.2.10.1.7 - Identifikace přebírajícího zdravotníka CPALP textem",
        "definition" : "Textová informace o přebírajícím zdravotníkovi, pokud není dostupný kód z registru.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
