# A.2.10 - End of Care (en) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.10 - End of Care (en)**

## Logical Model: A.2.10 - End of Care (en) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/LogEndOfCare | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogEnEndOfCare |

 
Emergency Medical Service Report – End of Care – A.2.10 EN 

**Usages:**

* Use this Logical Model: [A - EMS Report (en)](StructureDefinition-EmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/LogEndOfCare)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogEndOfCare.csv), [Excel](StructureDefinition-LogEndOfCare.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogEndOfCare",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogEndOfCare",
  "version" : "0.0.2",
  "name" : "LogEnEndOfCare",
  "title" : "A.2.10 - End of Care (en)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Emergency Medical Service Report – End of Care – A.2.10 EN",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogEndOfCare",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogEndOfCare",
        "path" : "LogEndOfCare",
        "short" : "A.2.10 - End of Care (en)",
        "definition" : "Emergency Medical Service Report – End of Care – A.2.10 EN"
      },
      {
        "id" : "LogEndOfCare.endOfCareSpecification",
        "path" : "LogEndOfCare.endOfCareSpecification",
        "short" : "A.2.10.1 - End of Care Specification",
        "definition" : "Specification of patient end of care/discharge.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogEndOfCare.endOfCareSpecification.endOfCareMethod",
        "path" : "LogEndOfCare.endOfCareSpecification.endOfCareMethod",
        "short" : "A.2.10.1.1 - Method of End of Care",
        "definition" : "Description of the way in which patient care was concluded. Value from the “Method of End of Care” code list.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogEndOfCare.endOfCareSpecification.dateTimeOfDeath",
        "path" : "LogEndOfCare.endOfCareSpecification.dateTimeOfDeath",
        "short" : "A.2.10.1.2 - Date and Time of Death",
        "definition" : "Date and time of death (estimated).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogEndOfCare.endOfCareSpecification.cpalpIdentifier",
        "path" : "LogEndOfCare.endOfCareSpecification.cpalpIdentifier",
        "short" : "A.2.10.1.3 - CPALP Identifier",
        "definition" : "Identifier of the target provider of inpatient acute care. Value from the National Register of Healthcare Providers (PZS).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogEndOfCare.endOfCareSpecification.departmentIdentifier",
        "path" : "LogEndOfCare.endOfCareSpecification.departmentIdentifier",
        "short" : "A.2.10.1.4 - Department Identifier",
        "definition" : "Identifier of the target CPALP department. Value from the National Register of Healthcare Providers (PZS).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogEndOfCare.endOfCareSpecification.handingOverStaffZzs",
        "path" : "LogEndOfCare.endOfCareSpecification.handingOverStaffZzs",
        "short" : "A.2.10.1.5 - EMS Handing-Over Staff Identifier",
        "definition" : "Identifier of the Emergency Medical Service staff member handing the patient over. Value from the National Register of Healthcare Professionals (ZP).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogEndOfCare.endOfCareSpecification.receivingStaffCpalp",
        "path" : "LogEndOfCare.endOfCareSpecification.receivingStaffCpalp",
        "short" : "A.2.10.1.6 - Receiving CPALP Healthcare Professional Identifier",
        "definition" : "Identifier of the receiving healthcare professional. Value from the National Register of Healthcare Professionals (ZP).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogEndOfCare.endOfCareSpecification.receivingStaffText",
        "path" : "LogEndOfCare.endOfCareSpecification.receivingStaffText",
        "short" : "A.2.10.1.7 - Receiving CPALP Healthcare Professional (Text)",
        "definition" : "Free-text information about the receiving healthcare professional, if no code from the register is available.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
