# A.2.2 - Časová osa výjezdu (cz) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.2 - Časová osa výjezdu (cz)**

## Logical Model: A.2.2 - Časová osa výjezdu (cz) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/LogDispatchTimelineCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogCzDispatchTimelineCz |

 
Záznam o výjezdu - Časová osa výjezdu - A.2.2 CZ 

**Usages:**

* Use this Logical Model: [A - Zpráva o výjezdu (cz)](StructureDefinition-LogEmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/LogDispatchTimelineCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogDispatchTimelineCz.csv), [Excel](StructureDefinition-LogDispatchTimelineCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogDispatchTimelineCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogDispatchTimelineCz",
  "version" : "0.0.2",
  "name" : "LogCzDispatchTimelineCz",
  "title" : "A.2.2 - Časová osa výjezdu (cz)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Záznam o výjezdu - Časová osa výjezdu - A.2.2 CZ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogDispatchTimelineCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogDispatchTimelineCz",
        "path" : "LogDispatchTimelineCz",
        "short" : "A.2.2 - Časová osa výjezdu (cz)",
        "definition" : "Záznam o výjezdu - Časová osa výjezdu - A.2.2 CZ"
      },
      {
        "id" : "LogDispatchTimelineCz.casOznameniUdalosti",
        "path" : "LogDispatchTimelineCz.casOznameniUdalosti",
        "short" : "A.2.2.1 - Čas oznámení události",
        "definition" : "Přijetí oznámení na operačním středisku",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogDispatchTimelineCz.casVyzvy",
        "path" : "LogDispatchTimelineCz.casVyzvy",
        "short" : "A.2.2.2 - Čas výzvy",
        "definition" : "Předání pokynu k výjezdu výjezdové skupině",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogDispatchTimelineCz.casVyjezdu",
        "path" : "LogDispatchTimelineCz.casVyjezdu",
        "short" : "A.2.2.3 - Čas výjezdu",
        "definition" : "Čas, kdy výjezdová skupina zahájila výjezd",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogDispatchTimelineCz.casPrijezduNaMistoUdalosti",
        "path" : "LogDispatchTimelineCz.casPrijezduNaMistoUdalosti",
        "short" : "A.2.2.4 - Čas příjezdu na místo události",
        "definition" : "Čas, kdy výjezdová skupina dosáhla místa události",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogDispatchTimelineCz.casOdjezduZMistaUdalosti",
        "path" : "LogDispatchTimelineCz.casOdjezduZMistaUdalosti",
        "short" : "A.2.2.5 - Čas odjezdu z místa události",
        "definition" : "Čas, kdy výjezdová skupina odjela z místa události",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogDispatchTimelineCz.casPrijezduDoMistaPredani",
        "path" : "LogDispatchTimelineCz.casPrijezduDoMistaPredani",
        "short" : "A.2.2.6 - Čas příjezdu do místa předání",
        "definition" : "Čas, kdy výjezdová skupina přijela do místa předání",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogDispatchTimelineCz.casPredaniPacienta",
        "path" : "LogDispatchTimelineCz.casPredaniPacienta",
        "short" : "A.2.2.7 - Čas předání pacienta",
        "definition" : "Čas, kdy výjezdová skupina předala pacienta CPALP nebo ukončila péči o pacienta",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogDispatchTimelineCz.casUkonceniVyjezdu",
        "path" : "LogDispatchTimelineCz.casUkonceniVyjezdu",
        "short" : "A.2.2.8 - Čas ukončení výjezdu",
        "definition" : "Čas, kdy výjezdová skupina formálně ukončila výjezd",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
