# A.2.1 - Údaje o výjezdu (cz) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.1 - Údaje o výjezdu (cz)**

## Logical Model: A.2.1 - Údaje o výjezdu (cz) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/LogDispatchDataCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogCzDispatchDataCz |

 
Záznam o výjezdu - Údaje o výjezdu - A.2.1 CZ 

**Usages:**

* Use this Logical Model: [A - Zpráva o výjezdu (cz)](StructureDefinition-LogEmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/LogDispatchDataCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogDispatchDataCz.csv), [Excel](StructureDefinition-LogDispatchDataCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogDispatchDataCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogDispatchDataCz",
  "version" : "0.0.2",
  "name" : "LogCzDispatchDataCz",
  "title" : "A.2.1 - Údaje o výjezdu (cz)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Záznam o výjezdu - Údaje o výjezdu - A.2.1 CZ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogDispatchDataCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogDispatchDataCz",
        "path" : "LogDispatchDataCz",
        "short" : "A.2.1 - Údaje o výjezdu (cz)",
        "definition" : "Záznam o výjezdu - Údaje o výjezdu - A.2.1 CZ"
      },
      {
        "id" : "LogDispatchDataCz.identifikaceVyjezdu",
        "path" : "LogDispatchDataCz.identifikaceVyjezdu",
        "short" : "A.2.1.1 - Identifikace výjezdu",
        "definition" : "Identifikace výjezdu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.identifikaceVyjezdu.cisloVyjezdu",
        "path" : "LogDispatchDataCz.identifikaceVyjezdu.cisloVyjezdu",
        "short" : "A.2.1.1.1 - Číslo výjezdu",
        "definition" : "Číslo výjezdu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.identifikaceVyjezdu.dalsiIdentifikatorVyjezdu",
        "path" : "LogDispatchDataCz.identifikaceVyjezdu.dalsiIdentifikatorVyjezdu",
        "short" : "A.2.1.1.2 - Další identifikátor výjezdu",
        "definition" : "Další identifikátor výjezdu",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.identifikaceVozidla",
        "path" : "LogDispatchDataCz.identifikaceVozidla",
        "short" : "A.2.1.2 - Identifikace vozidla",
        "definition" : "Identifikace vozidla",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.identifikaceVozidla.registracniZnacka",
        "path" : "LogDispatchDataCz.identifikaceVozidla.registracniZnacka",
        "short" : "A.2.1.2.1 - Registrační značka",
        "definition" : "Registrační značka vozidla - volací znak a registrační značka vozidla (ev. imatrikulace vrtulníku)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.identifikaceClenuVyjezdoveSkupiny",
        "path" : "LogDispatchDataCz.identifikaceClenuVyjezdoveSkupiny",
        "short" : "A.2.1.3 - Identifikace členů výjezdové skupiny",
        "definition" : "Identifikace členů výjezdové skupiny",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.identifikaceClenuVyjezdoveSkupiny.identifikatorClenaPosadky",
        "path" : "LogDispatchDataCz.identifikaceClenuVyjezdoveSkupiny.identifikatorClenaPosadky",
        "short" : "A.2.1.3.1 - Identifikátor člena posádky",
        "definition" : "Identifikátor člena posádky",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.identifikaceClenuVyjezdoveSkupiny.jmeno",
        "path" : "LogDispatchDataCz.identifikaceClenuVyjezdoveSkupiny.jmeno",
        "short" : "A.2.1.3.2 - Jméno",
        "definition" : "Jméno člena posádky",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.identifikaceClenuVyjezdoveSkupiny.prijmeni",
        "path" : "LogDispatchDataCz.identifikaceClenuVyjezdoveSkupiny.prijmeni",
        "short" : "A.2.1.3.3 - Příjmení",
        "definition" : "Příjmení člena posádky",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.identifikaceClenuVyjezdoveSkupiny.role",
        "path" : "LogDispatchDataCz.identifikaceClenuVyjezdoveSkupiny.role",
        "short" : "A.2.1.3.4 - Role",
        "definition" : "Role člena posádky",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.identifikaceOperatoruZOS",
        "path" : "LogDispatchDataCz.identifikaceOperatoruZOS",
        "short" : "A.2.1.4 - Identifikace operátora ZOS",
        "definition" : "Identifikace operátora ZOS",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.identifikaceOperatoruZOS.identifikatorOperatora",
        "path" : "LogDispatchDataCz.identifikaceOperatoruZOS.identifikatorOperatora",
        "short" : "A.2.1.4.1 - Identifikátor operátora",
        "definition" : "Identifikátor operátora ZOS",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.identifikaceOperatoruZOS.jmeno",
        "path" : "LogDispatchDataCz.identifikaceOperatoruZOS.jmeno",
        "short" : "A.2.1.4.2 - Jméno",
        "definition" : "Jméno operátora ZOS",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.identifikaceOperatoruZOS.prijmeni",
        "path" : "LogDispatchDataCz.identifikaceOperatoruZOS.prijmeni",
        "short" : "A.2.1.4.3 - Příjmení",
        "definition" : "Příjmení operátora ZOS",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.identifikaceOperatoruZOS.role",
        "path" : "LogDispatchDataCz.identifikaceOperatoruZOS.role",
        "short" : "A.2.1.4.4 - Role",
        "definition" : "Role operátora ZOS",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.mistoZacatkuVyjezdu",
        "path" : "LogDispatchDataCz.mistoZacatkuVyjezdu",
        "short" : "A.2.1.5 - Místo začátku výjezdu",
        "definition" : "Místo odkud je výjezd realizován",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.mistoZacatkuVyjezdu.adresa",
        "path" : "LogDispatchDataCz.mistoZacatkuVyjezdu.adresa",
        "short" : "A.2.1.5.1 - Adresa",
        "definition" : "Adresa nebo GPS souřadnice místa začátku výjezdu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.mistoUdalosti",
        "path" : "LogDispatchDataCz.mistoUdalosti",
        "short" : "A.2.1.6 - Místo události",
        "definition" : "Místo události zásahu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.mistoUdalosti.adresaGPS",
        "path" : "LogDispatchDataCz.mistoUdalosti.adresaGPS",
        "short" : "A.2.1.6.1 - Adresa - GPS",
        "definition" : "GPS souřadnice místa události",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.mistoUdalosti.adresa",
        "path" : "LogDispatchDataCz.mistoUdalosti.adresa",
        "short" : "A.2.1.6.2 - Adresa",
        "definition" : "Adresa místa události",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.klasifikaceVyjezdu",
        "path" : "LogDispatchDataCz.klasifikaceVyjezdu",
        "short" : "A.2.1.7 - Klasifikace výjezdu",
        "definition" : "Klasifikace výjezdu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.klasifikaceVyjezdu.nalehavostVyjezdu",
        "path" : "LogDispatchDataCz.klasifikaceVyjezdu.nalehavostVyjezdu",
        "short" : "A.2.1.7.1 - Naléhavost výjezdu",
        "definition" : "Naléhavost výjezdu (1 až 4)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.klasifikaceVyjezdu.klasifikaceVyzvy",
        "path" : "LogDispatchDataCz.klasifikaceVyjezdu.klasifikaceVyzvy",
        "short" : "A.2.1.7.2 - Klasifikace výzvy",
        "definition" : "Klasifikace výzvy - předběžná informace o problému pacienta / důvod výjezdu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.kontaktVolajiciho",
        "path" : "LogDispatchDataCz.kontaktVolajiciho",
        "short" : "A.2.1.8 - Kontakt volajícího",
        "definition" : "Kontakt volajícího",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogDispatchDataCz.kontaktVolajiciho.telefon",
        "path" : "LogDispatchDataCz.kontaktVolajiciho.telefon",
        "short" : "A.2.1.8.1 - Telefon",
        "definition" : "Telefonní číslo volajícího",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      }
    ]
  }
}

```
