# A.2.8 - Diagnostický souhrn (cz) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.8 - Diagnostický souhrn (cz)**

## Logical Model: A.2.8 - Diagnostický souhrn (cz) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/LogDiagnostickySouhrnCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogCzDiagnosticSummaryCz |

 
Zpráva o výjezdu ZZS – Diagnostický souhrn – A.2.8 CZ 

**Usages:**

* Use this Logical Model: [A - Zpráva o výjezdu (cz)](StructureDefinition-LogEmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/LogDiagnostickySouhrnCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogDiagnostickySouhrnCz.csv), [Excel](StructureDefinition-LogDiagnostickySouhrnCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogDiagnostickySouhrnCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogDiagnostickySouhrnCz",
  "version" : "0.0.2",
  "name" : "LogCzDiagnosticSummaryCz",
  "title" : "A.2.8 - Diagnostický souhrn (cz)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Zpráva o výjezdu ZZS – Diagnostický souhrn – A.2.8 CZ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogDiagnostickySouhrnCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogDiagnostickySouhrnCz",
        "path" : "LogDiagnostickySouhrnCz",
        "short" : "A.2.8 - Diagnostický souhrn (cz)",
        "definition" : "Zpráva o výjezdu ZZS – Diagnostický souhrn – A.2.8 CZ"
      },
      {
        "id" : "LogDiagnostickySouhrnCz.diagnostickySouhrn",
        "path" : "LogDiagnostickySouhrnCz.diagnostickySouhrn",
        "short" : "A.2.8 Diagnostický souhrn",
        "definition" : "Všechny problémy/diagnózy, které ovlivňují péči během výjezdu ZZS.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogDiagnostickySouhrnCz.diagnostickySouhrn.upresneniDiagnozy",
        "path" : "LogDiagnostickySouhrnCz.diagnostickySouhrn.upresneniDiagnozy",
        "short" : "A.2.8.1 - Upřesnění diagnźy volným textem",
        "definition" : "Upřesnění diagnóz nebo problémů volným textem",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogDiagnostickySouhrnCz.diagnostickySouhrn.diagnozaFormalizovana",
        "path" : "LogDiagnostickySouhrnCz.diagnostickySouhrn.diagnozaFormalizovana",
        "short" : "A.2.8.2 - Diagnóza formalizovaná",
        "definition" : "Souhrn diagnóz řešených výjezdem ZZS formalizovaně",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogDiagnostickySouhrnCz.diagnostickySouhrn.kod",
        "path" : "LogDiagnostickySouhrnCz.diagnostickySouhrn.kod",
        "short" : "A.2.8.2.1 - Dg. kódem",
        "definition" : "Formalizované vyjádření zdravotního problému kódem (klasifikace).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogDiagnostickySouhrnCz.diagnostickySouhrn.text",
        "path" : "LogDiagnostickySouhrnCz.diagnostickySouhrn.text",
        "short" : "A.2.8.4 - Dg. textová reprezentace",
        "definition" : "Význam kódu dle použitého kódového systému.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
