# A.2.11 - Přílohy - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.11 - Přílohy**

## Logical Model: A.2.11 - Přílohy 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/LogAttachmentsEmsCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogCzAttachmentsEmsCz |

 
Záznam o výjezdu - Jedna příloha nebo kolekce příloh 

**Usages:**

* Use this Logical Model: [A - Zpráva o výjezdu (cz)](StructureDefinition-LogEmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/LogAttachmentsEmsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogAttachmentsEmsCz.csv), [Excel](StructureDefinition-LogAttachmentsEmsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogAttachmentsEmsCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogAttachmentsEmsCz",
  "version" : "0.0.2",
  "name" : "LogCzAttachmentsEmsCz",
  "title" : "A.2.11 - Přílohy",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Záznam o výjezdu - Jedna příloha nebo kolekce příloh",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogAttachmentsEmsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogAttachmentsEmsCz",
        "path" : "LogAttachmentsEmsCz",
        "short" : "A.2.11 - Přílohy",
        "definition" : "Záznam o výjezdu - Jedna příloha nebo kolekce příloh"
      },
      {
        "id" : "LogAttachmentsEmsCz.priloha",
        "path" : "LogAttachmentsEmsCz.priloha",
        "short" : "A.2.11.1 - Příloha",
        "definition" : "Libovolná příloha vybraná uživatelem",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAttachmentsEmsCz.typ",
        "path" : "LogAttachmentsEmsCz.typ",
        "short" : "A.2.11.1.1 - Typ přílohy",
        "definition" : "Definuje typ přílohy",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogAttachmentsEmsCz.format",
        "path" : "LogAttachmentsEmsCz.format",
        "short" : "A.2.11.1.2 - Formát přílohy",
        "definition" : "Definuje formát přílohy",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogAttachmentsEmsCz.nazev",
        "path" : "LogAttachmentsEmsCz.nazev",
        "short" : "A.2.11.1.3 - Název přílohy",
        "definition" : "Název, který blíže popisuje přílohu",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogAttachmentsEmsCz.popis",
        "path" : "LogAttachmentsEmsCz.popis",
        "short" : "A.2.11.1.4 - Popis přílohy",
        "definition" : "Doplňující popis přílohy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogAttachmentsEmsCz.datumACasPrilohy",
        "path" : "LogAttachmentsEmsCz.datumACasPrilohy",
        "short" : "A.2.11.1.5 - Datum a čas přílohy",
        "definition" : "Datum a čas pořízení přílohy",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogAttachmentsEmsCz.dokument",
        "path" : "LogAttachmentsEmsCz.dokument",
        "short" : "A.2.11.1.6 - Dokument",
        "definition" : "Fotografie, videozáznam, PDF z přístroje",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ]
      }
    ]
  }
}

```
