# A - EMS Report (en) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A - EMS Report (en)**

## Logical Model: A - EMS Report (en) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/EmsReportCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogEnEmsReportCz |

 
EMS Report EN 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/EmsReportCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-EmsReportCz.csv), [Excel](StructureDefinition-EmsReportCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "EmsReportCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/EmsReportCz",
  "version" : "0.0.2",
  "name" : "LogEnEmsReportCz",
  "title" : "A - EMS Report (en)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "EMS Report EN",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/EmsReportCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "EmsReportCz",
        "path" : "EmsReportCz",
        "short" : "A - EMS Report (en)",
        "definition" : "EMS Report EN"
      },
      {
        "id" : "EmsReportCz.header",
        "path" : "EmsReportCz.header",
        "short" : "A.1 - EMS Report header data element",
        "definition" : "EMS Report header data element",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/HeaderEmsCz"
          }
        ]
      },
      {
        "id" : "EmsReportCz.body",
        "path" : "EmsReportCz.body",
        "short" : "A.2 - EMS Report body data element",
        "definition" : "EMS Report body data element",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "EmsReportCz.body.dispatchData",
        "path" : "EmsReportCz.body.dispatchData",
        "short" : "A.2.1 - Dispatch Data",
        "definition" : "Dispatch data",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchDataCz"
          }
        ]
      },
      {
        "id" : "EmsReportCz.body.dispatchTimeline",
        "path" : "EmsReportCz.body.dispatchTimeline",
        "short" : "A.2.2 - Dispatch Timeline",
        "definition" : "Dispatch timeline",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchTimelineCz"
          }
        ]
      },
      {
        "id" : "EmsReportCz.body.patientHistory",
        "path" : "EmsReportCz.body.patientHistory",
        "short" : "A.2.3 - Patient History",
        "definition" : "Patient history (might include information about provenance of the information)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/PatientHistoryCz"
          }
        ]
      },
      {
        "id" : "EmsReportCz.body.alerts",
        "path" : "EmsReportCz.body.alerts",
        "short" : "A.2.4 - Alerts",
        "definition" : "Alerts",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/AlertsCz"
          }
        ]
      },
      {
        "id" : "EmsReportCz.body.presentingIllness",
        "path" : "EmsReportCz.body.presentingIllness",
        "short" : "A.2.5 - Presenting Illness",
        "definition" : "Presenting illness",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/PresentingIllnessEmsCz"
          }
        ]
      },
      {
        "id" : "EmsReportCz.body.objectiveFindings",
        "path" : "EmsReportCz.body.objectiveFindings",
        "short" : "A.2.6 - Objective Findings",
        "definition" : "Objective findings",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/ObjectiveFindingsEmsCz"
          }
        ]
      },
      {
        "id" : "EmsReportCz.body.therapy",
        "path" : "EmsReportCz.body.therapy",
        "short" : "A.2.7 - Therapy",
        "definition" : "Therapy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/TherapyEmsCz"
          }
        ]
      },
      {
        "id" : "EmsReportCz.body.diagnosticSummary",
        "path" : "EmsReportCz.body.diagnosticSummary",
        "short" : "A.2.8 - Diagnostic Summary",
        "definition" : "Diagnostic summary",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogDiagnosticSummary"
          }
        ]
      },
      {
        "id" : "EmsReportCz.body.clinicalCourseAndRecommendations",
        "path" : "EmsReportCz.body.clinicalCourseAndRecommendations",
        "short" : "A.2.9 - Clinical Course, Recommendations",
        "definition" : "Clinical course and recommendations",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogRecommendations"
          }
        ]
      },
      {
        "id" : "EmsReportCz.body.endOfCare",
        "path" : "EmsReportCz.body.endOfCare",
        "short" : "A.2.10 - End of Care",
        "definition" : "End of care",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogEndOfCare"
          }
        ]
      },
      {
        "id" : "EmsReportCz.body.attachments",
        "path" : "EmsReportCz.body.attachments",
        "short" : "A.2.11 - Dispatch Attachments",
        "definition" : "Dispatch attachments",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/AttachmentsEMSCz"
          }
        ]
      },
      {
        "id" : "EmsReportCz.presentedForm",
        "path" : "EmsReportCz.presentedForm",
        "short" : "A.3 - Presented Form",
        "definition" : "Entire order as issued. Various formats could be provided,  pdf format is recommended.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/PresentedFormCz"
          }
        ]
      },
      {
        "id" : "EmsReportCz.media",
        "path" : "EmsReportCz.media",
        "short" : "A.4 - Media Attachment",
        "definition" : "Aditional media attachment",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/AttachmentsCz"
          }
        ]
      }
    ]
  }
}

```
