# A.2.2 - Dispatch Timeline (en) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.2 - Dispatch Timeline (en)**

## Logical Model: A.2.2 - Dispatch Timeline (en) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchTimelineCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogEnDispatchTimelineCz |

 
EMS record – Dispatch Timeline – A.2.2 EN 

**Usages:**

* Use this Logical Model: [A - EMS Report (en)](StructureDefinition-EmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/DispatchTimelineCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-DispatchTimelineCz.csv), [Excel](StructureDefinition-DispatchTimelineCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "DispatchTimelineCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchTimelineCz",
  "version" : "0.0.2",
  "name" : "LogEnDispatchTimelineCz",
  "title" : "A.2.2 - Dispatch Timeline (en)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "EMS record – Dispatch Timeline – A.2.2 EN",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchTimelineCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "DispatchTimelineCz",
        "path" : "DispatchTimelineCz",
        "short" : "A.2.2 - Dispatch Timeline (en)",
        "definition" : "EMS record – Dispatch Timeline – A.2.2 EN"
      },
      {
        "id" : "DispatchTimelineCz.callReceivedTime",
        "path" : "DispatchTimelineCz.callReceivedTime",
        "short" : "A.2.2.1 - Event Notification Time",
        "definition" : "Time when the emergency call was received by the dispatch center",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "DispatchTimelineCz.dispatchNotifiedTime",
        "path" : "DispatchTimelineCz.dispatchNotifiedTime",
        "short" : "A.2.2.2 - Dispatch Notification Time",
        "definition" : "Time when the dispatch order was communicated to the responding crew",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "DispatchTimelineCz.unitEnRouteTime",
        "path" : "DispatchTimelineCz.unitEnRouteTime",
        "short" : "A.2.2.3 - En-Route Time",
        "definition" : "Time when the responding crew started the dispatch (left the base)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "DispatchTimelineCz.unitArrivedAtSceneTime",
        "path" : "DispatchTimelineCz.unitArrivedAtSceneTime",
        "short" : "A.2.2.4 - Arrival at Scene Time",
        "definition" : "Time when the responding crew arrived at the incident scene",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "DispatchTimelineCz.unitLeftSceneTime",
        "path" : "DispatchTimelineCz.unitLeftSceneTime",
        "short" : "A.2.2.5 - Left Scene Time",
        "definition" : "Time when the responding crew departed from the incident scene",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "DispatchTimelineCz.arrivedAtDestinationTime",
        "path" : "DispatchTimelineCz.arrivedAtDestinationTime",
        "short" : "A.2.2.6 - Arrival at Destination Time",
        "definition" : "Time when the responding crew arrived at the destination / transfer point",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "DispatchTimelineCz.patientTransferOfCareTime",
        "path" : "DispatchTimelineCz.patientTransferOfCareTime",
        "short" : "A.2.2.7 - Patient Transfer of Care Time",
        "definition" : "Time when the patient was handed over to the receiving facility (CPALP) or when patient care was terminated",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "DispatchTimelineCz.unitBackInServiceTime",
        "path" : "DispatchTimelineCz.unitBackInServiceTime",
        "short" : "A.2.2.8 - Back in Service Time",
        "definition" : "Time when the responding crew became available again / formally completed the dispatch",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
