# A.2.11 - Attachments EMS - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.11 - Attachments EMS**

## Logical Model: A.2.11 - Attachments EMS 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/AttachmentsEMSCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogEnAttachmentsEMSCz |

 
Emergency medical service Record - Single attachment or collection of attachments 

**Usages:**

* Use this Logical Model: [A - EMS Report (en)](StructureDefinition-EmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/AttachmentsEMSCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-AttachmentsEMSCz.csv), [Excel](StructureDefinition-AttachmentsEMSCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AttachmentsEMSCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/AttachmentsEMSCz",
  "version" : "0.0.2",
  "name" : "LogEnAttachmentsEMSCz",
  "title" : "A.2.11 - Attachments EMS",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Emergency medical service Record - Single attachment or collection of attachments",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/AttachmentsEMSCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "AttachmentsEMSCz",
        "path" : "AttachmentsEMSCz",
        "short" : "A.2.11 - Attachments EMS",
        "definition" : "Emergency medical service Record - Single attachment or collection of attachments"
      },
      {
        "id" : "AttachmentsEMSCz.attachment",
        "path" : "AttachmentsEMSCz.attachment",
        "short" : "A.2.11.1 - Attachment",
        "definition" : "Any attachment selected by the user",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "AttachmentsEMSCz.type",
        "path" : "AttachmentsEMSCz.type",
        "short" : "A.2.11.1.1 - Attachment type",
        "definition" : "Defines the attachment type",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AttachmentsEMSCz.format",
        "path" : "AttachmentsEMSCz.format",
        "short" : "A.2.11.1.2 - Attachment format",
        "definition" : "Defines the attachment format",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AttachmentsEMSCz.name",
        "path" : "AttachmentsEMSCz.name",
        "short" : "A.2.11.1.3 - Attachment name",
        "definition" : "Name that describes the attachment in more detail",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "AttachmentsEMSCz.description",
        "path" : "AttachmentsEMSCz.description",
        "short" : "A.2.11.1.4 - Attachment description",
        "definition" : "Additional attachment description",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "AttachmentsEMSCz.dateAndTimeOfAttachment",
        "path" : "AttachmentsEMSCz.dateAndTimeOfAttachment",
        "short" : "A.2.11.1.5 - Attachment date and time",
        "definition" : "Date and time of attachment creation",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "AttachmentsEMSCz.document",
        "path" : "AttachmentsEMSCz.document",
        "short" : "A.2.11.1.6 - Document",
        "definition" : "Photo, video, PDF from device",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ]
      }
    ]
  }
}

```
