# A.4 - Additional attachments - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.4 - Additional attachments**

## Logical Model: A.4 - Additional attachments 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/AttachmentsCz | *Version*:0.0.2 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnAttachmentsCz |

 
EMS report - additional attachments 

**Usages:**

* Use this Logical Model: [A - EMS Report (en)](StructureDefinition-EmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/AttachmentsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-AttachmentsCz.csv), [Excel](StructureDefinition-AttachmentsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AttachmentsCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/AttachmentsCz",
  "version" : "0.0.2",
  "name" : "LogEnAttachmentsCz",
  "title" : "A.4 - Additional attachments",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "EMS report - additional attachments",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/AttachmentsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "AttachmentsCz",
        "path" : "AttachmentsCz",
        "short" : "A.4 - Additional attachments",
        "definition" : "EMS report - additional attachments"
      },
      {
        "id" : "AttachmentsCz.contentType",
        "path" : "AttachmentsCz.contentType",
        "short" : "A.4.1 - Type of content",
        "definition" : "Type of content - MIME type is required",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AttachmentsCz.language",
        "path" : "AttachmentsCz.language",
        "short" : "A.4.2 - Language of content",
        "definition" : "Language of content - HL7 valueset of languages is required",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AttachmentsCz.data",
        "path" : "AttachmentsCz.data",
        "short" : "A.4.3 - Data of content",
        "definition" : "Data inline, base64ed",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ]
      },
      {
        "id" : "AttachmentsCz.url",
        "path" : "AttachmentsCz.url",
        "short" : "A.4.4 - URL of content",
        "definition" : "Uri where the data can be found",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "url"
          }
        ]
      },
      {
        "id" : "AttachmentsCz.title",
        "path" : "AttachmentsCz.title",
        "short" : "A.4.5 - Title of content",
        "definition" : "Label to display in place of the data",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "AttachmentsCz.creation",
        "path" : "AttachmentsCz.creation",
        "short" : "A.4.6 - Date of creation",
        "definition" : "Date attachment was first created",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
