# cz-organizationwithlogo-example - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **cz-organizationwithlogo-example**

## Example Organization: cz-organizationwithlogo-example

Profile: [Organization (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)

**Organization Logo**: [DocumentReference: status = current](Bundle-cz-example-bundle.md#urn-uuid-040eb849-a513-4d74-b3f3-d2f246a26877)

**identifier**: `https://ncez.mzcr.cz/fhir/sid/ico`/456789655

**type**: Fakultní nemocnice

**name**: Fakultní nemocnice Motol

**telecom**: [+420257216007](tel:+420257216007), fax: +420257216007(Work)

**address**: Plzeňská 951/125, 150 00 Praha 5(work)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "821077d6-ce17-4602-b3ad-d4bef845a950",
  "meta" : {
    "profile" : [
      "https://fhir.hl7cr.eu/core/StructureDefinition/cz-organization-core"
    ]
  },
  "extension" : [
    {
      "url" : "https://fhir.hl7cr.eu/core/StructureDefinition/cz-organization-logo",
      "valueReference" : {
        "reference" : "urn:uuid:040eb849-a513-4d74-b3f3-d2f246a26877"
      }
    }
  ],
  "identifier" : [
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/ico",
      "value" : "456789655"
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "https://ncez.mzcr.cz/fhir/CodeSystem/cz-drzar",
          "code" : "101",
          "display" : "Fakultní nemocnice"
        }
      ]
    }
  ],
  "name" : "Fakultní nemocnice Motol",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+420257216007",
      "use" : "work"
    },
    {
      "system" : "fax",
      "value" : "+420257216007",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "use" : "work",
      "type" : "both",
      "text" : "Plzeňská 951/125, 150 00 Praha 5",
      "line" : ["Plzeňská 951/125"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Plzeňská"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "951/125"
            }
          ]
        }
      ],
      "city" : "Praha",
      "postalCode" : "15000",
      "country" : "Česko",
      "_country" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
            "valueCoding" : {
              "system" : "urn:iso:std:iso:3166",
              "code" : "CZ",
              "display" : "Czechia"
            }
          }
        ]
      }
    }
  ]
}

```
