# CZ Objective Findings Model to this guide Map - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Objective Findings Model to this guide Map**

## ConceptMap: CZ Objective Findings Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/ConceptMap/ObjectiveFindingsEMS2FHIR-cz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:A.2.6 ObjectiveFindingsEMS2FHIR2FHIRcz |

 
CZ Emergency Medical Service Report ObjectiveFindings Model to this guide mapping 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.2.6 - Objective findings](StructureDefinition-ObjectiveFindingsEmsCz.md) to [Observation: Anthropometric Data - Height (EMS CZ)](StructureDefinition-cz-observation-height-ems.md)

* **Source Code**: ObjectiveFindingsEmsCz.antropometricData (A.2.6.1 - Anthropometric Data)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:objectiveFindings
  * **Comment**: Composition.section:objectiveFindings.entry.ofType(CZ_ObservationBMIEms or CZ_ObservationHeightEms or CZ_ObservationWeightEms)
* **Source Code**: antropometricData.textResult (A.2.6.1.1 - Examination result text)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Observation.valueString
  * **Comment**: 
* **Source Code**: antropometricData.parametricRecord.description (A.2.6.1.2.1 - Examination description)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Observation.code
  * **Comment**: 
* **Source Code**: antropometricData.parametricRecord.result (A.2.6.1.2.2 - Formalized examination result)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Observation.valueCodeableConcept
  * **Comment**: 

-------

**Group 2**Mapping from [A.2.6 - Objective findings](StructureDefinition-ObjectiveFindingsEmsCz.md) to [Observation: Vital Signs (EMS CZ)](StructureDefinition-cz-observation-vitalSigns-ems.md)

* **Source Code**: ObjectiveFindingsEmsCz.vitalSigns (A.2.6.2 - Basic Vital Signs)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:objectiveFindings
  * **Comment**: Composition.section:objectiveFindings.entry.ofType(CZ_ObservationVitalSignsEms)
* **Source Code**: vitalSigns.type (A.2.6.2.1 - Examination type)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Observation.code
  * **Comment**: 
* **Source Code**: vitalSigns.textResult.description (A.2.6.2.2.1 - Examination description)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Observation.valueString
  * **Comment**: 
* **Source Code**: vitalSigns.textResult.date (A.2.6.2.2.2 - Date and time of measurement)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Observation.effectiveDateTime
  * **Comment**: 
* **Source Code**: vitalSigns.parametricRecord.description (A.2.6.2.3.1 - Examination description)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Observation.code
  * **Comment**: 
* **Source Code**: vitalSigns.parametricRecord.result (A.2.6.2.3.4 - Formalized examination result)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Observation.valueCodeableConcept
  * **Comment**: 
* **Source Code**: vitalSigns.parametricRecord.date (A.2.6.2.3.5 - Date and time of measurement)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Observation.effectiveDateTime
  * **Comment**: 

-------

**Group 3**Mapping from [A.2.6 - Objective findings](StructureDefinition-ObjectiveFindingsEmsCz.md) to [Observation: Oxygen Therapy Observation (EMS CZ)](StructureDefinition-cz-observation-oxygen-ems.md)

* **Source Code**: ObjectiveFindingsEmsCz.vitalSigns.parametricRecord.oxigenAdministration(CZ_ObservationOxygenEms) (A.2.6.2 - Basic Vital Signs - Oxygen therapy)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:objectiveFindings
  * **Comment**: Composition.section:objectiveFindings.entry.ofType(CZ_ObservationOxygenEms)
* **Source Code**: oxigenAdministration (A.2.6.2.3.2 - Oxygen administration)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: CZ_ObservationOxygenEms.valueBoolean
  * **Comment**: 
* **Source Code**: oxgenFlow (A.2.6.2.3.3 - Oxygen flow rate)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: CZ_ObservationOxygenEms.component[OxygenFlowRate].code
  * **Comment**: 

-------

**Group 4**Mapping from [A.2.6 - Objective findings](StructureDefinition-ObjectiveFindingsEmsCz.md) to [Observation: Other Objective Findings (EMS CZ)](StructureDefinition-cz-observation-OtherOF-ems.md)

* **Source Code**: ObjectiveFindingsEmsCz.otherParameters (A.2.6.3 - Other measured parameters)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:objectiveFindings
  * **Comment**: Composition.section:objectiveFindings.entry.ofType(CZ_ObservationOtherOFEms)
* **Source Code**: otherParameters.textResult.description (A.2.6.3.1 - Examination result text)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Observation.valueString
  * **Comment**: 
* **Source Code**: otherParameters.parametricRecord.description (A.2.6.3.2.1 - Examination description)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Observation.code
  * **Comment**: 
* **Source Code**: otherParameters.parametricRecord.result (A.2.6.3.2.2 - Formalized examination result)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Observation.valueCodeableConcept
  * **Comment**: 
* **Source Code**: otherParameters.parametricRecord.textResult.date (A.2.6.3.2.3 - Date and time of measurement)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Observation.effectiveDateTime
  * **Comment**: 

-------

**Group 5**Mapping from [A.2.6 - Objective findings](StructureDefinition-ObjectiveFindingsEmsCz.md) to [Observation: Other Objective Findings (EMS CZ)](StructureDefinition-cz-observation-OtherOF-ems.md)

* **Source Code**: ObjectiveFindingsEmsCz.somaticExamination (A.2.6.4 - Somatic examination)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:objectiveFindings
  * **Comment**: Composition.section:objectiveFindings.entry.ofType(CZ_ObservationOtherOFEms)
* **Source Code**: somaticExamination.textResult.description (A.2.6.4.1 - Examination description)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Observation.valueString
  * **Comment**: 
* **Source Code**: somaticExamination.textResult.date (A.2.6.4.2 - Date and time of examination)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Observation.effectiveDateTime
  * **Comment**: 

-------

**Group 6**Mapping from [A.2.6 - Objective findings](StructureDefinition-ObjectiveFindingsEmsCz.md) to [Observation: Other Objective Findings (EMS CZ)](StructureDefinition-cz-observation-OtherOF-ems.md)

* **Source Code**: ObjectiveFindingsEmsCz.otherExamination (A.2.6.5 - Other examinations)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:objectiveFindings
  * **Comment**: Composition.section:objectiveFindings.entry.ofType(CZ_ObservationOtherOFEms)
* **Source Code**: otherExamination.procedureName (A.2.6.5.1 - Name of procedure)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Observation.valueCodeableConcept
  * **Comment**: 
* **Source Code**: otherExamination.description (A.2.6.5.2 - Date and time of performance)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Observation.valueString
  * **Comment**: 
* **Source Code**: otherExamination.date (A.2.6.5.3 - Description of the examination)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Observation.effectiveDateTime
  * **Comment**: 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "ObjectiveFindingsEMS2FHIR-cz",
  "url" : "https://hl7.cz/fhir/cz-ems/ConceptMap/ObjectiveFindingsEMS2FHIR-cz",
  "version" : "0.0.2",
  "name" : "A.2.6 ObjectiveFindingsEMS2FHIR2FHIRcz",
  "title" : "CZ Objective Findings Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ Emergency Medical Service Report ObjectiveFindings Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/ObjectiveFindingsEmsCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-height-ems",
      "element" : [
        {
          "code" : "ObjectiveFindingsEmsCz.antropometricData",
          "display" : "A.2.6.1 - Anthropometric Data",
          "target" : [
            {
              "code" : "Composition.section:objectiveFindings",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:objectiveFindings.entry.ofType(CZ_ObservationBMIEms or CZ_ObservationHeightEms or CZ_ObservationWeightEms)"
            }
          ]
        },
        {
          "code" : "antropometricData.textResult",
          "display" : "A.2.6.1.1 - Examination result text",
          "target" : [
            {
              "code" : "CZ_Observation.valueString",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "antropometricData.parametricRecord.description",
          "display" : "A.2.6.1.2.1 - Examination description",
          "target" : [
            {
              "code" : "CZ_Observation.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "antropometricData.parametricRecord.result",
          "display" : "A.2.6.1.2.2 - Formalized examination result",
          "target" : [
            {
              "code" : "CZ_Observation.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/ObjectiveFindingsEmsCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-vitalSigns-ems",
      "element" : [
        {
          "code" : "ObjectiveFindingsEmsCz.vitalSigns",
          "display" : "A.2.6.2 - Basic Vital Signs",
          "target" : [
            {
              "code" : "Composition.section:objectiveFindings",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:objectiveFindings.entry.ofType(CZ_ObservationVitalSignsEms)"
            }
          ]
        },
        {
          "code" : "vitalSigns.type",
          "display" : "A.2.6.2.1 - Examination type",
          "target" : [
            {
              "code" : "CZ_Observation.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "vitalSigns.textResult.description",
          "display" : "A.2.6.2.2.1 - Examination description",
          "target" : [
            {
              "code" : "CZ_Observation.valueString",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "vitalSigns.textResult.date",
          "display" : "A.2.6.2.2.2 - Date and time of measurement",
          "target" : [
            {
              "code" : "CZ_Observation.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "vitalSigns.parametricRecord.description",
          "display" : "A.2.6.2.3.1 - Examination description",
          "target" : [
            {
              "code" : "CZ_Observation.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "vitalSigns.parametricRecord.result",
          "display" : "A.2.6.2.3.4 - Formalized examination result",
          "target" : [
            {
              "code" : "CZ_Observation.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "vitalSigns.parametricRecord.date",
          "display" : "A.2.6.2.3.5 - Date and time of measurement",
          "target" : [
            {
              "code" : "CZ_Observation.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/ObjectiveFindingsEmsCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-oxygen-ems",
      "element" : [
        {
          "code" : "ObjectiveFindingsEmsCz.vitalSigns.parametricRecord.oxigenAdministration(CZ_ObservationOxygenEms)",
          "display" : "A.2.6.2 - Basic Vital Signs - Oxygen therapy",
          "target" : [
            {
              "code" : "Composition.section:objectiveFindings",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:objectiveFindings.entry.ofType(CZ_ObservationOxygenEms)"
            }
          ]
        },
        {
          "code" : "oxigenAdministration",
          "display" : "A.2.6.2.3.2 - Oxygen administration",
          "target" : [
            {
              "code" : "CZ_ObservationOxygenEms.valueBoolean",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "oxgenFlow",
          "display" : "A.2.6.2.3.3 - Oxygen flow rate",
          "target" : [
            {
              "code" : "CZ_ObservationOxygenEms.component[OxygenFlowRate].code",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/ObjectiveFindingsEmsCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-OtherOF-ems",
      "element" : [
        {
          "code" : "ObjectiveFindingsEmsCz.otherParameters",
          "display" : "A.2.6.3 - Other measured parameters",
          "target" : [
            {
              "code" : "Composition.section:objectiveFindings",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:objectiveFindings.entry.ofType(CZ_ObservationOtherOFEms)"
            }
          ]
        },
        {
          "code" : "otherParameters.textResult.description",
          "display" : "A.2.6.3.1 - Examination result text",
          "target" : [
            {
              "code" : "CZ_Observation.valueString",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "otherParameters.parametricRecord.description",
          "display" : "A.2.6.3.2.1 - Examination description",
          "target" : [
            {
              "code" : "CZ_Observation.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "otherParameters.parametricRecord.result",
          "display" : "A.2.6.3.2.2 - Formalized examination result",
          "target" : [
            {
              "code" : "CZ_Observation.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "otherParameters.parametricRecord.textResult.date",
          "display" : "A.2.6.3.2.3 - Date and time of measurement",
          "target" : [
            {
              "code" : "CZ_Observation.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/ObjectiveFindingsEmsCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-OtherOF-ems",
      "element" : [
        {
          "code" : "ObjectiveFindingsEmsCz.somaticExamination",
          "display" : "A.2.6.4 - Somatic examination",
          "target" : [
            {
              "code" : "Composition.section:objectiveFindings",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:objectiveFindings.entry.ofType(CZ_ObservationOtherOFEms)"
            }
          ]
        },
        {
          "code" : "somaticExamination.textResult.description",
          "display" : "A.2.6.4.1 - Examination description",
          "target" : [
            {
              "code" : "CZ_Observation.valueString",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "somaticExamination.textResult.date",
          "display" : "A.2.6.4.2 - Date and time of examination",
          "target" : [
            {
              "code" : "CZ_Observation.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/ObjectiveFindingsEmsCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-OtherOF-ems",
      "element" : [
        {
          "code" : "ObjectiveFindingsEmsCz.otherExamination",
          "display" : "A.2.6.5 - Other examinations",
          "target" : [
            {
              "code" : "Composition.section:objectiveFindings",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:objectiveFindings.entry.ofType(CZ_ObservationOtherOFEms)"
            }
          ]
        },
        {
          "code" : "otherExamination.procedureName",
          "display" : "A.2.6.5.1 - Name of procedure",
          "target" : [
            {
              "code" : "CZ_Observation.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "otherExamination.description",
          "display" : "A.2.6.5.2 - Date and time of performance",
          "target" : [
            {
              "code" : "CZ_Observation.valueString",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "otherExamination.date",
          "display" : "A.2.6.5.3 - Description of the examination",
          "target" : [
            {
              "code" : "CZ_Observation.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
