# CZ DispatchTimeline Model to this guide Map - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ DispatchTimeline Model to this guide Map**

## ConceptMap: CZ DispatchTimeline Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/ConceptMap/DispatchTimeline2FHIR-cz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:A.2.2 DispatchTimeline2FHIRcz |

 
CZ Emergency Medical Service Report DispatchTimeline Model to this guide mapping 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.2.2 - Dispatch Timeline (en)](StructureDefinition-DispatchTimelineCz.md) to [Communication: (EMS CZ)](StructureDefinition-cz-communication-ems.md)

* **Source Code**: DispatchTimelineCz.Communication (A.2.2.1 Event Notification (Communication))
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:dispatchTimeline
  * **Comment**: Composition.section:dispatchTimeline.entry.ofType(CZ_CommunicationEms)
* **Source Code**: callReceivedTime (A.2.2.1 - Event Notification Time)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Communication.received (received)
  * **Comment**: 

-------

**Group 2**Mapping from [A.2.2 - Dispatch Timeline (en)](StructureDefinition-DispatchTimelineCz.md) to [Task: (EMS CZ)](StructureDefinition-cz-task-ems.md)

* **Source Code**: DispatchTimelineCz.Task (A.2.2.2 Dispatch Notification (Task))
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:dispatchTimeline
  * **Comment**: Composition.section:dispatchTimeline.entry.ofType(CZ_TaskEms)
* **Source Code**: dispatchNotifiedTime (A.2.2.2 - Dispatch Notification Time)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Task.authoredOn (authoredOn)
  * **Comment**: 

-------

**Group 3**Mapping from [A.2.2 - Dispatch Timeline (en)](StructureDefinition-DispatchTimelineCz.md) to [Encounter EMS (CZ)](StructureDefinition-cz-encounter-ems.md)

* **Source Code**: DispatchTimelineCz.Encounter (A.2.2.x En-route/Scene/Destination/End (Encounter))
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:dispatchTimeline
  * **Comment**: Composition.section:dispatchTimeline.entry.ofType(CZ_EncounterEms)
* **Source Code**: unitEnRouteTime (A.2.2.3 - En-Route Time)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.period.start (period.start)
  * **Comment**: 
* **Source Code**: unitArrivedAtSceneTime (A.2.2.4 - Arrival at Scene Time)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.location[scene].period.start (location (slice: scene).period.start)
  * **Comment**: 
* **Source Code**: unitLeftSceneTime (A.2.2.5 - Left Scene Time)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.location[scene].period.end (location (slice: scene).period.end)
  * **Comment**: 
* **Source Code**: arrivedAtDestinationTime (A.2.2.6 - Arrival at Destination Time)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.location[destination].period.start (location (slice: destination).period.start)
  * **Comment**: 
* **Source Code**: patientTransferOfCareTime (A.2.2.7 - Patient Transfer of Care Time)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.location[destination].period.end (location (slice: destination).period.end)
  * **Comment**: 
* **Source Code**: unitBackInServiceTime (A.2.2.8 - Back in Service Time)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.period.end (period.end)
  * **Comment**: 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "DispatchTimeline2FHIR-cz",
  "url" : "https://hl7.cz/fhir/cz-ems/ConceptMap/DispatchTimeline2FHIR-cz",
  "version" : "0.0.2",
  "name" : "A.2.2 DispatchTimeline2FHIRcz",
  "title" : "CZ DispatchTimeline Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ Emergency Medical Service Report DispatchTimeline Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchTimelineCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-communication-ems",
      "element" : [
        {
          "code" : "DispatchTimelineCz.Communication",
          "display" : "A.2.2.1 Event Notification (Communication)",
          "target" : [
            {
              "code" : "Composition.section:dispatchTimeline",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:dispatchTimeline.entry.ofType(CZ_CommunicationEms)"
            }
          ]
        },
        {
          "code" : "callReceivedTime",
          "display" : "A.2.2.1 - Event Notification Time",
          "target" : [
            {
              "code" : "Communication.received",
              "display" : "received",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchTimelineCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-task-ems",
      "element" : [
        {
          "code" : "DispatchTimelineCz.Task",
          "display" : "A.2.2.2 Dispatch Notification (Task)",
          "target" : [
            {
              "code" : "Composition.section:dispatchTimeline",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:dispatchTimeline.entry.ofType(CZ_TaskEms)"
            }
          ]
        },
        {
          "code" : "dispatchNotifiedTime",
          "display" : "A.2.2.2 - Dispatch Notification Time",
          "target" : [
            {
              "code" : "Task.authoredOn",
              "display" : "authoredOn",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/DispatchTimelineCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-encounter-ems",
      "element" : [
        {
          "code" : "DispatchTimelineCz.Encounter",
          "display" : "A.2.2.x En-route/Scene/Destination/End (Encounter)",
          "target" : [
            {
              "code" : "Composition.section:dispatchTimeline",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:dispatchTimeline.entry.ofType(CZ_EncounterEms)"
            }
          ]
        },
        {
          "code" : "unitEnRouteTime",
          "display" : "A.2.2.3 - En-Route Time",
          "target" : [
            {
              "code" : "Encounter.period.start",
              "display" : "period.start",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "unitArrivedAtSceneTime",
          "display" : "A.2.2.4 - Arrival at Scene Time",
          "target" : [
            {
              "code" : "Encounter.location[scene].period.start",
              "display" : "location (slice: scene).period.start",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "unitLeftSceneTime",
          "display" : "A.2.2.5 - Left Scene Time",
          "target" : [
            {
              "code" : "Encounter.location[scene].period.end",
              "display" : "location (slice: scene).period.end",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "arrivedAtDestinationTime",
          "display" : "A.2.2.6 - Arrival at Destination Time",
          "target" : [
            {
              "code" : "Encounter.location[destination].period.start",
              "display" : "location (slice: destination).period.start",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "patientTransferOfCareTime",
          "display" : "A.2.2.7 - Patient Transfer of Care Time",
          "target" : [
            {
              "code" : "Encounter.location[destination].period.end",
              "display" : "location (slice: destination).period.end",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "unitBackInServiceTime",
          "display" : "A.2.2.8 - Back in Service Time",
          "target" : [
            {
              "code" : "Encounter.period.end",
              "display" : "period.end",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    }
  ]
}

```
