# CZ Attachment Model to this guide Map - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Attachment Model to this guide Map**

## ConceptMap: CZ Attachment Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/ConceptMap/AttachmentEMS2FHIR-cz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:AttachmentEMS2FHIRcz |

 
CZ Emergency Medical Service Report Attachment Model to this guide mapping 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.4 - Additional attachments](StructureDefinition-AttachmentsCz.md) to `https://hl7.cz/fhir/core/StructureDefinition/cz-attachment`

* **Source Code**: AttachmentsCz (A.2.11.1 - Attachments EMS)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: CZ_Attachment
* **Source Code**: AttachmentsCz.type (A.2.11.1.1 - Attachment type)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.type
* **Source Code**: AttachmentsCz.format (A.2.11.1.2 - Attachment format)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.attachment.contentType
* **Source Code**: AttachmentsCz.name (A.2.11.1.3 - Attachment name)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.attachment.title
* **Source Code**: AttachmentsCz.description (A.2.11.1.4 - Attachment description)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.description
* **Source Code**: AttachmentsCz.dateAndTimeOfAttachment (A.2.11.1.5 - Attachment date and time)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.attachment.creation
* **Source Code**: AttachmentsCz.document (A.2.11.1.6 - Document)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.attachment.data

-------

**Group 2**Mapping from [A.3 - Presented form](StructureDefinition-PresentedFormCz.md) to [Composition (EMS CZ)](StructureDefinition-cz-composition-ems.md)

* **Source Code**: PresentedForm (A.4 - Presented Form)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.extension:relatedArtifact.document
* **Source Code**: PresentedForm.contentType (A.4.1 - Content type of presented form)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: document.contentType
* **Source Code**: PresentedForm.language (A.4.2 - Language of presented form)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: document.language
* **Source Code**: PresentedForm.data (A.4.3 - Data of presented form)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: document.data
* **Source Code**: PresentedForm.url (A.4.4 - URL of presented form)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: document.url
* **Source Code**: PresentedForm.title (A.4.5 - Title of presented form)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: document.title
* **Source Code**: PresentedForm.creation (A.4.6 - Date and time of creation)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: document.creation

-------

**Group 3**Mapping from [A.4 - Additional attachments](StructureDefinition-AttachmentsCz.md) to `https://hl7.cz/fhir/core/StructureDefinition/cz-attachment`

* **Source Code**: AttachmentsCz (A.5 - Additional attachments)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Attachment.content
* **Source Code**: AttachmentsCz.contentType (A.5.1 - Content type of additional attachments)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.attachment.contentType
* **Source Code**: AttachmentsCz.language (A.5.2 - Language of additional attachments)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.attachment.language
* **Source Code**: AttachmentsCz.data (A.5.3 - Data of additional attachments)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.attachment.data
* **Source Code**: AttachmentsCz.url (A.5.4 - URL of additional attachments)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.attachment.url
* **Source Code**: AttachmentsCz.title (A.5.5 - Title of additional attachments)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.attachment.title
* **Source Code**: AttachmentsCz.creation (A.5.6 - Date and time of creation)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.attachment.creation



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "AttachmentEMS2FHIR-cz",
  "url" : "https://hl7.cz/fhir/cz-ems/ConceptMap/AttachmentEMS2FHIR-cz",
  "version" : "0.0.2",
  "name" : "AttachmentEMS2FHIRcz",
  "title" : "CZ Attachment Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ Emergency Medical Service Report Attachment Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/AttachmentsCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-attachment",
      "element" : [
        {
          "code" : "AttachmentsCz",
          "display" : "A.2.11.1 - Attachments EMS",
          "target" : [
            {
              "code" : "CZ_Attachment",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "AttachmentsCz.type",
          "display" : "A.2.11.1.1 - Attachment type",
          "target" : [
            {
              "code" : "content.type",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AttachmentsCz.format",
          "display" : "A.2.11.1.2 - Attachment format",
          "target" : [
            {
              "code" : "content.attachment.contentType",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AttachmentsCz.name",
          "display" : "A.2.11.1.3 - Attachment name",
          "target" : [
            {
              "code" : "content.attachment.title",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AttachmentsCz.description",
          "display" : "A.2.11.1.4 - Attachment description",
          "target" : [
            {
              "code" : "content.description",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AttachmentsCz.dateAndTimeOfAttachment",
          "display" : "A.2.11.1.5 - Attachment date and time",
          "target" : [
            {
              "code" : "content.attachment.creation",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AttachmentsCz.document",
          "display" : "A.2.11.1.6 - Document",
          "target" : [
            {
              "code" : "content.attachment.data",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/PresentedFormCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-composition-ems",
      "element" : [
        {
          "code" : "PresentedForm",
          "display" : "A.4 - Presented Form",
          "target" : [
            {
              "code" : "Composition.extension:relatedArtifact.document",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PresentedForm.contentType",
          "display" : "A.4.1 - Content type of presented form",
          "target" : [
            {
              "code" : "document.contentType",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PresentedForm.language",
          "display" : "A.4.2 - Language of presented form",
          "target" : [
            {
              "code" : "document.language",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PresentedForm.data",
          "display" : "A.4.3 - Data of presented form",
          "target" : [
            {
              "code" : "document.data",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PresentedForm.url",
          "display" : "A.4.4 - URL of presented form",
          "target" : [
            {
              "code" : "document.url",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PresentedForm.title",
          "display" : "A.4.5 - Title of presented form",
          "target" : [
            {
              "code" : "document.title",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PresentedForm.creation",
          "display" : "A.4.6 - Date and time of creation",
          "target" : [
            {
              "code" : "document.creation",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/AttachmentsCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-attachment",
      "element" : [
        {
          "code" : "AttachmentsCz",
          "display" : "A.5 - Additional attachments",
          "target" : [
            {
              "code" : "CZ_Attachment.content",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AttachmentsCz.contentType",
          "display" : "A.5.1 - Content type of additional attachments",
          "target" : [
            {
              "code" : "content.attachment.contentType",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AttachmentsCz.language",
          "display" : "A.5.2 - Language of additional attachments",
          "target" : [
            {
              "code" : "content.attachment.language",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AttachmentsCz.data",
          "display" : "A.5.3 - Data of additional attachments",
          "target" : [
            {
              "code" : "content.attachment.data",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AttachmentsCz.url",
          "display" : "A.5.4 - URL of additional attachments",
          "target" : [
            {
              "code" : "content.attachment.url",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AttachmentsCz.title",
          "display" : "A.5.5 - Title of additional attachments",
          "target" : [
            {
              "code" : "content.attachment.title",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AttachmentsCz.creation",
          "display" : "A.5.6 - Date and time of creation",
          "target" : [
            {
              "code" : "content.attachment.creation",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
