# CZ Alerts Model to this guide Map - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Alerts Model to this guide Map**

## ConceptMap: CZ Alerts Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/ConceptMap/Alerts2FHIR-cz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:Alerts2FHIRcz |

 
CZ Emergency Medical Service Report Alerts Model to this guide mapping 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.2.4 - Alerts (en)](StructureDefinition-AlertsCz.md) to [Allergy Intolerance: (EMS CZ)](StructureDefinition-cz-allergyIntolerance-ems.md)

* **Source Code**: Alerts.allergy (A.2.4.1 - Allergy and Intolerance)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance
* **Source Code**: Alerts.allergy.description (A.2.4.1.1 - Allergy description)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance.text
* **Source Code**: Alerts.allergy.agent (A.2.4.1.2 - Agent or Allergen)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance.code
* **Source Code**: Alerts.allergy.typeOfPropensity (A.2.4.1.3 - Type of propensity)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance.type
* **Source Code**: Alerts.allergy.manifestation (A.2.4.1.4 - Allergy manifestation)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: AllergyIntolerance.reaction.manifestation
* **Source Code**: Alerts.allergy.criticality (A.2.4.1.5 - Criticality)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance.criticality
* **Source Code**: Alerts.allergy.onsetDate (A.2.4.1.6 - Onset date)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance.onset[x]
* **Source Code**: Alerts.allergy.endDate (A.2.4.1.7 - End date)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance.extension:abatement-datetime
* **Source Code**: Alerts.allergy.status (A.2.4.1.8 - Status)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance.clinicalStatus
* **Source Code**: Alerts.allergy.certainty (A.2.4.1.9 - Certainty)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance.verificationStatus
* **Source Code**: Alerts.allergy.lastOccurrence (A.2.4.1.10 - Last Occurence)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance.lastOccurrence

-------

**Group 2**Mapping from [A.2.4 - Alerts (en)](StructureDefinition-AlertsCz.md) to [Composition (EMS CZ)](StructureDefinition-cz-composition-ems.md)

* **Source Code**: Alerts.allergy (A.2.4.1 - Allergy and Intolerance)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionAllergies
* **Source Code**: Alerts.medicalAlerts (A.2.4.2 - Medical alerts (relevant for the respective hospital stay))
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionAlerts
* **Source Code**: Alerts.medicalAlerts.description (A.2.4.2.1 - Healthcare alert description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionAlerts.text

-------

**Group 3**Mapping from [A.2.4 - Alerts (en)](StructureDefinition-AlertsCz.md) to [Flag: (EMS CZ)](StructureDefinition-cz-flag-ems.md)

* **Source Code**: Alerts.medicalAlerts.description (A.2.4.2.1 - Healthcare alert description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Flag.text
  * **Comment**: TO BE checked
* **Source Code**: Alerts.medicalAlerts.description (A.2.4.2.1 - Healthcare alert description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Flag.code.text
  * **Comment**: TO BE checked
* **Source Code**: Alerts.medicalAlerts.code (A.2.4.2.3 - Healthcare alert code(s))
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Flag.code
  * **Comment**: TO BE checked (cardinality)
* **Source Code**: Alerts.medicalAlerts.specialistPhysician (A.2.4.2.4 - Healthcare alert specialist physician)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Flag.author
  * **Comment**: TO BE checked
* **Source Code**: Alerts.medicalAlerts.comment (A.2.4.2.5 - Healthcare alert comment)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Flag.text
  * **Comment**: TO BE checked
* **Source Code**: Alerts.medicalAlerts.priority (A.2.4.2.6 - Healthcare alert priority)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Flag.extension:flagPriorityExt
  * **Comment**: TO BE checked
* **Source Code**: Alerts.medicalAlerts.period (A.2.4.2.7 - Healthcare alert period)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Flag.period
  * **Comment**: TO BE checked



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "Alerts2FHIR-cz",
  "url" : "https://hl7.cz/fhir/cz-ems/ConceptMap/Alerts2FHIR-cz",
  "version" : "0.0.2",
  "name" : "Alerts2FHIRcz",
  "title" : "CZ Alerts Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ Emergency Medical Service Report Alerts Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/AlertsCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-allergyIntolerance-ems",
      "element" : [
        {
          "code" : "Alerts.allergy",
          "display" : "A.2.4.1 - Allergy and Intolerance",
          "target" : [
            {
              "code" : "AllergyIntolerance",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.description",
          "display" : "A.2.4.1.1 - Allergy description",
          "target" : [
            {
              "code" : "AllergyIntolerance.text",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.agent",
          "display" : "A.2.4.1.2 - Agent or Allergen",
          "target" : [
            {
              "code" : "AllergyIntolerance.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.typeOfPropensity",
          "display" : "A.2.4.1.3 - Type of propensity",
          "target" : [
            {
              "code" : "AllergyIntolerance.type",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.manifestation",
          "display" : "A.2.4.1.4 - Allergy manifestation",
          "target" : [
            {
              "code" : "AllergyIntolerance.reaction.manifestation",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.criticality",
          "display" : "A.2.4.1.5 - Criticality",
          "target" : [
            {
              "code" : "AllergyIntolerance.criticality",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.onsetDate",
          "display" : "A.2.4.1.6 - Onset date",
          "target" : [
            {
              "code" : "AllergyIntolerance.onset[x]",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.endDate",
          "display" : "A.2.4.1.7 - End date",
          "target" : [
            {
              "code" : "AllergyIntolerance.extension:abatement-datetime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.status",
          "display" : "A.2.4.1.8 - Status",
          "target" : [
            {
              "code" : "AllergyIntolerance.clinicalStatus",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.certainty",
          "display" : "A.2.4.1.9 - Certainty",
          "target" : [
            {
              "code" : "AllergyIntolerance.verificationStatus",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.lastOccurrence",
          "display" : "A.2.4.1.10 - Last Occurence",
          "target" : [
            {
              "code" : "AllergyIntolerance.lastOccurrence",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/AlertsCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-composition-ems",
      "element" : [
        {
          "code" : "Alerts.allergy",
          "display" : "A.2.4.1 - Allergy and Intolerance",
          "target" : [
            {
              "code" : "Composition.section:sectionAllergies",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Alerts.medicalAlerts",
          "display" : "A.2.4.2 - Medical alerts (relevant for the respective hospital stay)",
          "target" : [
            {
              "code" : "Composition.section:sectionAlerts",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Alerts.medicalAlerts.description",
          "display" : "A.2.4.2.1 - Healthcare alert description",
          "target" : [
            {
              "code" : "Composition.section:sectionAlerts.text",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/AlertsCz",
      "target" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-flag-ems",
      "element" : [
        {
          "code" : "Alerts.medicalAlerts.description",
          "display" : "A.2.4.2.1 - Healthcare alert description",
          "target" : [
            {
              "code" : "Flag.text",
              "equivalence" : "relatedto",
              "comment" : "TO BE checked"
            }
          ]
        },
        {
          "code" : "Alerts.medicalAlerts.description",
          "display" : "A.2.4.2.1 - Healthcare alert description",
          "target" : [
            {
              "code" : "Flag.code.text",
              "equivalence" : "relatedto",
              "comment" : "TO BE checked"
            }
          ]
        },
        {
          "code" : "Alerts.medicalAlerts.code",
          "display" : "A.2.4.2.3 - Healthcare alert code(s)",
          "target" : [
            {
              "code" : "Flag.code",
              "equivalence" : "relatedto",
              "comment" : "TO BE checked (cardinality)"
            }
          ]
        },
        {
          "code" : "Alerts.medicalAlerts.specialistPhysician",
          "display" : "A.2.4.2.4 - Healthcare alert specialist physician",
          "target" : [
            {
              "code" : "Flag.author",
              "equivalence" : "relatedto",
              "comment" : "TO BE checked"
            }
          ]
        },
        {
          "code" : "Alerts.medicalAlerts.comment",
          "display" : "A.2.4.2.5 - Healthcare alert comment",
          "target" : [
            {
              "code" : "Flag.text",
              "equivalence" : "relatedto",
              "comment" : "TO BE checked"
            }
          ]
        },
        {
          "code" : "Alerts.medicalAlerts.priority",
          "display" : "A.2.4.2.6 - Healthcare alert priority",
          "target" : [
            {
              "code" : "Flag.extension:flagPriorityExt",
              "equivalence" : "relatedto",
              "comment" : "TO BE checked"
            }
          ]
        },
        {
          "code" : "Alerts.medicalAlerts.period",
          "display" : "A.2.4.2.7 - Healthcare alert period",
          "target" : [
            {
              "code" : "Flag.period",
              "equivalence" : "relatedto",
              "comment" : "TO BE checked"
            }
          ]
        }
      ]
    }
  ]
}

```
