# Logical models - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* **Logical models**

## Logical models

This page lists the HL7 FHIR logical models used to represent Emergency medical service report.

| | | |
| :--- | :--- | :--- |
| Name | Title | Description |
| [LogEnEmsReportCz](StructureDefinition-EmsReportCz.md) | A - EMS Report (en) | EMS Report EN |
| [LogEnHeaderEmsCz](StructureDefinition-HeaderEmsCz.md) | A.1 - EMS report header data element (en) | EMS report - EMS report header data element - A.1 EN |
| [LogEnDispatchDataCz](StructureDefinition-DispatchDataCz.md) | A.2.1 - Dispatch Data (en) | EMS report – Dispatch Data – A.2.1 EN |
| [LogEnEndOfCare](StructureDefinition-LogEndOfCare.md) | A.2.10 - End of Care (en) | Emergency Medical Service Report – End of Care – A.2.10 EN |
| [LogEnAttachmentsEMSCz](StructureDefinition-AttachmentsEMSCz.md) | A.2.11 - Attachments EMS | Emergency medical service Record - Single attachment or collection of attachments |
| [LogEnDispatchTimelineCz](StructureDefinition-DispatchTimelineCz.md) | A.2.2 - Dispatch Timeline (en) | EMS record – Dispatch Timeline – A.2.2 EN |
| [LogEnPatientHistoryCz](StructureDefinition-PatientHistoryCz.md) | A.2.3 - Patient history (en) | EMS Report - Patient history - A.2.3 EN |
| [LogEnAlertsCz](StructureDefinition-AlertsCz.md) | A.2.4 - Alerts (en) | EMS Report - Alerts - A.2.4 EN |
| [LogEnPresentingIllnessEmsCz](StructureDefinition-PresentingIllnessEmsCz.md) | A.2.5 - Presenting Illness | Emergency medical service report - Presenting Illness |
| [LogEnObjectiveFindingsEmsCz](StructureDefinition-ObjectiveFindingsEmsCz.md) | A.2.6 - Objective findings | Emergency medical service report - Objective Findings |
| [LogEnTherapyEmsCz](StructureDefinition-TherapyEmsCz.md) | A.2.7 - Therapy | Emergency medical service report - Therapy |
| [LogEnDiagnosticSummary](StructureDefinition-LogDiagnosticSummary.md) | A.2.8 - Diagnostic Summary (en) | Emergency Medical Service Report – Diagnostic Summary – A.2.8 EN |
| [LogEnRecommendations](StructureDefinition-LogRecommendations.md) | A.2.9 - Course of Treatment and Recommendations (en) | Emergency Medical Service Report – Course of Treatment and Recommendations – A.2.9 EN |
| [LogEnPresentedFormCz](StructureDefinition-PresentedFormCz.md) | A.3 - Presented form | Presented form - Entire report as issued. Various formats could be provided, pdf format is recommended. |
| [LogEnAttachmentsCz](StructureDefinition-AttachmentsCz.md) | A.4 - Additional attachments | EMS report - additional attachments |

