# Home - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/ImplementationGuide/hl7.fhir.cz.ems | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:HL7CzEMSImplementationGuide |

### Introduction

This implementation specification is based on the [FHIR version R4](https://hl7.org/fhir/R4/), and defines a unified framework for representing the Emergency Medical Service (EMS) Record of Intervention (ZOV ZZS) in the Czech national context. The specification defines the content and structural components of the document and ensures their compliance with the legal requirements of the Czech Republic as well as with European initiatives in the field of electronic health record interoperability.

The main objective is to create a standardized form of the EMS Record of Intervention as part of the patient’s medical documentation, which will be used for the electronic exchange of health information between healthcare providers, the patient, and the national infrastructure. The specification covers both national scenarios and potential future cross-border exchange within the European Health Data Space (EHDS).

This document focuses exclusively on defining the content, structure, and data model of the EMS Record of Intervention. The technical aspects of document transmission and the procedural workflows of EMS crews are not within its scope and are addressed in related standards and methodological guidelines.

### Scope

This guide is divided into several pages, which are listed in the menu bar at the top of each page.

* [Home](index.md): This page provides introductory information, a brief scope of use, references, dependencies, version difference analysis, and intellectual property statements.
* Introduction: 
* [Scope and Content](scope-and-content.md): This section contains introductory general information about the EMS Record of Intervention.
* Background: This section provides general information on the origins of the definition of the EMS Record of Intervention.
 
* Functional: 
* Use Cases: This section contains information about use cases.
* Workflow: This section contains information about the workflow.
* Logical Models: This section contains information about logical models.
* Terminology Aspects: This section contains information about terminology.
 
* Implementation: 
* Logical Model Mapping: This section contains information on mapping the logical model to the EMS Record of Intervention profiles.
* Examples: This section contains examples.
* Obligations: This section outlines the obligations.
* Implementation Notes: This section contains implementation guidance.
 
* About: 
* [Authors](authors.md): This section contains information about the authors.
* [Downloads](downloads.md): This section provides information about available downloads of the implementation specification.
* [Dependencies](dependencies.md): This section provides information about dependencies.
* [Copyright](copyright.md): This section provides information about copyright.
 
* [Artifacts](artifacts.md): This page provides a list of FHIR artifacts defined as part of this implementation guide.

### References

* Related specifications: 
* [EHDS Logical Information Models](http://build.fhir.org/ig/Xt-EHR/xt-ehr-common/index.html) 
* This specification has inspired many of the design patterns defined in this IG.
 
* [HL7 Czech Base and Core Implementation Guide](http://build.fhir.org/ig/HL7-cz/cz-core/index.html) 
* Where possible this specification has been aligned with choices made in CZ core.
 
 

### Dependencies






















### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.cz.ems.r4)](package.r4.tgz) and [R4B (hl7.fhir.cz.ems.r4b)](package.r4b.tgz) are available.

### IP statements

This publication includes IP covered under the following statements.

* Copyright HL7. Licensed under creative commons public domain

* [providerRole](http://terminology.hl7.org/5.3.0/CodeSystem-v2-0443.html): [CZImmunizationEMS](StructureDefinition-cz-immunization-ems.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [A.2.1 ClinicalCourseAndRecommendations2FHIRcz](ConceptMap-ClinicalCourseAndRecommendationsEMS2FHIR-cz.md), [A.2.1 DispatchDataEMS2FHIRcz](ConceptMap-DispatchDataEMS2FHIR-cz.md)...Show 73 more,[A.2.2 DispatchTimeline2FHIRcz](ConceptMap-DispatchTimeline2FHIR-cz.md),[A.2.6 ObjectiveFindingsEMS2FHIR2FHIRcz](ConceptMap-ObjectiveFindingsEMS2FHIR-cz.md),[Alerts2FHIRcz](ConceptMap-Alerts2FHIR-cz.md),[AttachmentEMS2FHIRcz](ConceptMap-AttachmentEMS2FHIR-cz.md),[Bundle/cz-example-bundle](Bundle-cz-example-bundle.md),[CZEncounterEMS](StructureDefinition-cz-encounter-ems.md),[CZImmunizationEMS](StructureDefinition-cz-immunization-ems.md),[CZ_AllergyIntoleranceEms](StructureDefinition-cz-allergyIntolerance-ems.md),[CZ_BundleEms](StructureDefinition-cz-bundle-ems.md),[CZ_CareTeamEms](StructureDefinition-cz-careteam-ems.md),[CZ_CommunicationEms](StructureDefinition-cz-communication-ems.md),[CZ_CompositionEms](StructureDefinition-cz-composition-ems.md),[CZ_ConditionEms](StructureDefinition-cz-condition-ems.md),[CZ_FlagEms](StructureDefinition-cz-flag-ems.md),[CZ_ImmunizationRecommendationEMS](StructureDefinition-cz-immunizationRecommendation-ems.md),[CZ_LocationEms](StructureDefinition-cz-location-ems.md),[CZ_MedicationAdministration](StructureDefinition-cz-MedicationAdministration.md),[CZ_ObservationBMIEms](StructureDefinition-cz-observation-BMI-ems.md),[CZ_ObservationHeightEms](StructureDefinition-cz-observation-height-ems.md),[CZ_ObservationHeightTypeEmsVs](ValueSet-cz-observationHeightType-ems-vs.md),[CZ_ObservationInfectiousContactEMS](StructureDefinition-cz-observation-infectious-contact-ems.md),[CZ_ObservationOFTypeEmsVs](ValueSet-cz-observationOFType-ems-vs.md),[CZ_ObservationOtherOFEms](StructureDefinition-cz-observation-OtherOF-ems.md),[CZ_ObservationOxygenEms](StructureDefinition-cz-observation-oxygen-ems.md),[CZ_ObservationSDOHEMS](StructureDefinition-cz-observation-sdoh-ems.md),[CZ_ObservationUnitsHeightEmsVs](ValueSet-cz-observationUnitsHeight-ems-vs.md),[CZ_ObservationUnitsWeightEmsVs](ValueSet-cz-observationUnitsWeight-ems-vs.md),[CZ_ObservationVSTypeEmsVs](ValueSet-cz-observationVSType-ems-vs.md),[CZ_ObservationVitalSignsEms](StructureDefinition-cz-observation-vitalSigns-ems.md),[CZ_ObservationWeightEms](StructureDefinition-cz-observation-weight-ems.md),[CZ_ObservationWeightTypeEmsVs](ValueSet-cz-observationWeightType-ems-vs.md),[CZ_ProcedureEms](StructureDefinition-cz-procedure-ems.md),[CZ_TaskEms](StructureDefinition-cz-task-ems.md),[CZ_VehicleLocationEms](StructureDefinition-cz-vehicle-location-ems.md),[ConditionEmsVS](ValueSet-condition-cz-ems.md),[CzEmsUrgencyLevel](StructureDefinition-ext-cz-ems-urgency-level.md),[DiagnosticSummary2FHIRCzEms](ConceptMap-diagnosticSummary2FHIR-cz-ems.md),[Fakultní nemocnice Motol](Organization-821077d6-ce17-4602-b3ad-d4bef845a950.md),[HL7CzEMSImplementationGuide](index.md),[LogCzAlertsCz](StructureDefinition-LogAlertsCz.md),[LogCzAttachmentsCz](StructureDefinition-LogAttachmentsCz.md),[LogCzAttachmentsEmsCz](StructureDefinition-LogAttachmentsEmsCz.md),[LogCzDiagnosticSummaryCz](StructureDefinition-LogDiagnostickySouhrnCz.md),[LogCzDispatchDataCz](StructureDefinition-LogDispatchDataCz.md),[LogCzDispatchTimelineCz](StructureDefinition-LogDispatchTimelineCz.md),[LogCzEmsReportCz](StructureDefinition-LogEmsReportCz.md),[LogCzEndOfCareCz](StructureDefinition-LogEndOfCareCz.md),[LogCzHeaderEmsCz](StructureDefinition-LogHeaderEmsCz.md),[LogCzObjectiveFindingsEmsCz](StructureDefinition-LogObjectiveFindingsEmsCz.md),[LogCzPatientHistoryCz](StructureDefinition-LogPatientHistoryCz.md),[LogCzPresentedFormCz](StructureDefinition-LogPresentedFormCz.md),[LogCzPresentingIllnessEmsCz](StructureDefinition-LogPresentingIllnessEmsCz.md),[LogCzRecommendationsCz](StructureDefinition-LogRecommendationsCz.md),[LogCzTherapyEmsCz](StructureDefinition-LogTherapyEmsCz.md),[LogEnAlertsCz](StructureDefinition-AlertsCz.md),[LogEnAttachmentsCz](StructureDefinition-AttachmentsCz.md),[LogEnAttachmentsEMSCz](StructureDefinition-AttachmentsEMSCz.md),[LogEnDiagnosticSummary](StructureDefinition-LogDiagnosticSummary.md),[LogEnDispatchDataCz](StructureDefinition-DispatchDataCz.md),[LogEnDispatchTimelineCz](StructureDefinition-DispatchTimelineCz.md),[LogEnEmsReportCz](StructureDefinition-EmsReportCz.md),[LogEnEndOfCare](StructureDefinition-LogEndOfCare.md),[LogEnHeaderEmsCz](StructureDefinition-HeaderEmsCz.md),[LogEnObjectiveFindingsEmsCz](StructureDefinition-ObjectiveFindingsEmsCz.md),[LogEnPatientHistoryCz](StructureDefinition-PatientHistoryCz.md),[LogEnPresentedFormCz](StructureDefinition-PresentedFormCz.md),[LogEnPresentingIllnessEmsCz](StructureDefinition-PresentingIllnessEmsCz.md),[LogEnRecommendations](StructureDefinition-LogRecommendations.md),[LogEnTherapyEmsCz](StructureDefinition-TherapyEmsCz.md),[Patient/3b46c18c-7e07-4232-af3e-f710dec8e766](Patient-3b46c18c-7e07-4232-af3e-f710dec8e766.md),[PatientHistory2FHIRCzEms](ConceptMap-patientHistory2FHIR-cz.md),[PresentingIllness2FHIRcz](ConceptMap-PresentingIllness2FHIR-cz.md)and[Therapy2FHIRcz](ConceptMap-Therapy2FHIR-cz.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [CZ_ObservationHeightEms](StructureDefinition-cz-observation-height-ems.md), [CZ_ObservationUnitsHeightEmsVs](ValueSet-cz-observationUnitsHeight-ems-vs.md)...Show 5 more,[CZ_ObservationUnitsWeightEmsVs](ValueSet-cz-observationUnitsWeight-ems-vs.md),[CZ_ObservationWeightEms](StructureDefinition-cz-observation-weight-ems.md),[Observation/ExampleBMIEms](Observation-ExampleBMIEms.md),[Observation/ExampleBodyHeightEms](Observation-ExampleBodyHeightEms.md)and[Observation/ExampleBodyWeightEms](Observation-ExampleBodyWeightEms.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/cz-example-bundle](Bundle-cz-example-bundle.md), [CZ_CompositionEms](StructureDefinition-cz-composition-ems.md), [CZ_ImmunizationRecommendationEMS](StructureDefinition-cz-immunizationRecommendation-ems.md) and [Composition/da3f987f-2a08-431a-92e3-129d7689e465](Composition-da3f987f-2a08-431a-92e3-129d7689e465.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [CZ_ConditionEms](StructureDefinition-cz-condition-ems.md), [CZ_ObservationBMIEms](StructureDefinition-cz-observation-BMI-ems.md)...Show 14 more,[CZ_ObservationHeightEms](StructureDefinition-cz-observation-height-ems.md),[CZ_ObservationHeightTypeEmsVs](ValueSet-cz-observationHeightType-ems-vs.md),[CZ_ObservationOFTypeEmsVs](ValueSet-cz-observationOFType-ems-vs.md),[CZ_ObservationOtherOFEms](StructureDefinition-cz-observation-OtherOF-ems.md),[CZ_ObservationOxygenEms](StructureDefinition-cz-observation-oxygen-ems.md),[CZ_ObservationVSTypeEmsVs](ValueSet-cz-observationVSType-ems-vs.md),[CZ_ObservationVitalSignsEms](StructureDefinition-cz-observation-vitalSigns-ems.md),[CZ_ObservationWeightEms](StructureDefinition-cz-observation-weight-ems.md),[CZ_ObservationWeightTypeEmsVs](ValueSet-cz-observationWeightType-ems-vs.md),[CZ_ProcedureEms](StructureDefinition-cz-procedure-ems.md),[ConditionEmsVS](ValueSet-condition-cz-ems.md),[Observation/ExampleBMIEms](Observation-ExampleBMIEms.md),[Observation/ExampleBodyHeightEms](Observation-ExampleBodyHeightEms.md)and[Observation/ExampleBodyWeightEms](Observation-ExampleBodyWeightEms.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Condition Clinical Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-condition-clinical.html): [CZ_ConditionEms](StructureDefinition-cz-condition-ems.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/6.5.0/CodeSystem-condition-ver-status.html): [CZ_ConditionEms](StructureDefinition-cz-condition-ems.md)
* [Location type](http://terminology.hl7.org/6.5.0/CodeSystem-location-physical-type.html): [CZ_VehicleLocationEms](StructureDefinition-cz-vehicle-location-ems.md)
* [Observation Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-observation-category.html): [CZ_ObservationSDOHEMS](StructureDefinition-cz-observation-sdoh-ems.md), [CZ_ObservationVitalSignsEms](StructureDefinition-cz-observation-vitalSigns-ems.md), [Observation/ExampleBMIEms](Observation-ExampleBMIEms.md), [Observation/ExampleBodyHeightEms](Observation-ExampleBodyHeightEms.md) and [Observation/ExampleBodyWeightEms](Observation-ExampleBodyWeightEms.md)
* [ActCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html): [Bundle/cz-example-bundle](Bundle-cz-example-bundle.md) and [Encounter/cd343afa-039d-4576-b5e4-e89598aeb628](Encounter-cd343afa-039d-4576-b5e4-e89598aeb628.md)
* [ParticipationType](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationType.html): [CZ_ObservationInfectiousContactEMS](StructureDefinition-cz-observation-infectious-contact-ems.md)




## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.cz.ems",
  "url" : "https://hl7.cz/fhir/cz-ems/ImplementationGuide/hl7.fhir.cz.ems",
  "version" : "0.0.2",
  "name" : "HL7CzEMSImplementationGuide",
  "title" : "HL7 Czech EMS Implementation Guide",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "HL7 Czech EMS Implementation Guide",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "packageId" : "hl7.fhir.cz.ems",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "6.5.0"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "hl7_fhir_uv_ips",
      "uri" : "http://hl7.org/fhir/uv/ips/ImplementationGuide/hl7.fhir.uv.ips",
      "packageId" : "hl7.fhir.uv.ips",
      "version" : "1.1.0"
    },
    {
      "id" : "hl7_fhir_cz_core",
      "uri" : "https://fhir.hl7cr.eu/core/ImplementationGuide/hl7.fhir.cz.core",
      "packageId" : "hl7.fhir.cz.core",
      "version" : "current"
    },
    {
      "id" : "hl7_fhir_cz_hdr",
      "uri" : "https://hl7.cz/fhir/hdr/ImplementationGuide/hl7.fhir.cz.hdr",
      "packageId" : "hl7.fhir.cz.hdr",
      "version" : "current"
    },
    {
      "id" : "hl7_fhir_eu_base",
      "uri" : "http://hl7.eu/fhir/base/ImplementationGuide/hl7.fhir.eu.base",
      "packageId" : "hl7.fhir.eu.base",
      "version" : "0.1.0-ballot"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://hl7.cz/fhir/cz-ems/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://hl7.cz/fhir/cz-ems/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "grouping" : [
      {
        "id" : "czech-logical-model",
        "name" : "Czech logical model (Informative)",
        "description" : "Logical model in czech language. Informative for this version of the guide."
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/EmsReportCz"
        },
        "name" : "A - EMS Report (en)",
        "description" : "EMS Report EN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogEmsReportCz"
        },
        "name" : "A - Zpráva o výjezdu (cz)",
        "description" : "Zpráva o výjezdu CZ",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HeaderEmsCz"
        },
        "name" : "A.1 - EMS report header data element (en)",
        "description" : "EMS report - EMS report header data element - A.1 EN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogHeaderEmsCz"
        },
        "name" : "A.1 – Hlavička dokumentu (cz)",
        "description" : "Zpráva o výjezdu - Struktura hlavičky zprávy o výjezdu podle tabulky části. CZ",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DispatchDataCz"
        },
        "name" : "A.2.1 - Dispatch Data (en)",
        "description" : "EMS report – Dispatch Data – A.2.1 EN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogDispatchDataCz"
        },
        "name" : "A.2.1 - Údaje o výjezdu (cz)",
        "description" : "Záznam o výjezdu - Údaje o výjezdu - A.2.1 CZ",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogEndOfCare"
        },
        "name" : "A.2.10 - End of Care (en)",
        "description" : "Emergency Medical Service Report – End of Care – A.2.10 EN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogEndOfCareCz"
        },
        "name" : "A.2.10 - Ukončení (cz)",
        "description" : "Zpráva o výjezdu ZZS – Ukončení – A.2.10 CZ",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AttachmentsEMSCz"
        },
        "name" : "A.2.11 - Attachments EMS",
        "description" : "Emergency medical service Record - Single attachment or collection of attachments",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogAttachmentsEmsCz"
        },
        "name" : "A.2.11 - Přílohy",
        "description" : "Záznam o výjezdu - Jedna příloha nebo kolekce příloh",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DispatchTimelineCz"
        },
        "name" : "A.2.2 - Dispatch Timeline (en)",
        "description" : "EMS record – Dispatch Timeline – A.2.2 EN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogDispatchTimelineCz"
        },
        "name" : "A.2.2 - Časová osa výjezdu (cz)",
        "description" : "Záznam o výjezdu - Časová osa výjezdu - A.2.2 CZ",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogPatientHistoryCz"
        },
        "name" : "A.2.3 - Anamnéza (cz)",
        "description" : "Zpráva o výjezdu - Anamnéza CZ",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PatientHistoryCz"
        },
        "name" : "A.2.3 - Patient history (en)",
        "description" : "EMS Report - Patient history - A.2.3 EN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AlertsCz"
        },
        "name" : "A.2.4 - Alerts (en)",
        "description" : "EMS Report - Alerts - A.2.4 EN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogAlertsCz"
        },
        "name" : "A.2.4 - Urgentní informace (cz)",
        "description" : "Zpráva o výjezdu - Urgentní informace CZ",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogPresentingIllnessEmsCz"
        },
        "name" : "A.2.5 - Nynější onemocnění",
        "description" : "Zpráva o výjezdu ZZS - Nynější onemocnění.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PresentingIllnessEmsCz"
        },
        "name" : "A.2.5 - Presenting Illness",
        "description" : "Emergency medical service report - Presenting Illness",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ObjectiveFindingsEmsCz"
        },
        "name" : "A.2.6 - Objective findings",
        "description" : "Emergency medical service report - Objective Findings",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogObjectiveFindingsEmsCz"
        },
        "name" : "A.2.6 - Objektivní nález",
        "description" : "Zpráva o výjezdu ZZS - Objektivní nález.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogTherapyEmsCz"
        },
        "name" : "A.2.7 - Terapie",
        "description" : "Zpráva o výjezdu ZZS - Terapie.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TherapyEmsCz"
        },
        "name" : "A.2.7 - Therapy",
        "description" : "Emergency medical service report - Therapy",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogDiagnosticSummary"
        },
        "name" : "A.2.8 - Diagnostic Summary (en)",
        "description" : "Emergency Medical Service Report – Diagnostic Summary – A.2.8 EN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogDiagnostickySouhrnCz"
        },
        "name" : "A.2.8 - Diagnostický souhrn (cz)",
        "description" : "Zpráva o výjezdu ZZS – Diagnostický souhrn – A.2.8 CZ",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogRecommendations"
        },
        "name" : "A.2.9 - Course of Treatment and Recommendations (en)",
        "description" : "Emergency Medical Service Report – Course of Treatment and Recommendations – A.2.9 EN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogRecommendationsCz"
        },
        "name" : "A.2.9 - Průběh ošetření a doporučení (cz)",
        "description" : "Zpráva o výjezdu ZZS – Průběh ošetření a doporučení – A.2.9 CZ",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PresentedFormCz"
        },
        "name" : "A.3 - Presented form",
        "description" : "Presented form - Entire report as issued. Various formats could be provided, pdf format is recommended.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogPresentedFormCz"
        },
        "name" : "A.3 - Vizuální podoba dokumentu",
        "description" : "Záznam o výjezdu - Záznamu o výjezdu ZZS (ZOV ZZS) čitelná lidským okem, je požadován PDF formát.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AttachmentsCz"
        },
        "name" : "A.4 - Additional attachments",
        "description" : "EMS report - additional attachments",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogAttachmentsCz"
        },
        "name" : "A.4 - Přílohy",
        "description" : "Záznam o výjezdu - Přílohy",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-allergyIntolerance-ems"
        },
        "name" : "Allergy Intolerance: (EMS CZ)",
        "description" : "This profile constrains the AllergyIntolerance resource for the purpose of the EMS project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ExampleBMIEms"
        },
        "name" : "BMI of patient",
        "description" : "Example instance for BMI observation using the CZ_ObservationBMIEms profile.",
        "exampleCanonical" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-BMI-ems"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ExampleBodyHeightEms"
        },
        "name" : "Body height of patient",
        "description" : "Example of body height of Patient Mracena",
        "exampleCanonical" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-height-ems"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ExampleBodyWeightEms"
        },
        "name" : "Body weight of patient",
        "description" : "Example of body weight of Patient Mracena",
        "exampleCanonical" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-weight-ems"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/cz-example-bundle"
        },
        "name" : "Bundle: EMS report",
        "description" : "Example of EMS report (Bundle)",
        "exampleCanonical" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-bundle-ems"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-bundle-ems"
        },
        "name" : "Bundle: EMS Report (CZ)",
        "description" : "Clinical document used to represent a EMS Report for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-careteam-ems"
        },
        "name" : "CareTeam: (EMS CZ)",
        "description" : "Profile of the emergency medical service team within Czech EMS.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-communication-ems"
        },
        "name" : "Communication: (EMS CZ)",
        "description" : "CZ Emergency Medical Service Communication Resource",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-composition-ems"
        },
        "name" : "Composition (EMS CZ)",
        "description" : "This profile defines how to represent Composition resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-condition-ems"
        },
        "name" : "Condition (EMS CZ)",
        "description" : "This profile represents the constraint applied to the Condition in the scope of this guide. It supports the Diagnostic summary part of the data model.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/condition-cz-ems"
        },
        "name" : "Condition Value Set",
        "description" : "Condition value set includes selected codes from recommended EU code systems for health conditions (WHO-ICD-10, SNOMED CT and Orphacodes).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/Alerts2FHIR-cz"
        },
        "name" : "CZ Alerts Model to this guide Map",
        "description" : "CZ Emergency Medical Service Report Alerts Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/AttachmentEMS2FHIR-cz"
        },
        "name" : "CZ Attachment Model to this guide Map",
        "description" : "CZ Emergency Medical Service Report Attachment Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/ClinicalCourseAndRecommendationsEMS2FHIR-cz"
        },
        "name" : "CZ ClinicalCourseAndRecommendations Model to this guide Map",
        "description" : "CZ Emergency Medical Service Report ClinicalCourseAndRecommendations Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/DispatchDataEMS2FHIR-cz"
        },
        "name" : "CZ DispatchData Model to this guide Map",
        "description" : "CZ Emergency Medical Service Report DispatchData Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/DispatchTimeline2FHIR-cz"
        },
        "name" : "CZ DispatchTimeline Model to this guide Map",
        "description" : "CZ Emergency Medical Service Report DispatchTimeline Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-immunization-ems"
        },
        "name" : "CZ Immunization EMS",
        "description" : "FHIR Immunization profile for use within Emergency Medical Services (EMS) in the Czech Republic.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/ObjectiveFindingsEMS2FHIR-cz"
        },
        "name" : "CZ Objective Findings Model to this guide Map",
        "description" : "CZ Emergency Medical Service Report ObjectiveFindings Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-sdoh-ems"
        },
        "name" : "CZ Observation SDOH: (EMS)",
        "description" : "Profile for Social Determinants of Health (SDOH) observations that involve assessment (e.g., by a provider, payer, etc.) as opposed to being derived only from screening surveys (as is the case for the SDOHCC Screening Response Observation).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/patientHistory2FHIR-cz"
        },
        "name" : "CZ Patient History to this guide Map",
        "description" : "CZ EMS Patient History Model to this guide Map",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/PresentingIllness2FHIR-cz"
        },
        "name" : "CZ Presenting Illness to this guide Map",
        "description" : "CZ EMS Report Presenting Illness Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/Therapy2FHIR-cz"
        },
        "name" : "CZ Therapy Model to this guide Map",
        "description" : "CZ EMS Report Therapy Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/cd343afa-039d-4576-b5e4-e89598aeb628"
        },
        "name" : "cz-encounter-example",
        "description" : "Encounter",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/040eb849-a513-4d74-b3f3-d2f246a26877"
        },
        "name" : "cz-logo2-example",
        "description" : "Example of logo as document reference for FN Motol.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/821077d6-ce17-4602-b3ad-d4bef845a950"
        },
        "name" : "cz-organizationwithlogo-example",
        "description" : "An example of the organization with logo extension",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/3af2e7a6-c16e-4b80-a173-ca2c8aa081b6"
        },
        "name" : "cz-procedure-example",
        "description" : "Procedure",
        "exampleCanonical" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-procedure-ems"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/diagnosticSummary2FHIR-cz-ems"
        },
        "name" : "EMS diagnostic summary Model to this guide Map",
        "description" : "CZ EMS Diagnostic summary Model to this guide Map",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Composition"
          }
        ],
        "reference" : {
          "reference" : "Composition/da3f987f-2a08-431a-92e3-129d7689e465"
        },
        "name" : "EMS Pacientky Mračeny Mrakomorové",
        "description" : "Example of EMS report (Composition)",
        "exampleCanonical" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-composition-ems"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-encounter-ems"
        },
        "name" : "Encounter EMS (CZ)",
        "description" : "This profile defines how to represent Encounter resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-flag-ems"
        },
        "name" : "Flag: (EMS CZ)",
        "description" : "This profile constrains the Flag resource for the purpose of the EMS project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-immunizationRecommendation-ems"
        },
        "name" : "Immunization Recommendation: (EMS CZ)",
        "description" : "This profile defines how to represent Immunization Recommandations for the purpose of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-infectious-contact-ems"
        },
        "name" : "Infectious Contact: (EMS CZ)",
        "description" : "Infectious Contact profile represents potential patient exposure to an agent (exposure source).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-vehicle-location-ems"
        },
        "name" : "Location - Vehicle: (EMS CZ)",
        "description" : "Location resource used to identify an emergency response vehicle or other means of transport of the Emergency Medical Service (EMS).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-location-ems"
        },
        "name" : "Location: (EMS CZ)",
        "description" : "Location profile for Emergency Medical Service",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-MedicationAdministration"
        },
        "name" : "Medication Administration: EMS Report (CZ)",
        "description" : "Czech national profile for a medication administration.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-BMI-ems"
        },
        "name" : "Observation: Anthropometric Data - BMI (EMS CZ)",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric data - BMI.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-height-ems"
        },
        "name" : "Observation: Anthropometric Data - Height (EMS CZ)",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric data - height.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-weight-ems"
        },
        "name" : "Observation: Anthropometric Data - Weight (EMS CZ)",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric data - weight.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-OtherOF-ems"
        },
        "name" : "Observation: Other Objective Findings (EMS CZ)",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch Objective Findings.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-oxygen-ems"
        },
        "name" : "Observation: Oxygen Therapy Observation (EMS CZ)",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch VitalSigns - Oxygen Therapy.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-vitalSigns-ems"
        },
        "name" : "Observation: Vital Signs (EMS CZ)",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch Vital signs.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-observationHeightType-ems-vs"
        },
        "name" : "ObservationsEmsHeightType",
        "description" : "This value set includes all Height types for observations of EMS report.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-observationOFType-ems-vs"
        },
        "name" : "ObservationsEmsOFType",
        "description" : "This value set includes other Objective findings observations of EMS report.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-observationVSType-ems-vs"
        },
        "name" : "ObservationsEmsVSType",
        "description" : "This value set includes other Vital Signs observations of EMS report.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-observationWeightType-ems-vs"
        },
        "name" : "ObservationsEmsWeightType",
        "description" : "This value set includes all Weight types for observations of EMS report.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-observationUnitsHeight-ems-vs"
        },
        "name" : "ObservationsUnitHeight",
        "description" : "UCUM units for height",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-observationUnitsWeight-ems-vs"
        },
        "name" : "ObservationsUnitWeight",
        "description" : "UCUM units for weight",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/3b46c18c-7e07-4232-af3e-f710dec8e766"
        },
        "name" : "Patient Mracena",
        "description" : "Patient Mracena with contact information and practitioner",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/2e877c76-633d-479b-a6d4-c6d95942de3f"
        },
        "name" : "Practitioner Blažejovský: EMS report",
        "description" : "Example of practitioner for EMS report.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/practitionerEms"
        },
        "name" : "practitionerEms",
        "description" : "Example of practitioner",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-procedure-ems"
        },
        "name" : "Procedure: EMS Report (CZ)",
        "description" : "This profile on Procedure represents the ems procedure for the scope of the Czech national interoperability project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-task-ems"
        },
        "name" : "Task: (EMS CZ)",
        "description" : "CZ Emergency Medical Service Task Resource",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-cz-ems-urgency-level"
        },
        "name" : "Urgency level (1–4)",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index-cs.html"
            }
          ],
          "nameUrl" : "index-cs.html",
          "title" : "Domovská stránka",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "scope-and-content.html"
            }
          ],
          "nameUrl" : "scope-and-content.html",
          "title" : "Scope and content",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "scope-and-content-cs.html"
            }
          ],
          "nameUrl" : "scope-and-content-cs.html",
          "title" : "Rozsah použití a obsah",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "background.html"
            }
          ],
          "nameUrl" : "background.html",
          "title" : "Background",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "background-cs.html"
            }
          ],
          "nameUrl" : "background-cs.html",
          "title" : "Background",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples.html"
            }
          ],
          "nameUrl" : "examples.html",
          "title" : "Examples",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples-cs.html"
            }
          ],
          "nameUrl" : "examples-cs.html",
          "title" : "Příklady",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "logical-models.html"
            }
          ],
          "nameUrl" : "logical-models.html",
          "title" : "Logical models",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "logical-models-cs.html"
            }
          ],
          "nameUrl" : "logical-models-cs.html",
          "title" : "Datová sada - logické modely",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "artifacts.html"
            }
          ],
          "nameUrl" : "artifacts.html",
          "title" : "Artifacts",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "authors.html"
            }
          ],
          "nameUrl" : "authors.html",
          "title" : "Authors",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "authors-cs.html"
            }
          ],
          "nameUrl" : "authors-cs.html",
          "title" : "Autoři",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "copyright.html"
            }
          ],
          "nameUrl" : "copyright.html",
          "title" : "Copyright",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "copyright-cs.html"
            }
          ],
          "nameUrl" : "copyright-cs.html",
          "title" : "Autorská práva",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dependencies.html"
            }
          ],
          "nameUrl" : "dependencies.html",
          "title" : "Dependencies",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dependencies-cs.html"
            }
          ],
          "nameUrl" : "dependencies-cs.html",
          "title" : "Závislosti",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Download",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads-cs.html"
            }
          ],
          "nameUrl" : "downloads-cs.html",
          "title" : "Download",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
