# Autorská práva - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* **Autorská práva**

## Autorská práva

### Prohlášení o duševním vlastnictví

This publication includes IP covered under the following statements.

* Copyright HL7. Licensed under creative commons public domain

* [providerRole](http://terminology.hl7.org/5.3.0/CodeSystem-v2-0443.html): [CZImmunizationEMS](StructureDefinition-cz-immunization-ems.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [A.2.1 ClinicalCourseAndRecommendations2FHIRcz](ConceptMap-ClinicalCourseAndRecommendationsEMS2FHIR-cz.md), [A.2.1 DispatchDataEMS2FHIRcz](ConceptMap-DispatchDataEMS2FHIR-cz.md)...Show 73 more,[A.2.2 DispatchTimeline2FHIRcz](ConceptMap-DispatchTimeline2FHIR-cz.md),[A.2.6 ObjectiveFindingsEMS2FHIR2FHIRcz](ConceptMap-ObjectiveFindingsEMS2FHIR-cz.md),[Alerts2FHIRcz](ConceptMap-Alerts2FHIR-cz.md),[AttachmentEMS2FHIRcz](ConceptMap-AttachmentEMS2FHIR-cz.md),[Bundle/cz-example-bundle](Bundle-cz-example-bundle.md),[CZEncounterEMS](StructureDefinition-cz-encounter-ems.md),[CZImmunizationEMS](StructureDefinition-cz-immunization-ems.md),[CZ_AllergyIntoleranceEms](StructureDefinition-cz-allergyIntolerance-ems.md),[CZ_BundleEms](StructureDefinition-cz-bundle-ems.md),[CZ_CareTeamEms](StructureDefinition-cz-careteam-ems.md),[CZ_CommunicationEms](StructureDefinition-cz-communication-ems.md),[CZ_CompositionEms](StructureDefinition-cz-composition-ems.md),[CZ_ConditionEms](StructureDefinition-cz-condition-ems.md),[CZ_FlagEms](StructureDefinition-cz-flag-ems.md),[CZ_ImmunizationRecommendationEMS](StructureDefinition-cz-immunizationRecommendation-ems.md),[CZ_LocationEms](StructureDefinition-cz-location-ems.md),[CZ_MedicationAdministration](StructureDefinition-cz-MedicationAdministration.md),[CZ_ObservationBMIEms](StructureDefinition-cz-observation-BMI-ems.md),[CZ_ObservationHeightEms](StructureDefinition-cz-observation-height-ems.md),[CZ_ObservationHeightTypeEmsVs](ValueSet-cz-observationHeightType-ems-vs.md),[CZ_ObservationInfectiousContactEMS](StructureDefinition-cz-observation-infectious-contact-ems.md),[CZ_ObservationOFTypeEmsVs](ValueSet-cz-observationOFType-ems-vs.md),[CZ_ObservationOtherOFEms](StructureDefinition-cz-observation-OtherOF-ems.md),[CZ_ObservationOxygenEms](StructureDefinition-cz-observation-oxygen-ems.md),[CZ_ObservationSDOHEMS](StructureDefinition-cz-observation-sdoh-ems.md),[CZ_ObservationUnitsHeightEmsVs](ValueSet-cz-observationUnitsHeight-ems-vs.md),[CZ_ObservationUnitsWeightEmsVs](ValueSet-cz-observationUnitsWeight-ems-vs.md),[CZ_ObservationVSTypeEmsVs](ValueSet-cz-observationVSType-ems-vs.md),[CZ_ObservationVitalSignsEms](StructureDefinition-cz-observation-vitalSigns-ems.md),[CZ_ObservationWeightEms](StructureDefinition-cz-observation-weight-ems.md),[CZ_ObservationWeightTypeEmsVs](ValueSet-cz-observationWeightType-ems-vs.md),[CZ_ProcedureEms](StructureDefinition-cz-procedure-ems.md),[CZ_TaskEms](StructureDefinition-cz-task-ems.md),[CZ_VehicleLocationEms](StructureDefinition-cz-vehicle-location-ems.md),[ConditionEmsVS](ValueSet-condition-cz-ems.md),[CzEmsUrgencyLevel](StructureDefinition-ext-cz-ems-urgency-level.md),[DiagnosticSummary2FHIRCzEms](ConceptMap-diagnosticSummary2FHIR-cz-ems.md),[Fakultní nemocnice Motol](Organization-821077d6-ce17-4602-b3ad-d4bef845a950.md),[HL7CzEMSImplementationGuide](index.md),[LogCzAlertsCz](StructureDefinition-LogAlertsCz.md),[LogCzAttachmentsCz](StructureDefinition-LogAttachmentsCz.md),[LogCzAttachmentsEmsCz](StructureDefinition-LogAttachmentsEmsCz.md),[LogCzDiagnosticSummaryCz](StructureDefinition-LogDiagnostickySouhrnCz.md),[LogCzDispatchDataCz](StructureDefinition-LogDispatchDataCz.md),[LogCzDispatchTimelineCz](StructureDefinition-LogDispatchTimelineCz.md),[LogCzEmsReportCz](StructureDefinition-LogEmsReportCz.md),[LogCzEndOfCareCz](StructureDefinition-LogEndOfCareCz.md),[LogCzHeaderEmsCz](StructureDefinition-LogHeaderEmsCz.md),[LogCzObjectiveFindingsEmsCz](StructureDefinition-LogObjectiveFindingsEmsCz.md),[LogCzPatientHistoryCz](StructureDefinition-LogPatientHistoryCz.md),[LogCzPresentedFormCz](StructureDefinition-LogPresentedFormCz.md),[LogCzPresentingIllnessEmsCz](StructureDefinition-LogPresentingIllnessEmsCz.md),[LogCzRecommendationsCz](StructureDefinition-LogRecommendationsCz.md),[LogCzTherapyEmsCz](StructureDefinition-LogTherapyEmsCz.md),[LogEnAlertsCz](StructureDefinition-AlertsCz.md),[LogEnAttachmentsCz](StructureDefinition-AttachmentsCz.md),[LogEnAttachmentsEMSCz](StructureDefinition-AttachmentsEMSCz.md),[LogEnDiagnosticSummary](StructureDefinition-LogDiagnosticSummary.md),[LogEnDispatchDataCz](StructureDefinition-DispatchDataCz.md),[LogEnDispatchTimelineCz](StructureDefinition-DispatchTimelineCz.md),[LogEnEmsReportCz](StructureDefinition-EmsReportCz.md),[LogEnEndOfCare](StructureDefinition-LogEndOfCare.md),[LogEnHeaderEmsCz](StructureDefinition-HeaderEmsCz.md),[LogEnObjectiveFindingsEmsCz](StructureDefinition-ObjectiveFindingsEmsCz.md),[LogEnPatientHistoryCz](StructureDefinition-PatientHistoryCz.md),[LogEnPresentedFormCz](StructureDefinition-PresentedFormCz.md),[LogEnPresentingIllnessEmsCz](StructureDefinition-PresentingIllnessEmsCz.md),[LogEnRecommendations](StructureDefinition-LogRecommendations.md),[LogEnTherapyEmsCz](StructureDefinition-TherapyEmsCz.md),[Patient/3b46c18c-7e07-4232-af3e-f710dec8e766](Patient-3b46c18c-7e07-4232-af3e-f710dec8e766.md),[PatientHistory2FHIRCzEms](ConceptMap-patientHistory2FHIR-cz.md),[PresentingIllness2FHIRcz](ConceptMap-PresentingIllness2FHIR-cz.md)and[Therapy2FHIRcz](ConceptMap-Therapy2FHIR-cz.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [CZ_ObservationHeightEms](StructureDefinition-cz-observation-height-ems.md), [CZ_ObservationUnitsHeightEmsVs](ValueSet-cz-observationUnitsHeight-ems-vs.md)...Show 5 more,[CZ_ObservationUnitsWeightEmsVs](ValueSet-cz-observationUnitsWeight-ems-vs.md),[CZ_ObservationWeightEms](StructureDefinition-cz-observation-weight-ems.md),[Observation/ExampleBMIEms](Observation-ExampleBMIEms.md),[Observation/ExampleBodyHeightEms](Observation-ExampleBodyHeightEms.md)and[Observation/ExampleBodyWeightEms](Observation-ExampleBodyWeightEms.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/cz-example-bundle](Bundle-cz-example-bundle.md), [CZ_CompositionEms](StructureDefinition-cz-composition-ems.md), [CZ_ImmunizationRecommendationEMS](StructureDefinition-cz-immunizationRecommendation-ems.md) and [Composition/da3f987f-2a08-431a-92e3-129d7689e465](Composition-da3f987f-2a08-431a-92e3-129d7689e465.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [CZ_ConditionEms](StructureDefinition-cz-condition-ems.md), [CZ_ObservationBMIEms](StructureDefinition-cz-observation-BMI-ems.md)...Show 14 more,[CZ_ObservationHeightEms](StructureDefinition-cz-observation-height-ems.md),[CZ_ObservationHeightTypeEmsVs](ValueSet-cz-observationHeightType-ems-vs.md),[CZ_ObservationOFTypeEmsVs](ValueSet-cz-observationOFType-ems-vs.md),[CZ_ObservationOtherOFEms](StructureDefinition-cz-observation-OtherOF-ems.md),[CZ_ObservationOxygenEms](StructureDefinition-cz-observation-oxygen-ems.md),[CZ_ObservationVSTypeEmsVs](ValueSet-cz-observationVSType-ems-vs.md),[CZ_ObservationVitalSignsEms](StructureDefinition-cz-observation-vitalSigns-ems.md),[CZ_ObservationWeightEms](StructureDefinition-cz-observation-weight-ems.md),[CZ_ObservationWeightTypeEmsVs](ValueSet-cz-observationWeightType-ems-vs.md),[CZ_ProcedureEms](StructureDefinition-cz-procedure-ems.md),[ConditionEmsVS](ValueSet-condition-cz-ems.md),[Observation/ExampleBMIEms](Observation-ExampleBMIEms.md),[Observation/ExampleBodyHeightEms](Observation-ExampleBodyHeightEms.md)and[Observation/ExampleBodyWeightEms](Observation-ExampleBodyWeightEms.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Condition Clinical Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-condition-clinical.html): [CZ_ConditionEms](StructureDefinition-cz-condition-ems.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/6.5.0/CodeSystem-condition-ver-status.html): [CZ_ConditionEms](StructureDefinition-cz-condition-ems.md)
* [Location type](http://terminology.hl7.org/6.5.0/CodeSystem-location-physical-type.html): [CZ_VehicleLocationEms](StructureDefinition-cz-vehicle-location-ems.md)
* [Observation Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-observation-category.html): [CZ_ObservationSDOHEMS](StructureDefinition-cz-observation-sdoh-ems.md), [CZ_ObservationVitalSignsEms](StructureDefinition-cz-observation-vitalSigns-ems.md), [Observation/ExampleBMIEms](Observation-ExampleBMIEms.md), [Observation/ExampleBodyHeightEms](Observation-ExampleBodyHeightEms.md) and [Observation/ExampleBodyWeightEms](Observation-ExampleBodyWeightEms.md)
* [ActCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html): [Bundle/cz-example-bundle](Bundle-cz-example-bundle.md) and [Encounter/cd343afa-039d-4576-b5e4-e89598aeb628](Encounter-cd343afa-039d-4576-b5e4-e89598aeb628.md)
* [ParticipationType](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationType.html): [CZ_ObservationInfectiousContactEMS](StructureDefinition-cz-observation-infectious-contact-ems.md)


