# Artifacts - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* **Artifacts**

## Artifacts

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Czech logical model (Informative) 

Logical model in czech language. Informative for this version of the guide.

| | |
| :--- | :--- |
| [A - Zpráva o výjezdu (cz)](StructureDefinition-LogEmsReportCz.md) | Zpráva o výjezdu CZ |
| [A.1 – Hlavička dokumentu (cz)](StructureDefinition-LogHeaderEmsCz.md) | Zpráva o výjezdu - Struktura hlavičky zprávy o výjezdu podle tabulky části. CZ |
| [A.2.1 - Údaje o výjezdu (cz)](StructureDefinition-LogDispatchDataCz.md) | Záznam o výjezdu - Údaje o výjezdu - A.2.1 CZ |
| [A.2.10 - Ukončení (cz)](StructureDefinition-LogEndOfCareCz.md) | Zpráva o výjezdu ZZS – Ukončení – A.2.10 CZ |
| [A.2.11 - Přílohy](StructureDefinition-LogAttachmentsEmsCz.md) | Záznam o výjezdu - Jedna příloha nebo kolekce příloh |
| [A.2.2 - Časová osa výjezdu (cz)](StructureDefinition-LogDispatchTimelineCz.md) | Záznam o výjezdu - Časová osa výjezdu - A.2.2 CZ |
| [A.2.3 - Anamnéza (cz)](StructureDefinition-LogPatientHistoryCz.md) | Zpráva o výjezdu - Anamnéza CZ |
| [A.2.4 - Urgentní informace (cz)](StructureDefinition-LogAlertsCz.md) | Zpráva o výjezdu - Urgentní informace CZ |
| [A.2.5 - Nynější onemocnění](StructureDefinition-LogPresentingIllnessEmsCz.md) | Zpráva o výjezdu ZZS - Nynější onemocnění. |
| [A.2.6 - Objektivní nález](StructureDefinition-LogObjectiveFindingsEmsCz.md) | Zpráva o výjezdu ZZS - Objektivní nález. |
| [A.2.7 - Terapie](StructureDefinition-LogTherapyEmsCz.md) | Zpráva o výjezdu ZZS - Terapie. |
| [A.2.8 - Diagnostický souhrn (cz)](StructureDefinition-LogDiagnostickySouhrnCz.md) | Zpráva o výjezdu ZZS – Diagnostický souhrn – A.2.8 CZ |
| [A.2.9 - Průběh ošetření a doporučení (cz)](StructureDefinition-LogRecommendationsCz.md) | Zpráva o výjezdu ZZS – Průběh ošetření a doporučení – A.2.9 CZ |
| [A.3 - Vizuální podoba dokumentu](StructureDefinition-LogPresentedFormCz.md) | Záznam o výjezdu - Záznamu o výjezdu ZZS (ZOV ZZS) čitelná lidským okem, je požadován PDF formát. |
| [A.4 - Přílohy](StructureDefinition-LogAttachmentsCz.md) | Záznam o výjezdu - Přílohy |

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [A - EMS Report (en)](StructureDefinition-EmsReportCz.md) | EMS Report EN |
| [A.1 - EMS report header data element (en)](StructureDefinition-HeaderEmsCz.md) | EMS report - EMS report header data element - A.1 EN |
| [A.2.1 - Dispatch Data (en)](StructureDefinition-DispatchDataCz.md) | EMS report – Dispatch Data – A.2.1 EN |
| [A.2.10 - End of Care (en)](StructureDefinition-LogEndOfCare.md) | Emergency Medical Service Report – End of Care – A.2.10 EN |
| [A.2.11 - Attachments EMS](StructureDefinition-AttachmentsEMSCz.md) | Emergency medical service Record - Single attachment or collection of attachments |
| [A.2.2 - Dispatch Timeline (en)](StructureDefinition-DispatchTimelineCz.md) | EMS record – Dispatch Timeline – A.2.2 EN |
| [A.2.3 - Patient history (en)](StructureDefinition-PatientHistoryCz.md) | EMS Report - Patient history - A.2.3 EN |
| [A.2.4 - Alerts (en)](StructureDefinition-AlertsCz.md) | EMS Report - Alerts - A.2.4 EN |
| [A.2.5 - Presenting Illness](StructureDefinition-PresentingIllnessEmsCz.md) | Emergency medical service report - Presenting Illness |
| [A.2.6 - Objective findings](StructureDefinition-ObjectiveFindingsEmsCz.md) | Emergency medical service report - Objective Findings |
| [A.2.7 - Therapy](StructureDefinition-TherapyEmsCz.md) | Emergency medical service report - Therapy |
| [A.2.8 - Diagnostic Summary (en)](StructureDefinition-LogDiagnosticSummary.md) | Emergency Medical Service Report – Diagnostic Summary – A.2.8 EN |
| [A.2.9 - Course of Treatment and Recommendations (en)](StructureDefinition-LogRecommendations.md) | Emergency Medical Service Report – Course of Treatment and Recommendations – A.2.9 EN |
| [A.3 - Presented form](StructureDefinition-PresentedFormCz.md) | Presented form - Entire report as issued. Various formats could be provided, pdf format is recommended. |
| [A.4 - Additional attachments](StructureDefinition-AttachmentsCz.md) | EMS report - additional attachments |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Allergy Intolerance: (EMS CZ)](StructureDefinition-cz-allergyIntolerance-ems.md) | This profile constrains the AllergyIntolerance resource for the purpose of the EMS project. |
| [Bundle: EMS Report (CZ)](StructureDefinition-cz-bundle-ems.md) | Clinical document used to represent a EMS Report for the scope of this guide. |
| [CZ Immunization EMS](StructureDefinition-cz-immunization-ems.md) | FHIR Immunization profile for use within Emergency Medical Services (EMS) in the Czech Republic. |
| [CZ Observation SDOH: (EMS)](StructureDefinition-cz-observation-sdoh-ems.md) | Profile for Social Determinants of Health (SDOH) observations that involve assessment (e.g., by a provider, payer, etc.) as opposed to being derived only from screening surveys (as is the case for the SDOHCC Screening Response Observation). |
| [CareTeam: (EMS CZ)](StructureDefinition-cz-careteam-ems.md) | Profile of the emergency medical service team within Czech EMS. |
| [Communication: (EMS CZ)](StructureDefinition-cz-communication-ems.md) | CZ Emergency Medical Service Communication Resource |
| [Composition (EMS CZ)](StructureDefinition-cz-composition-ems.md) | This profile defines how to represent Composition resource in HL7 FHIR for the scope of this guide. |
| [Condition (EMS CZ)](StructureDefinition-cz-condition-ems.md) | This profile represents the constraint applied to the Condition in the scope of this guide. It supports the Diagnostic summary part of the data model. |
| [Encounter EMS (CZ)](StructureDefinition-cz-encounter-ems.md) | This profile defines how to represent Encounter resource in HL7 FHIR for the scope of this guide. |
| [Flag: (EMS CZ)](StructureDefinition-cz-flag-ems.md) | This profile constrains the Flag resource for the purpose of the EMS project. |
| [Immunization Recommendation: (EMS CZ)](StructureDefinition-cz-immunizationRecommendation-ems.md) | This profile defines how to represent Immunization Recommandations for the purpose of this guide. |
| [Infectious Contact: (EMS CZ)](StructureDefinition-cz-observation-infectious-contact-ems.md) | Infectious Contact profile represents potential patient exposure to an agent (exposure source). |
| [Location - Vehicle: (EMS CZ)](StructureDefinition-cz-vehicle-location-ems.md) | Location resource used to identify an emergency response vehicle or other means of transport of the Emergency Medical Service (EMS). |
| [Location: (EMS CZ)](StructureDefinition-cz-location-ems.md) | Location profile for Emergency Medical Service |
| [Medication Administration: EMS Report (CZ)](StructureDefinition-cz-MedicationAdministration.md) | Czech national profile for a medication administration. |
| [Observation: Anthropometric Data - BMI (EMS CZ)](StructureDefinition-cz-observation-BMI-ems.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric data - BMI. |
| [Observation: Anthropometric Data - Height (EMS CZ)](StructureDefinition-cz-observation-height-ems.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric data - height. |
| [Observation: Anthropometric Data - Weight (EMS CZ)](StructureDefinition-cz-observation-weight-ems.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric data - weight. |
| [Observation: Other Objective Findings (EMS CZ)](StructureDefinition-cz-observation-OtherOF-ems.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch Objective Findings. |
| [Observation: Oxygen Therapy Observation (EMS CZ)](StructureDefinition-cz-observation-oxygen-ems.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch VitalSigns - Oxygen Therapy. |
| [Observation: Vital Signs (EMS CZ)](StructureDefinition-cz-observation-vitalSigns-ems.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch Vital signs. |
| [Procedure: EMS Report (CZ)](StructureDefinition-cz-procedure-ems.md) | This profile on Procedure represents the ems procedure for the scope of the Czech national interoperability project. |
| [Task: (EMS CZ)](StructureDefinition-cz-task-ems.md) | CZ Emergency Medical Service Task Resource |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| |
| :--- |
| [Urgency level (1–4)](StructureDefinition-ext-cz-ems-urgency-level.md) |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Condition Value Set](ValueSet-condition-cz-ems.md) | Condition value set includes selected codes from recommended EU code systems for health conditions (WHO-ICD-10, SNOMED CT and Orphacodes). |
| [ObservationsEmsHeightType](ValueSet-cz-observationHeightType-ems-vs.md) | This value set includes all Height types for observations of EMS report. |
| [ObservationsEmsOFType](ValueSet-cz-observationOFType-ems-vs.md) | This value set includes other Objective findings observations of EMS report. |
| [ObservationsEmsVSType](ValueSet-cz-observationVSType-ems-vs.md) | This value set includes other Vital Signs observations of EMS report. |
| [ObservationsEmsWeightType](ValueSet-cz-observationWeightType-ems-vs.md) | This value set includes all Weight types for observations of EMS report. |
| [ObservationsUnitHeight](ValueSet-cz-observationUnitsHeight-ems-vs.md) | UCUM units for height |
| [ObservationsUnitWeight](ValueSet-cz-observationUnitsWeight-ems-vs.md) | UCUM units for weight |

### Terminology: Concept Maps 

These define transformations to convert between codes by systems conforming with this implementation guide.

| | |
| :--- | :--- |
| [CZ Alerts Model to this guide Map](ConceptMap-Alerts2FHIR-cz.md) | CZ Emergency Medical Service Report Alerts Model to this guide mapping |
| [CZ Attachment Model to this guide Map](ConceptMap-AttachmentEMS2FHIR-cz.md) | CZ Emergency Medical Service Report Attachment Model to this guide mapping |
| [CZ ClinicalCourseAndRecommendations Model to this guide Map](ConceptMap-ClinicalCourseAndRecommendationsEMS2FHIR-cz.md) | CZ Emergency Medical Service Report ClinicalCourseAndRecommendations Model to this guide mapping |
| [CZ DispatchData Model to this guide Map](ConceptMap-DispatchDataEMS2FHIR-cz.md) | CZ Emergency Medical Service Report DispatchData Model to this guide mapping |
| [CZ DispatchTimeline Model to this guide Map](ConceptMap-DispatchTimeline2FHIR-cz.md) | CZ Emergency Medical Service Report DispatchTimeline Model to this guide mapping |
| [CZ Objective Findings Model to this guide Map](ConceptMap-ObjectiveFindingsEMS2FHIR-cz.md) | CZ Emergency Medical Service Report ObjectiveFindings Model to this guide mapping |
| [CZ Patient History to this guide Map](ConceptMap-patientHistory2FHIR-cz.md) | CZ EMS Patient History Model to this guide Map |
| [CZ Presenting Illness to this guide Map](ConceptMap-PresentingIllness2FHIR-cz.md) | CZ EMS Report Presenting Illness Model to this guide mapping |
| [CZ Therapy Model to this guide Map](ConceptMap-Therapy2FHIR-cz.md) | CZ EMS Report Therapy Model to this guide mapping |
| [EMS diagnostic summary Model to this guide Map](ConceptMap-diagnosticSummary2FHIR-cz-ems.md) | CZ EMS Diagnostic summary Model to this guide Map |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [BMI of patient](Observation-ExampleBMIEms.md) | Example instance for BMI observation using the CZ_ObservationBMIEms profile. |
| [Body height of patient](Observation-ExampleBodyHeightEms.md) | Example of body height of Patient Mracena |
| [Body weight of patient](Observation-ExampleBodyWeightEms.md) | Example of body weight of Patient Mracena |
| [Bundle: EMS report](Bundle-cz-example-bundle.md) | Example of EMS report (Bundle) |
| [EMS Pacientky Mračeny Mrakomorové](Composition-da3f987f-2a08-431a-92e3-129d7689e465.md) | Example of EMS report (Composition) |
| [Patient Mracena](Patient-3b46c18c-7e07-4232-af3e-f710dec8e766.md) | Patient Mracena with contact information and practitioner |
| [Practitioner Blažejovský: EMS report](Practitioner-2e877c76-633d-479b-a6d4-c6d95942de3f.md) | Example of practitioner for EMS report. |
| [cz-encounter-example](Encounter-cd343afa-039d-4576-b5e4-e89598aeb628.md) | Encounter |
| [cz-logo2-example](DocumentReference-040eb849-a513-4d74-b3f3-d2f246a26877.md) | Example of logo as document reference for FN Motol. |
| [cz-organizationwithlogo-example](Organization-821077d6-ce17-4602-b3ad-d4bef845a950.md) | An example of the organization with logo extension |
| [cz-procedure-example](Procedure-3af2e7a6-c16e-4b80-a173-ca2c8aa081b6.md) | Procedure |
| [practitionerEms](Practitioner-practitionerEms.md) | Example of practitioner |

