# ObservationsUnitHeight - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **ObservationsUnitHeight**

## ValueSet: ObservationsUnitHeight 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/ValueSet/cz-observationUnitsHeight-ems-vs | *Version*:0.0.2 |
| Active as of 2024-01-01 | *Computable Name*:CZ_ObservationUnitsHeightEmsVs |

 
UCUM units for height 

 **References** 

* [Observation: Anthropometric Data - Height (EMS CZ)](StructureDefinition-cz-observation-height-ems.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on codesystem UCUM version 2.2

This value set contains 2 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-observationUnitsHeight-ems-vs",
  "language" : "cs",
  "url" : "https://hl7.cz/fhir/cz-ems/ValueSet/cz-observationUnitsHeight-ems-vs",
  "version" : "0.0.2",
  "name" : "CZ_ObservationUnitsHeightEmsVs",
  "title" : "ObservationsUnitHeight",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-01-01",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "UCUM units for height",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://unitsofmeasure.org",
        "concept" : [
          {
            "code" : "m"
          },
          {
            "code" : "cm"
          }
        ]
      }
    ]
  }
}

```
