# Urgency level (1–4) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Urgency level (1–4)**

## Extension: Urgency level (1–4) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/ext-cz-ems-urgency-level | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:CzEmsUrgencyLevel |

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Task: (EMS CZ)](StructureDefinition-cz-task-ems.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/ext-cz-ems-urgency-level)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ext-cz-ems-urgency-level.csv), [Excel](StructureDefinition-ext-cz-ems-urgency-level.xlsx), [Schematron](StructureDefinition-ext-cz-ems-urgency-level.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ext-cz-ems-urgency-level",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/ext-cz-ems-urgency-level",
  "version" : "0.0.2",
  "name" : "CzEmsUrgencyLevel",
  "title" : "Urgency level (1–4)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Task"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Naléhavost zásahu 1..4",
        "definition" : "Stupnice 1–4 dle ZZS."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/ext-cz-ems-urgency-level"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://example.org/fhir/ValueSet/cz-ems-urgency-1to4"
        }
      }
    ]
  }
}

```
