# Location - Vehicle: (EMS CZ) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Location - Vehicle: (EMS CZ)**

## Resource Profile: Location - Vehicle: (EMS CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-vehicle-location-ems | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_VehicleLocationEms |

 
Location resource used to identify an emergency response vehicle or other means of transport of the Emergency Medical Service (EMS). 

**Usages:**

* Refer to this Profile: [Composition (EMS CZ)](StructureDefinition-cz-composition-ems.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/cz-vehicle-location-ems)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-vehicle-location-ems.csv), [Excel](StructureDefinition-cz-vehicle-location-ems.xlsx), [Schematron](StructureDefinition-cz-vehicle-location-ems.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-vehicle-location-ems",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-vehicle-location-ems",
  "version" : "0.0.2",
  "name" : "CZ_VehicleLocationEms",
  "title" : "Location - Vehicle: (EMS CZ)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Location resource used to identify an emergency response vehicle or other means of transport of the Emergency Medical Service (EMS).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Location",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Location",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Location",
        "path" : "Location"
      },
      {
        "id" : "Location.identifier",
        "path" : "Location.identifier",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Location.identifier.type",
        "path" : "Location.identifier.type",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Location.identifier.system",
        "path" : "Location.identifier.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Location.identifier.value",
        "path" : "Location.identifier.value",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Location.name",
        "path" : "Location.name",
        "mustSupport" : true
      },
      {
        "id" : "Location.mode",
        "path" : "Location.mode",
        "min" : 1,
        "patternCode" : "instance",
        "mustSupport" : true
      },
      {
        "id" : "Location.physicalType",
        "path" : "Location.physicalType",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/location-physical-type",
              "code" : "ve",
              "display" : "Vehicle"
            }
          ]
        },
        "mustSupport" : true
      }
    ]
  }
}

```
