# Task: (EMS CZ) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Task: (EMS CZ)**

## Resource Profile: Task: (EMS CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-task-ems | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_TaskEms |

 
CZ Emergency Medical Service Task Resource 

**Usages:**

* Refer to this Profile: [Composition (EMS CZ)](StructureDefinition-cz-composition-ems.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/cz-task-ems)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-task-ems.csv), [Excel](StructureDefinition-cz-task-ems.xlsx), [Schematron](StructureDefinition-cz-task-ems.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-task-ems",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-task-ems",
  "version" : "0.0.2",
  "name" : "CZ_TaskEms",
  "title" : "Task: (EMS CZ)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ Emergency Medical Service Task Resource",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Task",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Task",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Task",
        "path" : "Task"
      },
      {
        "id" : "Task.extension",
        "path" : "Task.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Task.extension:urgencyLevel",
        "path" : "Task.extension",
        "sliceName" : "urgencyLevel",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/ext-cz-ems-urgency-level"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.identifier",
        "path" : "Task.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "rules" : "open"
        },
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Task.identifier:dispatchNumber",
        "path" : "Task.identifier",
        "sliceName" : "dispatchNumber",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Task.identifier:dispatchNumber.use",
        "path" : "Task.identifier.use",
        "patternCode" : "official"
      },
      {
        "id" : "Task.identifier:dispatchNumber.type",
        "path" : "Task.identifier.type",
        "min" : 1
      },
      {
        "id" : "Task.identifier:dispatchNumber.system",
        "path" : "Task.identifier.system",
        "min" : 1
      },
      {
        "id" : "Task.identifier:dispatchNumber.value",
        "path" : "Task.identifier.value",
        "min" : 1
      },
      {
        "id" : "Task.identifier:otherId",
        "path" : "Task.identifier",
        "sliceName" : "otherId",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Task.identifier:otherId.use",
        "path" : "Task.identifier.use",
        "patternCode" : "secondary"
      },
      {
        "id" : "Task.identifier:otherId.type",
        "path" : "Task.identifier.type",
        "min" : 1
      },
      {
        "id" : "Task.identifier:otherId.system",
        "path" : "Task.identifier.system",
        "min" : 1
      },
      {
        "id" : "Task.identifier:otherId.value",
        "path" : "Task.identifier.value",
        "min" : 1
      },
      {
        "id" : "Task.authoredOn",
        "path" : "Task.authoredOn",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Task.reasonCode",
        "path" : "Task.reasonCode",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://example.org/fhir/ValueSet/cz-ems-zos-classification"
        }
      }
    ]
  }
}

```
