# Procedure: EMS Report (CZ) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Procedure: EMS Report (CZ)**

## Resource Profile: Procedure: EMS Report (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-procedure-ems | *Version*:0.0.2 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_ProcedureEms |

 
This profile on Procedure represents the ems procedure for the scope of the Czech national interoperability project. 

**Usages:**

* Use this Profile: [Bundle: EMS Report (CZ)](StructureDefinition-cz-bundle-ems.md)
* Refer to this Profile: [Medication Administration: EMS Report (CZ)](StructureDefinition-cz-MedicationAdministration.md) and [Composition (EMS CZ)](StructureDefinition-cz-composition-ems.md)
* Examples for this Profile: [Procedure/3af2e7a6-c16e-4b80-a173-ca2c8aa081b6](Procedure-3af2e7a6-c16e-4b80-a173-ca2c8aa081b6.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/cz-procedure-ems)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-procedure-ems.csv), [Excel](StructureDefinition-cz-procedure-ems.xlsx), [Schematron](StructureDefinition-cz-procedure-ems.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-procedure-ems",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-procedure-ems",
  "version" : "0.0.2",
  "name" : "CZ_ProcedureEms",
  "title" : "Procedure: EMS Report (CZ)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile on Procedure represents the ems procedure for the scope of the Czech national interoperability project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Procedure",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Procedure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Procedure.code",
        "path" : "Procedure.code",
        "min" : 1
      },
      {
        "id" : "Procedure.subject",
        "path" : "Procedure.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-patient-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-patient-animal",
              "http://hl7.org/fhir/StructureDefinition/Group"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.recorder",
        "path" : "Procedure.recorder",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitioner-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitionerrole-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-patient-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-relatedPerson-core"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.asserter",
        "path" : "Procedure.asserter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitioner-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitionerrole-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-patient-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-relatedPerson-core"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.performer",
        "path" : "Procedure.performer",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "function"
            }
          ],
          "description" : "Different performers can be added to the procedure.",
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Procedure.performer.function",
        "path" : "Procedure.performer.function",
        "min" : 1
      },
      {
        "id" : "Procedure.performer.actor",
        "path" : "Procedure.performer.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitioner-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitionerrole-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-organization-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-patient-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-relatedPerson-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-device-observer",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-medical-device"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.performer.onBehalfOf",
        "path" : "Procedure.performer.onBehalfOf",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.performer:performer",
        "path" : "Procedure.performer",
        "sliceName" : "performer",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Procedure.performer:performer.function.coding",
        "path" : "Procedure.performer.function.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "\"\"$this\"\""
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Procedure.performer:performer.function.coding:healthcare-professional",
        "path" : "Procedure.performer.function.coding",
        "sliceName" : "healthcare-professional",
        "min" : 0,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://snomed.info/sct",
          "code" : "223366009",
          "display" : "Healthcare professional"
        }
      },
      {
        "id" : "Procedure.performer:performer.actor",
        "path" : "Procedure.performer.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitionerrole-core"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.performer:imaging-device",
        "path" : "Procedure.performer",
        "sliceName" : "imaging-device",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Procedure.usedReference",
        "path" : "Procedure.usedReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-device-observer",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-medical-device",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-Medication",
              "http://hl7.org/fhir/StructureDefinition/Substance"
            ]
          }
        ]
      }
    ]
  }
}

```
