# Infectious Contact: (EMS CZ) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Infectious Contact: (EMS CZ)**

## Resource Profile: Infectious Contact: (EMS CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-infectious-contact-ems | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_ObservationInfectiousContactEMS |

 
Infectious Contact profile represents potential patient exposure to an agent (exposure source). 

**Usages:**

* Refer to this Profile: [Composition (EMS CZ)](StructureDefinition-cz-composition-ems.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/cz-observation-infectious-contact-ems)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-observation-infectious-contact-ems.csv), [Excel](StructureDefinition-cz-observation-infectious-contact-ems.xlsx), [Schematron](StructureDefinition-cz-observation-infectious-contact-ems.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-observation-infectious-contact-ems",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/hdr/StructureDefinition/observation-infectious-contact-eu-hdr"
    }
  ],
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-infectious-contact-ems",
  "version" : "0.0.2",
  "name" : "CZ_ObservationInfectiousContactEMS",
  "title" : "Infectious Contact: (EMS CZ)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Infectious Contact profile represents potential patient exposure to an agent (exposure source).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-infectious-contact-hdr",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      }
    ]
  }
}

```
