# Composition (EMS CZ) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Composition (EMS CZ)**

## Resource Profile: Composition (EMS CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-composition-ems | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_CompositionEms |

 
This profile defines how to represent Composition resource in HL7 FHIR for the scope of this guide. 

**Usages:**

* Use this Profile: [Bundle: EMS Report (CZ)](StructureDefinition-cz-bundle-ems.md)
* Examples for this Profile: [Composition/da3f987f-2a08-431a-92e3-129d7689e465](Composition-da3f987f-2a08-431a-92e3-129d7689e465.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/cz-composition-ems)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-composition-ems.csv), [Excel](StructureDefinition-cz-composition-ems.xlsx), [Schematron](StructureDefinition-cz-composition-ems.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-composition-ems",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-composition-ems",
  "version" : "0.0.2",
  "name" : "CZ_CompositionEms",
  "title" : "Composition (EMS CZ)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Composition resource in HL7 FHIR for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "fhirdocumentreference",
      "uri" : "http://hl7.org/fhir/documentreference",
      "name" : "FHIR DocumentReference"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Composition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Composition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Composition",
        "path" : "Composition",
        "short" : "Emergency medical service report composition",
        "definition" : "Emergency medical service report composition. \r\nA composition is a set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. \r\nWhile a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.",
        "constraint" : [
          {
            "key" : "text-or-section",
            "severity" : "error",
            "human" : "A Composition SHALL have either text, at least one section, or both.",
            "expression" : "text.exists() or section.exists()",
            "source" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-composition-ems"
          }
        ]
      },
      {
        "id" : "Composition.extension",
        "path" : "Composition.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.extension:basedOn",
        "path" : "Composition.extension",
        "sliceName" : "basedOn",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/event-basedOn"]
          }
        ]
      },
      {
        "id" : "Composition.extension:basedOn.value[x]",
        "path" : "Composition.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Resource",
              "http://hl7.org/fhir/StructureDefinition/ServiceRequest"
            ]
          }
        ]
      },
      {
        "id" : "Composition.identifier",
        "path" : "Composition.identifier",
        "short" : "EMS business identifier"
      },
      {
        "id" : "Composition.status",
        "path" : "Composition.status",
        "short" : "EMS status"
      },
      {
        "id" : "Composition.type",
        "path" : "Composition.type",
        "short" : "Kind of composition (\"Emergency Medical Services\")",
        "definition" : "Specifies that this composition refer to a Level 3 emergency medical services patient care report - recommended CDA R1 and R2 sections",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "67796-3",
              "display" : "EMS patient care report - version 3 Document NEMSIS"
            }
          ]
        }
      },
      {
        "id" : "Composition.subject",
        "path" : "Composition.subject",
        "definition" : "Who or what the composition is about. \r\nIn general a composition can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure).\r\nFor the ems the subject is always the patient.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.encounter",
        "path" : "Composition.encounter",
        "short" : "Context that defines the EMS Report",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-encounter"
            ]
          }
        ]
      },
      {
        "id" : "Composition.date",
        "path" : "Composition.date",
        "short" : "EMS date"
      },
      {
        "id" : "Composition.author",
        "path" : "Composition.author",
        "short" : "Who and/or what authored the Emergency Medical Services",
        "definition" : "Identifies who is responsible for the information in the Hospital Discharge Report, not necessarily who typed it in.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitioner-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitionerrole-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-medical-device",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-patient-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-relatedPerson-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.title",
        "path" : "Composition.title",
        "short" : "Emergency Medical Services",
        "definition" : "Official human-readable label for the composition.\r\n\r\nFor this document should be \"Emergency Medical Services\" or any equivalent translation"
      },
      {
        "id" : "Composition.attester.mode",
        "path" : "Composition.attester.mode",
        "short" : "The type of attestation"
      },
      {
        "id" : "Composition.attester.time",
        "path" : "Composition.attester.time",
        "short" : "When the composition was attested."
      },
      {
        "id" : "Composition.attester.party",
        "path" : "Composition.attester.party",
        "short" : "Who attested the composition.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitioner-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitionerrole-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-patient-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-relatedPerson-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section",
        "path" : "Composition.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Sections composing the Emergency Medical Services",
        "definition" : "The root of the sections that make up the Emergency Medical Services composition.",
        "min" : 1
      },
      {
        "id" : "Composition.section.author",
        "path" : "Composition.section.author",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitioner-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitionerrole-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-patient-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-relatedPerson-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:presentIllness",
        "path" : "Composition.section",
        "sliceName" : "presentIllness",
        "short" : "Expos inj EMS person Provider NEMSIS",
        "definition" : "EMS exposures or injuries of EMS personnel Provider Narrative NEMSIS.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:presentIllness.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "67658-5"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:presentIllness.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:findings",
        "path" : "Composition.section",
        "sliceName" : "findings",
        "short" : "Physical findings Narrative",
        "definition" : "Physical findings Narrative",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Composition.section:findings.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "29545-1"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:findings.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-BMI-ems",
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-height-ems",
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-infectious-contact-ems",
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-OtherOF-ems",
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-oxygen-ems",
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-vitalSigns-ems",
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-observation-weight-ems",
              "http://hl7.org/fhir/StructureDefinition/Observation"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:clinicalCourseAndRecommendations",
        "path" : "Composition.section",
        "sliceName" : "clinicalCourseAndRecommendations",
        "short" : "Clinical Course And Recommendations",
        "definition" : "EMS patient care report - version 3 Document NEMSIS",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Composition.section:clinicalCourseAndRecommendations.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "67796-3"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:clinicalCourseAndRecommendations.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-procedure-ems"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:procedure",
        "path" : "Composition.section",
        "sliceName" : "procedure",
        "short" : "Procedure",
        "definition" : "Procedure records the descriptions of the procedure with an extensive narrative and may include procedure site preparation, pertinent details related to measurements and markings, procedure times, instrumentation, and vital signs and other monitoring data.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Composition.section:procedure.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "29554-3"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:procedure.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-procedure-ems"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:diagnosticSummary",
        "path" : "Composition.section",
        "sliceName" : "diagnosticSummary",
        "short" : "Diagnostic summary",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:diagnosticSummary.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11450-4"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:diagnosticSummary.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-condition-ems"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:dispatch",
        "path" : "Composition.section",
        "sliceName" : "dispatch",
        "short" : "EMS dispatch Narrative NEMSIS",
        "definition" : "Information related to dispatch instructions",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:dispatch.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "67660-1"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:dispatch.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-encounter",
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-task-ems",
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-location-ems",
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-communication-ems",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitioner-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitionerrole-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-patient-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-vehicle-location-ems"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:timeline",
        "path" : "Composition.section",
        "sliceName" : "timeline",
        "short" : "EMS times Narrative NEMSIS",
        "definition" : "Times recorded to assess delays",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:timeline.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "67667-6"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:timeline.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-encounter",
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-task-ems",
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-communication-ems"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:attachments",
        "path" : "Composition.section",
        "sliceName" : "attachments",
        "short" : "Attachments",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Composition.section:attachments.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "34109-9"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:attachments.author",
        "path" : "Composition.section.author",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitionerrole-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-patient-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-relatedPerson-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:attachments.entry",
        "path" : "Composition.section.entry",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-logo",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx",
        "path" : "Composition.section",
        "sliceName" : "sectionPatientHx",
        "short" : "Patient History Section",
        "definition" : "This Section describes all aspects of the medical history of the patient even if not pertinent to the current procedure, and may include chief complaint, past medical history, social history, family history, surgical or procedure history, medication history, and other history information. The history may be limited to information pertinent to the current procedure or may be more comprehensive. The history may be reported as a collection of random clinical statements or it may be reported categorically. Categorical report formats may be divided into multiple subsections including Past Medical History, Social History.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPatientHx.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPatientHx.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11329-0"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHx.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPatientHx.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionAllergies",
        "path" : "Composition.section",
        "sliceName" : "sectionAllergies",
        "short" : "Allergies and Intolerances Section",
        "definition" : "This section documents the relevant allergies or intolerances (conditions) for that patient, describing the kind of reaction (e.g. rash, anaphylaxis,..); preferably the agents that cause it; and optionally the criticality and the certainty of the allergy.\r\nAt a minimum, it should list currently active and any relevant historical allergies and adverse reactions.\r\nIf no information about allergies is available, or if no allergies are known this should be clearly documented in the section.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionAllergies.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAllergies.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48765-2"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAllergies.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAllergies.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Relevant allergies or intolerances (conditions) for that patient.",
        "definition" : "It lists the relevant allergies or intolerances (conditions) for that patient, describing the kind of reaction (e.g. rash, anaphylaxis,..); preferably the agents that cause it; and optionally the criticality and the certainty of the allergy.\r\nAt a minimum, it should list currently active and any relevant historical allergies and adverse reactions.\r\n This entry shall be used to document that no information about allergies is available, or that no allergies are known .",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-allergyIntolerance-ems",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference",
              "http://hl7.org/fhir/StructureDefinition/AllergyIntolerance"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAllergies.entry:allergyIntolerance",
        "path" : "Composition.section.entry",
        "sliceName" : "allergyIntolerance",
        "short" : "Allergy entry",
        "definition" : "Allergy entry",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-allergyIntolerance-ems"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAllergies.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAllergies.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionAlert",
        "path" : "Composition.section",
        "sliceName" : "sectionAlert",
        "short" : "Health Concern Section",
        "definition" : "// SHORT\n      This section contains data describing an interest or worry about a health state or process that could possibly require attention, intervention, or management. A Health Concern is a health related matter that is of interest, importance or worry to someone, who may be the patient, patient's family or patient's health care provider. Health concerns are derived from a variety of sources within an EHR, such as Problem List, Family History, Social Histor, Social Worker Note, etc. Health concerns can be medical, surgical, nursing, allied health or patient-reported concerns. Problem Concerns are a subset of Health Concerns that have risen to the level of importance that they typically would belong on a classic “Problem List”, such as “Diabetes Mellitus” or “Family History of Melanoma” or “Tobacco abuse”. These are of broad interest to multiple members of the care team. Examples of other Health Concerns that might not typically be considered a Problem Concern include “Risk of Hyperkalemia” for a patient taking an ACE-inhibitor medication, or “Transportation difficulties” for someone who doesn't drive and has trouble getting to appointments, or “Under-insured” for someone who doesn't have sufficient insurance to properly cover their medical needs such as medications. These are typically most important to just a limited number of care team members",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionAlert.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAlert.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "75310-3"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAlert.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAlert.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Alerts",
        "definition" : "Alerts"
      },
      {
        "id" : "Composition.section:sectionAlert.entry:flag",
        "path" : "Composition.section.entry",
        "sliceName" : "flag",
        "short" : "Flags",
        "definition" : "Flags",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-flag-ems"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAlert.entry:detectedIssue",
        "path" : "Composition.section.entry",
        "sliceName" : "detectedIssue",
        "short" : "Detected Issue",
        "definition" : "Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. Drug-drug interaction, Ineffective treatment frequency, Procedure-condition conflict, etc.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/DetectedIssue"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAlert.entry:riskAssessment",
        "path" : "Composition.section.entry",
        "sliceName" : "riskAssessment",
        "short" : "Risk Assessment",
        "definition" : "An assessment of the likely outcomes for a patient or other subject as well as the likelihood of each outcome.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/RiskAssessment"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAlert.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAlert.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      }
    ]
  }
}

```
