# Communication: (EMS CZ) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Communication: (EMS CZ)**

## Resource Profile: Communication: (EMS CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-communication-ems | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_CommunicationEms |

 
CZ Emergency Medical Service Communication Resource 

**Usages:**

* Refer to this Profile: [Composition (EMS CZ)](StructureDefinition-cz-composition-ems.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/cz-communication-ems)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-communication-ems.csv), [Excel](StructureDefinition-cz-communication-ems.xlsx), [Schematron](StructureDefinition-cz-communication-ems.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-communication-ems",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-communication-ems",
  "version" : "0.0.2",
  "name" : "CZ_CommunicationEms",
  "title" : "Communication: (EMS CZ)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ Emergency Medical Service Communication Resource",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Communication",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Communication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Communication",
        "path" : "Communication"
      },
      {
        "id" : "Communication.basedOn",
        "path" : "Communication.basedOn",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Task"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Communication.status",
        "path" : "Communication.status",
        "patternCode" : "completed",
        "mustSupport" : true
      },
      {
        "id" : "Communication.recipient",
        "path" : "Communication.recipient",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitioner-core",
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitionerrole-core",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Communication.recipient.identifier",
        "path" : "Communication.recipient.identifier",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Communication.sender",
        "path" : "Communication.sender",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/RelatedPerson"]
          }
        ]
      }
    ]
  }
}

```
