# Allergy Intolerance: (EMS CZ) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Allergy Intolerance: (EMS CZ)**

## Resource Profile: Allergy Intolerance: (EMS CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-allergyIntolerance-ems | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_AllergyIntoleranceEms |

 
This profile constrains the AllergyIntolerance resource for the purpose of the EMS project. 

**Usages:**

* Refer to this Profile: [Composition (EMS CZ)](StructureDefinition-cz-composition-ems.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/cz-allergyIntolerance-ems)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-allergyIntolerance-ems.csv), [Excel](StructureDefinition-cz-allergyIntolerance-ems.xlsx), [Schematron](StructureDefinition-cz-allergyIntolerance-ems.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-allergyIntolerance-ems",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/cz-allergyIntolerance-ems",
  "version" : "0.0.2",
  "name" : "CZ_AllergyIntoleranceEms",
  "title" : "Allergy Intolerance: (EMS CZ)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile constrains the AllergyIntolerance resource for the purpose of the EMS project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "AllergyIntolerance",
  "baseDefinition" : "https://fhir.hl7cr.eu/core/StructureDefinition/cz-allergyIntolerance",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "AllergyIntolerance",
        "path" : "AllergyIntolerance"
      }
    ]
  }
}

```
