# A.2.7 - Therapy - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.7 - Therapy**

## Logical Model: A.2.7 - Therapy 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/TherapyEmsCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogEnTherapyEmsCz |

 
Emergency medical service report - Therapy 

**Usages:**

* Use this Logical Model: [A - EMS Report (en)](StructureDefinition-EmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/TherapyEmsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TherapyEmsCz.csv), [Excel](StructureDefinition-TherapyEmsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TherapyEmsCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/TherapyEmsCz",
  "version" : "0.0.2",
  "name" : "LogEnTherapyEmsCz",
  "title" : "A.2.7 - Therapy",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Emergency medical service report - Therapy",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/TherapyEmsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TherapyEmsCz",
        "path" : "TherapyEmsCz",
        "short" : "A.2.7 - Therapy",
        "definition" : "Emergency medical service report - Therapy"
      },
      {
        "id" : "TherapyEmsCz.procedures",
        "path" : "TherapyEmsCz.procedures",
        "short" : "A.2.7.1 - Procedures",
        "definition" : "Medical procedures according to the EMS (Emergency Medical Service) codebook.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "TherapyEmsCz.procedures.name",
        "path" : "TherapyEmsCz.procedures.name",
        "short" : "A.2.7.1.1 - Procedure name",
        "definition" : "The name of the procedure according to the EMS codebook.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "TherapyEmsCz.procedures.date",
        "path" : "TherapyEmsCz.procedures.date",
        "short" : "A.2.7.1.2 - Date and time of performance",
        "definition" : "The date and time the procedure was performed.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "TherapyEmsCz.medicalDevices",
        "path" : "TherapyEmsCz.medicalDevices",
        "short" : "A.2.7.2 - Medical devices",
        "definition" : "Record of used medical devices (PZT).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "TherapyEmsCz.medicalDevices.description",
        "path" : "TherapyEmsCz.medicalDevices.description",
        "short" : "A.2.7.2.1 - Description of the medical device",
        "definition" : "Description of the medical device used during the intervention via free text and/or code.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "TherapyEmsCz.medicalDevices.id",
        "path" : "TherapyEmsCz.medicalDevices.id",
        "short" : "A.2.7.2.2 - Device identifier",
        "definition" : "Normalized identifier, e.g., UDI, according to EU regulation 2017/745.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "TherapyEmsCz.medication",
        "path" : "TherapyEmsCz.medication",
        "short" : "A.2.7.3 - Medication",
        "definition" : "Medication treatment during the care.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "TherapyEmsCz.medication.codeSUKL",
        "path" : "TherapyEmsCz.medication.codeSUKL",
        "short" : "A.2.7.3.1 - SUKL Code",
        "definition" : "The code of the medicinal product according to the SÚKL database.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "TherapyEmsCz.medication.medicinalProductName",
        "path" : "TherapyEmsCz.medication.medicinalProductName",
        "short" : "A.2.7.3.2 - Name of the medicinal product",
        "definition" : "The registered name of the medicinal product according to the medicinal products database.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "TherapyEmsCz.medication.groupATC",
        "path" : "TherapyEmsCz.medication.groupATC",
        "short" : "A.2.7.3.3 - ATC group",
        "definition" : "The ATC group of the administered medicinal product.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "TherapyEmsCz.medication.activeSubstances",
        "path" : "TherapyEmsCz.medication.activeSubstances",
        "short" : "A.2.7.3.4 - Active substances",
        "definition" : "List of active substances in the medicinal product derived from the record of the HVLP or IVLP product in the SUKL database (DLP). Active substances are listed by name and, if applicable, also by DLP code.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "TherapyEmsCz.medication.strength",
        "path" : "TherapyEmsCz.medication.strength",
        "short" : "A.2.7.3.5 - Strength",
        "definition" : "The strength of the active medicinal substance contained in the medicinal product. The strength is expressed in relation to the unit of administration. E.g., 500mg in a tablet.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "TherapyEmsCz.medication.medicinalForm",
        "path" : "TherapyEmsCz.medication.medicinalForm",
        "short" : "A.2.7.3.6 - Form of the medicinal product",
        "definition" : "The dosage form contained in the package expressed by a code. E.g., Syrup, tablet, etc.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "TherapyEmsCz.medication.administeredQuantity",
        "path" : "TherapyEmsCz.medication.administeredQuantity",
        "short" : "A.2.7.3.7 - Dosage",
        "definition" : "The number of units of administration by free text or formally.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "TherapyEmsCz.medication.routeOfAdministration",
        "path" : "TherapyEmsCz.medication.routeOfAdministration",
        "short" : "A.2.7.3.8 - Route of administration",
        "definition" : "Route of administration.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "TherapyEmsCz.medication.dateOfAdministration",
        "path" : "TherapyEmsCz.medication.dateOfAdministration",
        "short" : "A.2.7.3.9 - Date and time of administration",
        "definition" : "Date and time of administration.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
