# A.2.5 - Presenting Illness - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.5 - Presenting Illness**

## Logical Model: A.2.5 - Presenting Illness 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/PresentingIllnessEmsCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogEnPresentingIllnessEmsCz |

 
Emergency medical service report - Presenting Illness 

**Usages:**

* Use this Logical Model: [A - EMS Report (en)](StructureDefinition-EmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/PresentingIllnessEmsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-PresentingIllnessEmsCz.csv), [Excel](StructureDefinition-PresentingIllnessEmsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PresentingIllnessEmsCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/PresentingIllnessEmsCz",
  "version" : "0.0.2",
  "name" : "LogEnPresentingIllnessEmsCz",
  "title" : "A.2.5 - Presenting Illness",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Emergency medical service report - Presenting Illness",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/PresentingIllnessEmsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "PresentingIllnessEmsCz",
        "path" : "PresentingIllnessEmsCz",
        "short" : "A.2.5 - Presenting Illness",
        "definition" : "Emergency medical service report - Presenting Illness"
      },
      {
        "id" : "PresentingIllnessEmsCz.description",
        "path" : "PresentingIllnessEmsCz.description",
        "short" : "A.2.5.1 - Textual description",
        "definition" : "Description of the present illness.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
