# A.2.3 - Patient history (en) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.3 - Patient history (en)**

## Logical Model: A.2.3 - Patient history (en) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/PatientHistoryCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogEnPatientHistoryCz |

 
EMS Report - Patient history - A.2.3 EN 

**Usages:**

* Use this Logical Model: [A - EMS Report (en)](StructureDefinition-EmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/PatientHistoryCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-PatientHistoryCz.csv), [Excel](StructureDefinition-PatientHistoryCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PatientHistoryCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/PatientHistoryCz",
  "version" : "0.0.2",
  "name" : "LogEnPatientHistoryCz",
  "title" : "A.2.3 - Patient history (en)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "EMS Report - Patient history - A.2.3 EN",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/PatientHistoryCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "PatientHistoryCz",
        "path" : "PatientHistoryCz",
        "short" : "A.2.3 - Patient history (en)",
        "definition" : "EMS Report - Patient history - A.2.3 EN"
      },
      {
        "id" : "PatientHistoryCz.medicalHistory",
        "path" : "PatientHistoryCz.medicalHistory",
        "short" : "A.2.3.1 - Medical history",
        "definition" : "Medical history",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.historyOfConditions",
        "path" : "PatientHistoryCz.medicalHistory.historyOfConditions",
        "short" : "A.2.3.1.1 - History of problems",
        "definition" : "A list of conditions of a patient that the patient suffered in the past or still suffers. Unlike diagnostic summary, medical history is not only a list of problems, but could contain broader description of the condition and its progress, details about treatment including medication and patient response to treatment. Past problem section (unlike the same section of the patient summary) should include only conditions that are important for continuity of care. This section, if provided, complements the diagnostic summary section of the discharge report.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.historyOfConditions.conditionSpecification",
        "path" : "PatientHistoryCz.medicalHistory.historyOfConditions.conditionSpecification",
        "short" : "A.2.3.1.1.1 - Problem description",
        "definition" : "Problem specification",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.historyOfConditions.conditionDetails",
        "path" : "PatientHistoryCz.medicalHistory.historyOfConditions.conditionDetails",
        "short" : "A.2.3.1.1.2 - Problem details",
        "definition" : "Problem details include code that identifies problem, specification of the body structure, laterality, and other aspects of the problem.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.historyOfConditions.onsetDate",
        "path" : "PatientHistoryCz.medicalHistory.historyOfConditions.onsetDate",
        "short" : "A.2.3.1.1.3 - Onset date",
        "definition" : "Onset date of the problem/condition",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.historyOfConditions.endDate",
        "path" : "PatientHistoryCz.medicalHistory.historyOfConditions.endDate",
        "short" : "A.2.3.1.1.4 - End date",
        "definition" : "The date or estimated date that the condition resolved or went into remission.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.historyOfConditions.clinicalStatus",
        "path" : "PatientHistoryCz.medicalHistory.historyOfConditions.clinicalStatus",
        "short" : "A.2.3.1.1.5 - Clinical status",
        "definition" : "Status of the condition/problem (active, resolved, inactive, ...)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.historyOfConditions.resolution",
        "path" : "PatientHistoryCz.medicalHistory.historyOfConditions.resolution",
        "short" : "A.2.3.1.1.6 - Resolution circumstances",
        "definition" : "Describes the reason for which the status of the problem changed from current to inactive (e.g. surgical procedure, medical treatment, etc.). This field includes \"free text\" if the resolution circumstances are not already included in other fields such as surgical procedure, medical device, etc., e.g. hepatic cystectomy (this will be the resolution circumstances for the problem \"hepatic cyst\" and will be included in surgical procedures).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.historyOfConditions.severity",
        "path" : "PatientHistoryCz.medicalHistory.historyOfConditions.severity",
        "short" : "A.2.3.1.1.7 - Severity",
        "definition" : "A subjective assessment of the severity of the condition as evaluated by the clinician.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.historyOfConditions.stage",
        "path" : "PatientHistoryCz.medicalHistory.historyOfConditions.stage",
        "short" : "A.2.3.1.1.8 - Stage",
        "definition" : "Stage/grade, usually assessed formally using a specific staging/grading system.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.medicalDevices",
        "path" : "PatientHistoryCz.medicalHistory.medicalDevices",
        "short" : "A.2.3.1.2 - Devices and Implants",
        "definition" : "Devices and Implants",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.medicalDevices.description",
        "path" : "PatientHistoryCz.medicalHistory.medicalDevices.description",
        "short" : "A.2.3.1.2.1 - Device and implant description",
        "definition" : "Describes the patient's implanted and external medical devices and equipment upon which their health status depends. Includes devices such as cardiac pacemakers, implantable fibrillator, prosthesis, ferromagnetic bone implants, etc. of which the HP needs to be aware.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.medicalDevices.identifier",
        "path" : "PatientHistoryCz.medicalHistory.medicalDevices.identifier",
        "short" : "A.2.3.1.2.2 - Device ID",
        "definition" : "Normalised identifier of the device instance such as UDI according to REGULATION (EU) 2017/745",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.medicalDevices.implantDate",
        "path" : "PatientHistoryCz.medicalHistory.medicalDevices.implantDate",
        "short" : "A.2.3.1.2.3 - Implant date",
        "definition" : "The date and time the device was implanted or when its use began.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.medicalDevices.endDate",
        "path" : "PatientHistoryCz.medicalHistory.medicalDevices.endDate",
        "short" : "A.2.3.1.2.4 - End date",
        "definition" : "Date and time when the device was explanted from the patient or the external device was no longer in use; likewise when the device is planned to be explanted",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.medicalDevices.reason",
        "path" : "PatientHistoryCz.medicalHistory.medicalDevices.reason",
        "short" : "A.2.3.1.2.5 - Reason",
        "definition" : "The medical reason for use of the medical device.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.historyOfProcedures",
        "path" : "PatientHistoryCz.medicalHistory.historyOfProcedures",
        "short" : "A.2.3.1.3 - History of procedures",
        "definition" : "Historical procedures performed on or for a patient, relevant for the current encounter.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.historyOfProcedures.procedureCode",
        "path" : "PatientHistoryCz.medicalHistory.historyOfProcedures.procedureCode",
        "short" : "A.2.3.1.3.1 - Procedure code",
        "definition" : "Procedure code",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.historyOfProcedures.description",
        "path" : "PatientHistoryCz.medicalHistory.historyOfProcedures.description",
        "short" : "A.2.3.1.3.2 - Procedure description",
        "definition" : "Narrative description of the procedure",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.historyOfProcedures.bodySite",
        "path" : "PatientHistoryCz.medicalHistory.historyOfProcedures.bodySite",
        "short" : "A.2.3.1.3.3 - Body site",
        "definition" : "Procedure target body site and laterality",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.historyOfProcedures.date",
        "path" : "PatientHistoryCz.medicalHistory.historyOfProcedures.date",
        "short" : "A.2.3.1.3.4 - Procedure date",
        "definition" : "Date and time when procedure was performed",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.historyOfProcedures.reason",
        "path" : "PatientHistoryCz.medicalHistory.historyOfProcedures.reason",
        "short" : "A.2.3.1.3.5 - Procedure reason",
        "definition" : "The coded reason why the procedure was performed. This may be a coded entity or may simply be present as text.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.historyOfProcedures.outcome",
        "path" : "PatientHistoryCz.medicalHistory.historyOfProcedures.outcome",
        "short" : "A.2.3.1.3.6 - Outcome",
        "definition" : "The outcome of the procedure - did it resolve the reasons for the procedure being performed? Applicable mainly on surgical procedures.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.historyOfProcedures.focalDevice",
        "path" : "PatientHistoryCz.medicalHistory.historyOfProcedures.focalDevice",
        "short" : "A.2.3.1.3.7 - Focal device",
        "definition" : "A reference to the device or devices that is implanted, removed or otherwise manipulated (calibration, battery replacement, fitting a prosthesis, attaching a wound-vac, etc.) as a focal portion of the Procedure.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.vaccination",
        "path" : "PatientHistoryCz.medicalHistory.vaccination",
        "short" : "A.2.3.1.4 - Vaccination",
        "definition" : "Vaccination history of the patient.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.vaccination.diseaseOrAgent",
        "path" : "PatientHistoryCz.medicalHistory.vaccination.diseaseOrAgent",
        "short" : "A.2.3.1.4.1 - Disease or agent targeted",
        "definition" : "Disease or agent that the vaccination provides protection against",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.vaccination.vaccine",
        "path" : "PatientHistoryCz.medicalHistory.vaccination.vaccine",
        "short" : "A.2.3.1.4.2 - Vaccine/prophylaxis",
        "definition" : "Generic description of the vaccine/prophylaxis or its component(s)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.vaccination.productName",
        "path" : "PatientHistoryCz.medicalHistory.vaccination.productName",
        "short" : "A.2.3.1.4.4 - Vaccine medicinal product",
        "definition" : "Medicinal product name",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.vaccination.manufacturerOrMAH",
        "path" : "PatientHistoryCz.medicalHistory.vaccination.manufacturerOrMAH",
        "short" : "A.2.3.1.4.5 - Marketing Authorisation Holder",
        "definition" : "Marketing Authorisation Holder or manufacturer (Identifier and name)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.vaccination.orderNumber",
        "path" : "PatientHistoryCz.medicalHistory.vaccination.orderNumber",
        "short" : "A.2.3.1.4.6 - Number in a series of vaccinations / doses",
        "definition" : "Order in the vaccination course.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.vaccination.vaccinationDate",
        "path" : "PatientHistoryCz.medicalHistory.vaccination.vaccinationDate",
        "short" : "A.2.3.1.4.7 - Date of vaccination",
        "definition" : "The date and time when the vaccination was administered",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.vaccination.nextVaccinationDate",
        "path" : "PatientHistoryCz.medicalHistory.vaccination.nextVaccinationDate",
        "short" : "A.2.3.1.4.8 - Next vaccination date",
        "definition" : "The date when the vaccination is planned to be given/repeated (e.g. next dose)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory",
        "path" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory",
        "short" : "A.2.3.1.5 - Epidemiological history",
        "definition" : "Travel history and infectious contacts",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.infectiousContacts",
        "path" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.infectiousContacts",
        "short" : "A.2.3.1.5.1 - Infectious contacts",
        "definition" : "Infectious contacts of the patient",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.infectiousContacts.period",
        "path" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.infectiousContacts.period",
        "short" : "A.2.3.1.5.1.1 - Time period",
        "definition" : "A date and duration or date time interval of contact. Partial dates are allowed.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.infectiousContacts.infectiousAgent",
        "path" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.infectiousContacts.infectiousAgent",
        "short" : "A.2.3.1.5.1.2 - Infectious agent",
        "definition" : "Information about a suspected infectious agent or agents the person was exposed to.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.infectiousContacts.proximity",
        "path" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.infectiousContacts.proximity",
        "short" : "A.2.3.1.5.1.3 - Proximity",
        "definition" : "Proximity to the source/carrier of the infectious agent during exposure. Proximity could be expressed by text, code (direct, indirect) or value specifying distance from the InfectiousAgentCarrier.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.infectiousContacts.country",
        "path" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.infectiousContacts.country",
        "short" : "A.2.3.1.5.1.4 - Country",
        "definition" : "Country in which the person was potentially exposed to an infectious agent.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.infectiousContacts.note",
        "path" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.infectiousContacts.note",
        "short" : "A.2.3.1.5.1.5 - Additional information",
        "definition" : "A textual note with additional information about infectious contact.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.travelHistory",
        "path" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.travelHistory",
        "short" : "A.2.3.1.5.2 - Travel history",
        "definition" : "Travel history reported by the patient. Multiple records could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.travelHistory.period",
        "path" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.travelHistory.period",
        "short" : "A.2.3.1.5.2.1 - Time period",
        "definition" : "Start and end date or end date and duration of stay in a country. Partial dates are allowed.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.travelHistory.country",
        "path" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.travelHistory.country",
        "short" : "A.2.3.1.5.2.2 - Country visited",
        "definition" : "A country visited by the patient.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.travelHistory.comment",
        "path" : "PatientHistoryCz.medicalHistory.epidemiologicalHistory.travelHistory.comment",
        "short" : "A.2.3.1.5.2.3 - Comment",
        "definition" : "Relevant notes on the travel stay.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.familyHistory",
        "path" : "PatientHistoryCz.familyHistory",
        "short" : "A.2.3.2 - Family history",
        "definition" : "Information about serious illnesses in close blood relatives with known or suspected genetic potential or with possible impact on patient care.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.familyHistory.relationship",
        "path" : "PatientHistoryCz.familyHistory.relationship",
        "short" : "A.2.3.2.1 - Patient relationship",
        "definition" : "The family relation between the related person and the patient.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.familyHistory.birthDate",
        "path" : "PatientHistoryCz.familyHistory.birthDate",
        "short" : "A.2.3.2.2 - Date of birth",
        "definition" : "Full or partial date of birth",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.familyHistory.deathDateOrAge",
        "path" : "PatientHistoryCz.familyHistory.deathDateOrAge",
        "short" : "A.2.3.2.3 - Age or date of death",
        "definition" : "Age or date of the death of the family member.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.familyHistory.conditions",
        "path" : "PatientHistoryCz.familyHistory.conditions",
        "short" : "A.2.3.2.5 - Condition",
        "definition" : "Medical problems this person suffers or suffered.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.familyHistory.causeOfDeath",
        "path" : "PatientHistoryCz.familyHistory.causeOfDeath",
        "short" : "A.2.3.2.6 - Cause of death",
        "definition" : "Information about disease or condition that was the main cause of death.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants",
        "path" : "PatientHistoryCz.socialDeterminants",
        "short" : "A.2.3.3 - Social determinants of health",
        "definition" : "Information about social determinants of health.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants.participationInSociety",
        "path" : "PatientHistoryCz.socialDeterminants.participationInSociety",
        "short" : "A.2.3.3.1 - Participation in society",
        "definition" : "Participation in society details.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants.participationInSociety.workSituation",
        "path" : "PatientHistoryCz.socialDeterminants.participationInSociety.workSituation",
        "short" : "A.2.3.3.1.1 - Work situation",
        "definition" : "Work Situation describes the extent to which and in what way the patient participates in the workforce. Work is meant in the broadest sense of the word: activities that contribute to the person themselves, their environment or society. This includes both paid and unpaid work.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants.participationInSociety.hobby",
        "path" : "PatientHistoryCz.socialDeterminants.participationInSociety.hobby",
        "short" : "A.2.3.3.1.2 - Hobby",
        "definition" : "An activity the patient enjoys doing in their free time.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants.participationInSociety.socailNetwork",
        "path" : "PatientHistoryCz.socialDeterminants.participationInSociety.socailNetwork",
        "short" : "A.2.3.3.1.3 - Social network",
        "definition" : "A description of the patient’s social network, such as family, neighbours and friends.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants.education",
        "path" : "PatientHistoryCz.socialDeterminants.education",
        "short" : "A.2.3.3.2 - Education",
        "definition" : "Education",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants.education.level",
        "path" : "PatientHistoryCz.socialDeterminants.education.level",
        "short" : "A.2.3.3.2.1 - Education level",
        "definition" : "Indication of the highest level of education achieved.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants.education.comment",
        "path" : "PatientHistoryCz.socialDeterminants.education.comment",
        "short" : "A.2.3.3.2.2 - Comment",
        "definition" : "If deemed relevant, a specification of the degree program can be provided by means of an explanation (e.g.: patient is in medical school).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants.livingSituation",
        "path" : "PatientHistoryCz.socialDeterminants.livingSituation",
        "short" : "A.2.3.3.3 - Living situation",
        "definition" : "Household type and other related living situation information.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants.livingSituation.houseType",
        "path" : "PatientHistoryCz.socialDeterminants.livingSituation.houseType",
        "short" : "A.2.3.3.3.1 - House type",
        "definition" : "Type of home the patient lives in.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants.livingSituation.homeAdaption",
        "path" : "PatientHistoryCz.socialDeterminants.livingSituation.homeAdaption",
        "short" : "A.2.3.3.3.2 - Home adaption",
        "definition" : "Adaptions present in the home that have been made in the context of the illness or disability to make the functioning of the patient safer and more comfortable and to enable independent living. Multiple data elements could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants.livingSituation.livingConditions",
        "path" : "PatientHistoryCz.socialDeterminants.livingSituation.livingConditions",
        "short" : "A.2.3.3.3.3 - Living conditions",
        "definition" : "Conditions that affect the accessibility of the home or the stay in the home. Multiple data elements could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants.familySituation",
        "path" : "PatientHistoryCz.socialDeterminants.familySituation",
        "short" : "A.2.3.3.4 - Family situation",
        "definition" : "Family situation details.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants.familySituation.comment",
        "path" : "PatientHistoryCz.socialDeterminants.familySituation.comment",
        "short" : "A.2.3.3.4.1 - Comment",
        "definition" : "A comment on the family situation.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants.familySituation.familyComposition",
        "path" : "PatientHistoryCz.socialDeterminants.familySituation.familyComposition",
        "short" : "A.2.3.3.4.2 - Family composition",
        "definition" : "The family composition describes the patient’s home situation and the form of cohabitation.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants.familySituation.maritalStatus",
        "path" : "PatientHistoryCz.socialDeterminants.familySituation.maritalStatus",
        "short" : "A.2.3.3.4.3 - Marital status",
        "definition" : "A person’s marital status according to the terms and definition in the national civil code.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants.familySituation.numberOfChildren",
        "path" : "PatientHistoryCz.socialDeterminants.familySituation.numberOfChildren",
        "short" : "A.2.3.3.4.4 - Number of children",
        "definition" : "The number of children the patient has. Children in the context of this information model include step children, foster children, biological and adopted children.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants.familySituation.numberOfChildrenAtHome",
        "path" : "PatientHistoryCz.socialDeterminants.familySituation.numberOfChildrenAtHome",
        "short" : "A.2.3.3.4.5 - Number of children at home",
        "definition" : "The number of children living at home with the patient.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants.familySituation.childDetails",
        "path" : "PatientHistoryCz.socialDeterminants.familySituation.childDetails",
        "short" : "A.2.3.3.4.6 - Child details",
        "definition" : "Child age, co-living status and comment. Multiple child details could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.socialDeterminants.familySituation.careResponsibility",
        "path" : "PatientHistoryCz.socialDeterminants.familySituation.careResponsibility",
        "short" : "A.2.3.3.4.7 - Care responsibility",
        "definition" : "The activities the patient carries out to care for a dependent family member.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.useOfSubstances",
        "path" : "PatientHistoryCz.useOfSubstances",
        "short" : "A.2.3.4 - Use of substances",
        "definition" : "Use of substances",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.useOfSubstances.alcohol",
        "path" : "PatientHistoryCz.useOfSubstances.alcohol",
        "short" : "A.2.3.4.1 - Alcohol use",
        "definition" : "Alcohol consumption by the patient. Multiple records on alcohol use could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.useOfSubstances.alcohol.currentStatus",
        "path" : "PatientHistoryCz.useOfSubstances.alcohol.currentStatus",
        "short" : "A.2.3.4.1.1 - Status",
        "definition" : "The status of the patient’s alcohol use.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.useOfSubstances.alcohol.periodAndQuantity",
        "path" : "PatientHistoryCz.useOfSubstances.alcohol.periodAndQuantity",
        "short" : "A.2.3.4.1.2 - Period and quantity",
        "definition" : "Period of use and amount (The extent of the patient’s alcohol use in units of alcohol per time period.)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.useOfSubstances.alcohol.comment",
        "path" : "PatientHistoryCz.useOfSubstances.alcohol.comment",
        "short" : "A.2.3.4.1.3 - Comment",
        "definition" : "Textual comment.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.useOfSubstances.tobacco",
        "path" : "PatientHistoryCz.useOfSubstances.tobacco",
        "short" : "A.2.3.4.2 - Tobacco use",
        "definition" : "Represent smoking or tobacco habits. Multiple records on tobacco use could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.useOfSubstances.tobacco.currentStatus",
        "path" : "PatientHistoryCz.useOfSubstances.tobacco.currentStatus",
        "short" : "A.2.3.4.2.1 - Status",
        "definition" : "The status of the patient’s tobacco use.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.useOfSubstances.tobacco.periodAndQuantity",
        "path" : "PatientHistoryCz.useOfSubstances.tobacco.periodAndQuantity",
        "short" : "A.2.3.4.2.2 - Period and quantity",
        "definition" : "Period of use and amount (The extent of the patient’s tobacco use in units of alcohol per time period.)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.useOfSubstances.tobacco.comment",
        "path" : "PatientHistoryCz.useOfSubstances.tobacco.comment",
        "short" : "A.2.3.4.2.3 - Comment",
        "definition" : "Textual comment.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.useOfSubstances.drugConsumption",
        "path" : "PatientHistoryCz.useOfSubstances.drugConsumption",
        "short" : "A.2.3.4.3 - Drug consumption",
        "definition" : "Consumption of drugs and other substances (in terms of abuse).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.useOfSubstances.drugConsumption.currentStatus",
        "path" : "PatientHistoryCz.useOfSubstances.drugConsumption.currentStatus",
        "short" : "A.2.3.4.3.1 - Status",
        "definition" : "The status of the patient’s drug use.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.useOfSubstances.drugConsumption.periodAndQuantity",
        "path" : "PatientHistoryCz.useOfSubstances.drugConsumption.periodAndQuantity",
        "short" : "A.2.3.4.3.2 - Period and quantity",
        "definition" : "Period of use and amount.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.useOfSubstances.drugConsumption.drugType",
        "path" : "PatientHistoryCz.useOfSubstances.drugConsumption.drugType",
        "short" : "A.2.3.4.3.3 - Drug or medication type",
        "definition" : "Type of the drug consumption",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.useOfSubstances.drugConsumption.route",
        "path" : "PatientHistoryCz.useOfSubstances.drugConsumption.route",
        "short" : "A.2.3.4.3.4 - Route of administration",
        "definition" : "Route or routes of administration",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientHistoryCz.useOfSubstances.drugConsumption.comment",
        "path" : "PatientHistoryCz.useOfSubstances.drugConsumption.comment",
        "short" : "A.2.3.4.3.5 - Comment",
        "definition" : "Textual comment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
