# A.2.7 - Terapie - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.7 - Terapie**

## Logical Model: A.2.7 - Terapie 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/LogTherapyEmsCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogCzTherapyEmsCz |

 
Zpráva o výjezdu ZZS - Terapie. 

**Usages:**

* Use this Logical Model: [A - Zpráva o výjezdu (cz)](StructureDefinition-LogEmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/LogTherapyEmsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogTherapyEmsCz.csv), [Excel](StructureDefinition-LogTherapyEmsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogTherapyEmsCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogTherapyEmsCz",
  "version" : "0.0.2",
  "name" : "LogCzTherapyEmsCz",
  "title" : "A.2.7 - Terapie",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Zpráva o výjezdu ZZS - Terapie.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogTherapyEmsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogTherapyEmsCz",
        "path" : "LogTherapyEmsCz",
        "short" : "A.2.7 - Terapie",
        "definition" : "Zpráva o výjezdu ZZS - Terapie."
      },
      {
        "id" : "LogTherapyEmsCz.vykony",
        "path" : "LogTherapyEmsCz.vykony",
        "short" : "A.2.7.1 - Výkony",
        "definition" : "Zdravotnické výkony dle čísleníku ZZS.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogTherapyEmsCz.vykony.nazev",
        "path" : "LogTherapyEmsCz.vykony.nazev",
        "short" : "A.2.7.1.1 - Název výkonu",
        "definition" : "Název výkonu dle číselníku ZZS.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogTherapyEmsCz.vykony.datum",
        "path" : "LogTherapyEmsCz.vykony.datum",
        "short" : "A.2.7.1.2 - Datum a čas provedení",
        "definition" : "Datum a čas provedení výkonu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogTherapyEmsCz.zdravotnickeProstredky",
        "path" : "LogTherapyEmsCz.zdravotnickeProstredky",
        "short" : "A.2.7.2 - Zdravotnické prostředky",
        "definition" : "Evidence použitých zdravotnických prostředků (PZT).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogTherapyEmsCz.zdravotnickeProstredky.popis",
        "path" : "LogTherapyEmsCz.zdravotnickeProstredky.popis",
        "short" : "A.2.7.2.1 - Popis zdravotnického prostředku",
        "definition" : "Popis zdravotnického prostředku použitého při zásahu volným textem a/nebo kódem.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogTherapyEmsCz.zdravotnickeProstredky.id",
        "path" : "LogTherapyEmsCz.zdravotnickeProstredky.id",
        "short" : "A.2.7.2.2 - Identifikátor prostředku",
        "definition" : "Normalizovaný identifikátor, např. UDI, dle nařízení EU 2017/745.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogTherapyEmsCz.medikace",
        "path" : "LogTherapyEmsCz.medikace",
        "short" : "A.2.7.3 - Medikace",
        "definition" : "Medikamentózní léčba v průběhu ošetření.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogTherapyEmsCz.medikace.kodSUKL",
        "path" : "LogTherapyEmsCz.medikace.kodSUKL",
        "short" : "A.2.7.3.1 - Kód SUKL",
        "definition" : "Kód léčiva dle databáze SÚKL.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogTherapyEmsCz.medikace.nazevLecivehoPripravku",
        "path" : "LogTherapyEmsCz.medikace.nazevLecivehoPripravku",
        "short" : "A.2.7.3.2 - Název léčivého přípravku",
        "definition" : "Registrovaný název léčiva dle databáze léčivých přípravků.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogTherapyEmsCz.medikace.skupinaATC",
        "path" : "LogTherapyEmsCz.medikace.skupinaATC",
        "short" : "A.2.7.3.3 - ATC skupina",
        "definition" : "ATC skupina podaného léčiva.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogTherapyEmsCz.medikace.aktivniLatky",
        "path" : "LogTherapyEmsCz.medikace.aktivniLatky",
        "short" : "A.2.7.3.4 - Aktivní látky",
        "definition" : "Seznam aktivních látek v léčivu odvozený od záznamu HVLP nebo IVLP přípravku v databázi SUKL (DLP). Aktivní látky jsou uváděny názvem a případně také kódem DLP.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogTherapyEmsCz.medikace.sila",
        "path" : "LogTherapyEmsCz.medikace.sila",
        "short" : "A.2.7.3.5 - Síla",
        "definition" : "Síla aktivní léčivé látky obsažené v léčivém přípravku. Síla se vyjadřuje ve vztahu k jednotce podání. Např. 500mg v tabletě.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "LogTherapyEmsCz.medikace.formaLeciva",
        "path" : "LogTherapyEmsCz.medikace.formaLeciva",
        "short" : "A.2.7.3.6 - Forma léčiva",
        "definition" : "Léková forma obsažená v balení vyjádřená kódem. Např. Sirup, tableta apod.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogTherapyEmsCz.medikace.podaneMnozstvi",
        "path" : "LogTherapyEmsCz.medikace.podaneMnozstvi",
        "short" : "A.2.7.3.7 - Dávkování",
        "definition" : "Počet jednotek podání volným textem nebo formalizovaně.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "LogTherapyEmsCz.medikace.cestaPodani",
        "path" : "LogTherapyEmsCz.medikace.cestaPodani",
        "short" : "A.2.7.3.8 - Cesta podání",
        "definition" : "Cesta podání",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogTherapyEmsCz.medikace.datumPodani",
        "path" : "LogTherapyEmsCz.medikace.datumPodani",
        "short" : "A.2.7.3.9 - Datum a čas podání",
        "definition" : "Datum a čas podání.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
