# A.1 – Hlavička dokumentu (cz) - HL7 Czech EMS Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1 – Hlavička dokumentu (cz)**

## Logical Model: A.1 – Hlavička dokumentu (cz) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/cz-ems/StructureDefinition/LogHeaderEmsCz | *Version*:0.0.2 |
| Draft as of 2025-10-14 | *Computable Name*:LogCzHeaderEmsCz |

 
Zpráva o výjezdu - Struktura hlavičky zprávy o výjezdu podle tabulky části. CZ 

**Usages:**

* Use this Logical Model: [A - Zpráva o výjezdu (cz)](StructureDefinition-LogEmsReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.ems|current/StructureDefinition/LogHeaderEmsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogHeaderEmsCz.csv), [Excel](StructureDefinition-LogHeaderEmsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogHeaderEmsCz",
  "url" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogHeaderEmsCz",
  "version" : "0.0.2",
  "name" : "LogCzHeaderEmsCz",
  "title" : "A.1 – Hlavička dokumentu (cz)",
  "status" : "draft",
  "date" : "2025-10-14T13:52:10+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Zpráva o výjezdu - Struktura hlavičky zprávy o výjezdu podle tabulky části. CZ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/cz-ems/StructureDefinition/LogHeaderEmsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogHeaderEmsCz",
        "path" : "LogHeaderEmsCz",
        "short" : "A.1 – Hlavička dokumentu (cz)",
        "definition" : "Zpráva o výjezdu - Struktura hlavičky zprávy o výjezdu podle tabulky části. CZ"
      },
      {
        "id" : "LogHeaderEmsCz.pacient",
        "path" : "LogHeaderEmsCz.pacient",
        "short" : "A.1.1 Identifikace pacienta",
        "definition" : "Identifikace pacienta – křestní jméno, příjmení, datum narození, identifikátory, státní občanství, úřední pohlaví, komunikační jazyk.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.pacient.jmeno",
        "path" : "LogHeaderEmsCz.pacient.jmeno",
        "short" : "A.1.1.1 Křestní jméno",
        "definition" : "Křestní jméno pacienta.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.pacient.prijmeni",
        "path" : "LogHeaderEmsCz.pacient.prijmeni",
        "short" : "A.1.1.2 Příjmení",
        "definition" : "Příjmení pacienta.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.pacient.datumNarozeni",
        "path" : "LogHeaderEmsCz.pacient.datumNarozeni",
        "short" : "A.1.1.3 Datum narození",
        "definition" : "Datum, případně i čas narození pacienta.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.pacient.idPacienta",
        "path" : "LogHeaderEmsCz.pacient.idPacienta",
        "short" : "A.1.1.4 Identifikátor pacienta",
        "definition" : "Unikátní identifikátor osoby – RID, DRID, číslo pasu atd.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.pacient.narodnost",
        "path" : "LogHeaderEmsCz.pacient.narodnost",
        "short" : "A.1.1.5 Státní občanství",
        "definition" : "Státní občanství podle zákona 186/2013 Sb.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.pacient.pohlavi",
        "path" : "LogHeaderEmsCz.pacient.pohlavi",
        "short" : "A.1.1.6 Úřední pohlaví",
        "definition" : "Administrativní pohlaví podle dokladů.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.pacient.jazyk",
        "path" : "LogHeaderEmsCz.pacient.jazyk",
        "short" : "A.1.1.7 Komunikační jazyk",
        "definition" : "Jazyk nebo jazyky, jimiž pacient komunikuje.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.kontakt",
        "path" : "LogHeaderEmsCz.kontakt",
        "short" : "A.1.2 Kontaktní informace pacienta",
        "definition" : "Kontaktní údaje pacienta, včetně adresy, kontaktů a preferovaného lékaře.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.kontakt.adresa",
        "path" : "LogHeaderEmsCz.kontakt.adresa",
        "short" : "A.1.2.1 Adresa",
        "definition" : "Poštovní adresa (řádky adresy, město, PSČ, země).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.kontakt.telefon",
        "path" : "LogHeaderEmsCz.kontakt.telefon",
        "short" : "A.1.2.2 Telekomunikační kontakt",
        "definition" : "Telefon, e-mail apod.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.kontakt.preferovanyLekar",
        "path" : "LogHeaderEmsCz.kontakt.preferovanyLekar",
        "short" : "A.1.2.3 Preferovaný lékař",
        "definition" : "Identifikace preferovaného lékaře, u kterého je pacient evidován.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.kontakt.preferovanyLekar.idLekare",
        "path" : "LogHeaderEmsCz.kontakt.preferovanyLekar.idLekare",
        "short" : "A.1.2.3.1 Identifikátor lékaře",
        "definition" : "Identifikační číslo lékaře dle NR-ZP.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.kontakt.preferovanyLekar.jmenoLekare",
        "path" : "LogHeaderEmsCz.kontakt.preferovanyLekar.jmenoLekare",
        "short" : "A.1.2.3.2 Jméno lékaře",
        "definition" : "Plné jméno lékaře.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.kontakt.preferovanyLekar.specializace",
        "path" : "LogHeaderEmsCz.kontakt.preferovanyLekar.specializace",
        "short" : "A.1.2.3.3 Specializace",
        "definition" : "Specializace lékaře podle číselníku NR-ZP.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.kontakt.preferovanyLekar.idPoskytovatele",
        "path" : "LogHeaderEmsCz.kontakt.preferovanyLekar.idPoskytovatele",
        "short" : "A.1.2.3.4 ID a název poskytovatele",
        "definition" : "Identifikátor a název poskytovatele, kterého lékař reprezentuje.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.kontakt.preferovanyLekar.adresaPoskytovatele",
        "path" : "LogHeaderEmsCz.kontakt.preferovanyLekar.adresaPoskytovatele",
        "short" : "A.1.2.3.5 Adresa poskytovatele",
        "definition" : "Poštovní adresa poskytovatele zdravotní péče.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.kontakt.preferovanyLekar.kontaktPoskytovatele",
        "path" : "LogHeaderEmsCz.kontakt.preferovanyLekar.kontaktPoskytovatele",
        "short" : "A.1.2.3.6 Telekomunikační kontakt",
        "definition" : "Telefon nebo e-mail poskytovatele.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.kontakt.kontaktniOsoba",
        "path" : "LogHeaderEmsCz.kontakt.kontaktniOsoba",
        "short" : "A.1.2.4 Zákonný zástupce a kontaktní osoba",
        "definition" : "Kontaktní osoba – např. zákonný zástupce nebo jiná blízká osoba.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.kontakt.kontaktniOsoba.typ",
        "path" : "LogHeaderEmsCz.kontakt.kontaktniOsoba.typ",
        "short" : "A.1.2.4.1 Typ kontaktu",
        "definition" : "Typ kontaktní osoby – zákonný zástupce, emergentní kontakt apod.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.kontakt.kontaktniOsoba.vztah",
        "path" : "LogHeaderEmsCz.kontakt.kontaktniOsoba.vztah",
        "short" : "A.1.2.4.2 Vztah k pacientovi",
        "definition" : "Rodinný nebo jiný vztah ke kontaktované osobě.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.kontakt.kontaktniOsoba.idOsoby",
        "path" : "LogHeaderEmsCz.kontakt.kontaktniOsoba.idOsoby",
        "short" : "A.1.2.4.3 Id osoby",
        "definition" : "Unikátní identifikátor kontaktní osoby.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.kontakt.kontaktniOsoba.jmeno",
        "path" : "LogHeaderEmsCz.kontakt.kontaktniOsoba.jmeno",
        "short" : "A.1.2.4.4 Křestní jméno",
        "definition" : "Křestní jméno kontaktní osoby.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.kontakt.kontaktniOsoba.prijmeni",
        "path" : "LogHeaderEmsCz.kontakt.kontaktniOsoba.prijmeni",
        "short" : "A.1.2.4.5 Příjmení",
        "definition" : "Příjmení kontaktní osoby.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.kontakt.kontaktniOsoba.adresa",
        "path" : "LogHeaderEmsCz.kontakt.kontaktniOsoba.adresa",
        "short" : "A.1.2.4.6 Adresa kontaktní osoby",
        "definition" : "Adresa kontaktní osoby.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.kontakt.kontaktniOsoba.kontakt",
        "path" : "LogHeaderEmsCz.kontakt.kontaktniOsoba.kontakt",
        "short" : "A.1.2.4.7 Telekomunikační kontakt",
        "definition" : "Telefon, e-mail apod.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.pojistovna",
        "path" : "LogHeaderEmsCz.pojistovna",
        "short" : "A.1.3 Zdravotní pojištění",
        "definition" : "Informace o pojištění pacienta.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.pojistovna.kodPojistovny",
        "path" : "LogHeaderEmsCz.pojistovna.kodPojistovny",
        "short" : "A.1.3.1 Kód zdravotní pojišťovny",
        "definition" : "Kód zdravotní pojišťovny.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.pojistovna.nazev",
        "path" : "LogHeaderEmsCz.pojistovna.nazev",
        "short" : "A.1.3.2 Název zdravotní pojišťovny",
        "definition" : "Oficiální název pojišťovny.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.pojistovna.cisloPojistence",
        "path" : "LogHeaderEmsCz.pojistovna.cisloPojistence",
        "short" : "A.1.3.3 Číslo zdravotního pojištění",
        "definition" : "Číslo pojištěnce.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.prijemce",
        "path" : "LogHeaderEmsCz.prijemce",
        "short" : "A.1.4 Příjemce dokumentu",
        "definition" : "Zamýšlený příjemce zprávy o výjezdu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.prijemce.idPrijemce",
        "path" : "LogHeaderEmsCz.prijemce.idPrijemce",
        "short" : "A.1.4.1 ID příjemce",
        "definition" : "Identifikační číslo zdravotnického pracovníka nebo osobní identifikátor pacienta.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.prijemce.jmeno",
        "path" : "LogHeaderEmsCz.prijemce.jmeno",
        "short" : "A.1.4.2 Jméno příjemce",
        "definition" : "Jméno a příjmení osoby příjemce.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.prijemce.idOrganizace",
        "path" : "LogHeaderEmsCz.prijemce.idOrganizace",
        "short" : "A.1.4.3 ID organizace příjemce",
        "definition" : "Identifikátor organizace příjemce (např. NRPZS, IČO).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.prijemce.organizace",
        "path" : "LogHeaderEmsCz.prijemce.organizace",
        "short" : "A.1.4.4 Organizace příjemce",
        "definition" : "Název a identifikační údaje zařízení nebo pracoviště příjemce.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.autor",
        "path" : "LogHeaderEmsCz.autor",
        "short" : "A.1.5 Autor dokumentu",
        "definition" : "Osoba nebo systém, který dokument vytvořil.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.autor.idAutor",
        "path" : "LogHeaderEmsCz.autor.idAutor",
        "short" : "A.1.5.1 Identifikátor autora",
        "definition" : "Identifikační číslo autora (zdravotnický pracovník nebo IS).",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.autor.jmeno",
        "path" : "LogHeaderEmsCz.autor.jmeno",
        "short" : "A.1.5.2 Jméno autora",
        "definition" : "Jméno osoby nebo systému, který dokument sestavil.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.autor.idOrganizace",
        "path" : "LogHeaderEmsCz.autor.idOrganizace",
        "short" : "A.1.5.3 ID organizace",
        "definition" : "Identifikátor organizace, kterou autor reprezentuje.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.autor.organizace",
        "path" : "LogHeaderEmsCz.autor.organizace",
        "short" : "A.1.5.4 Organizace autora",
        "definition" : "Název organizace, kterou autor reprezentuje.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.autor.datum",
        "path" : "LogHeaderEmsCz.autor.datum",
        "short" : "A.1.5.5 Datum a čas uložení",
        "definition" : "Datum a čas poslední modifikace dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.metadata",
        "path" : "LogHeaderEmsCz.metadata",
        "short" : "A.1.6 Metadata dokumentu",
        "definition" : "Technická metadata dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.metadata.dokumentId",
        "path" : "LogHeaderEmsCz.metadata.dokumentId",
        "short" : "A.1.6.1 ID dokumentu",
        "definition" : "Jedinečný identifikátor dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.metadata.kategorie",
        "path" : "LogHeaderEmsCz.metadata.kategorie",
        "short" : "A.1.6.2 Kategorie dokumentu",
        "definition" : "Kategorie EHR.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.metadata.stav",
        "path" : "LogHeaderEmsCz.metadata.stav",
        "short" : "A.1.6.3 Stav dokumentu",
        "definition" : "Stav dokumentu – předběžný, finální apod.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.metadata.vytvoreni",
        "path" : "LogHeaderEmsCz.metadata.vytvoreni",
        "short" : "A.1.6.4 Datum a čas vytvoření",
        "definition" : "Datum a čas vytvoření dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.metadata.nazevDokumentu",
        "path" : "LogHeaderEmsCz.metadata.nazevDokumentu",
        "short" : "A.1.6.5 Název dokumentu",
        "definition" : "Název dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.metadata.spravce",
        "path" : "LogHeaderEmsCz.metadata.spravce",
        "short" : "A.1.6.6 Správce dokumentu",
        "definition" : "Technický správce dokumentu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.metadata.duveryhodnost",
        "path" : "LogHeaderEmsCz.metadata.duveryhodnost",
        "short" : "A.1.6.7 Důvěrnost dokumentu",
        "definition" : "Stupeň důvěrnosti dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.metadata.jazyk",
        "path" : "LogHeaderEmsCz.metadata.jazyk",
        "short" : "A.1.6.8 Jazyk dokumentu",
        "definition" : "Jazyk dokumentu dle ISO kódu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.metadata.verze",
        "path" : "LogHeaderEmsCz.metadata.verze",
        "short" : "A.1.6.9 Verze",
        "definition" : "Verze dokumentu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.podpis",
        "path" : "LogHeaderEmsCz.podpis",
        "short" : "A.1.7 Elektronické podpisy",
        "definition" : "Elektronické podepsání dokumentu dle zákona.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.podpis.elektronickyPodpis",
        "path" : "LogHeaderEmsCz.podpis.elektronickyPodpis",
        "short" : "A.1.7.1 Elektronický podpis",
        "definition" : "Elektronický podpis nebo pečeť dokumentu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderEmsCz.podpis.casoveRazitko",
        "path" : "LogHeaderEmsCz.podpis.casoveRazitko",
        "short" : "A.1.7.2 Časové razítko",
        "definition" : "Elektronické časové razítko.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "instant"
          }
        ]
      }
    ]
  }
}

```
